/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.base.request;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import pro.gravit.launcher.base.events.request.AuthRequestEvent;
import pro.gravit.launcher.base.events.request.CurrentUserRequestEvent;
import pro.gravit.launcher.base.events.request.RefreshTokenRequestEvent;
import pro.gravit.launcher.base.events.request.RestoreRequestEvent;
import pro.gravit.launcher.base.request.RequestException;
import pro.gravit.launcher.base.request.RequestService;
import pro.gravit.launcher.base.request.WebSocketEvent;
import pro.gravit.launcher.base.request.auth.RefreshTokenRequest;
import pro.gravit.launcher.base.request.auth.RestoreRequest;
import pro.gravit.launcher.base.request.websockets.StdWebSocketService;
import pro.gravit.launcher.base.request.websockets.WebSocketRequest;
import pro.gravit.launcher.core.LauncherNetworkAPI;
import pro.gravit.utils.helper.LogHelper;

public abstract class Request<R extends WebSocketEvent>
implements WebSocketRequest {
    private static final List<ExtendedTokenCallback> extendedTokenCallbacks = new ArrayList<ExtendedTokenCallback>(4);
    private static final List<BiConsumer<String, AuthRequestEvent.OAuthRequestEvent>> oauthChangeHandlers = new ArrayList<BiConsumer<String, AuthRequestEvent.OAuthRequestEvent>>(4);
    private static volatile RequestService requestService;
    private static volatile AuthRequestEvent.OAuthRequestEvent oauth;
    private static volatile Map<String, ExtendedToken> extendedTokens;
    private static volatile String authId;
    private static volatile long tokenExpiredTime;
    private static volatile ScheduledExecutorService executorService;
    private static volatile boolean autoRefreshRunning;
    @LauncherNetworkAPI
    public final UUID requestUUID = UUID.randomUUID();
    private final transient AtomicBoolean started = new AtomicBoolean(false);

    public static synchronized void startAutoRefresh() {
        if (!autoRefreshRunning) {
            if (executorService == null) {
                executorService = Executors.newSingleThreadScheduledExecutor(t -> {
                    Thread thread = new Thread(t);
                    thread.setName("AutoRefresh thread");
                    thread.setDaemon(true);
                    return thread;
                });
            }
            executorService.scheduleAtFixedRate(() -> {
                try {
                    Request.restore(false, true, false);
                }
                catch (Exception e) {
                    LogHelper.error((Throwable)e);
                }
            }, 5L, 5L, TimeUnit.SECONDS);
            autoRefreshRunning = true;
        }
    }

    public static RequestService getRequestService() {
        return requestService;
    }

    public static void setRequestService(RequestService service) {
        requestService = service;
    }

    public static boolean isAvailable() {
        return requestService != null;
    }

    public static void setOAuth(String authId, AuthRequestEvent.OAuthRequestEvent event) {
        oauth = event;
        Request.authId = authId;
        tokenExpiredTime = oauth != null && Request.oauth.expire != 0L ? System.currentTimeMillis() + Request.oauth.expire : 0L;
        for (BiConsumer<String, AuthRequestEvent.OAuthRequestEvent> handler : oauthChangeHandlers) {
            handler.accept(authId, event);
        }
    }

    public static AuthRequestEvent.OAuthRequestEvent getOAuth() {
        return oauth;
    }

    public static String getAuthId() {
        return authId;
    }

    public static Map<String, ExtendedToken> getExtendedTokens() {
        if (extendedTokens != null) {
            return Collections.unmodifiableMap(extendedTokens);
        }
        return null;
    }

    public static Map<String, String> getStringExtendedTokens() {
        if (extendedTokens != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (Map.Entry<String, ExtendedToken> e : extendedTokens.entrySet()) {
                map.put(e.getKey(), e.getValue().token);
            }
            return map;
        }
        return null;
    }

    public static void clearExtendedTokens() {
        if (extendedTokens != null) {
            extendedTokens.clear();
        }
    }

    public static void addExtendedToken(String name, ExtendedToken token) {
        if (extendedTokens == null) {
            extendedTokens = new ConcurrentHashMap<String, ExtendedToken>();
        }
        extendedTokens.put(name, token);
    }

    public static void addAllExtendedToken(Map<String, ExtendedToken> map) {
        if (extendedTokens == null) {
            extendedTokens = new ConcurrentHashMap<String, ExtendedToken>();
        }
        extendedTokens.putAll(map);
    }

    public static void setOAuth(String authId, AuthRequestEvent.OAuthRequestEvent event, long tokenExpiredTime) {
        oauth = event;
        Request.authId = authId;
        Request.tokenExpiredTime = tokenExpiredTime;
    }

    public static boolean isTokenExpired() {
        if (oauth == null) {
            return true;
        }
        if (tokenExpiredTime == 0L) {
            return false;
        }
        return System.currentTimeMillis() > tokenExpiredTime;
    }

    public static long getTokenExpiredTime() {
        return tokenExpiredTime;
    }

    public static String getAccessToken() {
        return oauth == null ? null : Request.oauth.accessToken;
    }

    public static String getRefreshToken() {
        return oauth == null ? null : Request.oauth.refreshToken;
    }

    public static void reconnect() throws Exception {
        Request.getRequestService().connect();
        Request.restore();
    }

    public static RequestRestoreReport restore() throws Exception {
        return Request.restore(false, false, false);
    }

    private static synchronized Map<String, String> getExpiredExtendedTokens() {
        if (extendedTokens == null) {
            return new HashMap<String, String>();
        }
        HashSet<String> set = new HashSet<String>();
        for (Map.Entry<String, ExtendedToken> e : extendedTokens.entrySet()) {
            if (e.getValue().expire == 0L || e.getValue().expire >= System.currentTimeMillis()) continue;
            set.add(e.getKey());
        }
        if (set.isEmpty()) {
            return new HashMap<String, String>();
        }
        return Request.makeNewTokens(set);
    }

    public static synchronized RequestRestoreReport restore(boolean needUserInfo, boolean refreshOnly, boolean noRefresh) throws Exception {
        boolean refreshed = false;
        if (oauth != null && (Request.isTokenExpired() || Request.oauth.accessToken == null)) {
            if (noRefresh) {
                oauth = null;
            } else {
                RefreshTokenRequest refreshRequest = new RefreshTokenRequest(authId, Request.oauth.refreshToken);
                RefreshTokenRequestEvent event = (RefreshTokenRequestEvent)refreshRequest.request();
                Request.setOAuth(authId, event.oauth);
                refreshed = true;
            }
        }
        RestoreRequest request = oauth != null ? new RestoreRequest(authId, Request.oauth.accessToken, refreshOnly ? Request.getExpiredExtendedTokens() : Request.getStringExtendedTokens(), needUserInfo) : new RestoreRequest(authId, null, refreshOnly ? Request.getExpiredExtendedTokens() : Request.getStringExtendedTokens(), false);
        if (refreshOnly && (request.extended == null || request.extended.isEmpty())) {
            return new RequestRestoreReport(refreshed, null, null);
        }
        RestoreRequestEvent event = (RestoreRequestEvent)request.request();
        List<String> invalidTokens = null;
        if (event.invalidTokens != null && !event.invalidTokens.isEmpty()) {
            Map<String, String> tokens = Request.makeNewTokens(event.invalidTokens);
            if (!tokens.isEmpty()) {
                request = new RestoreRequest(authId, null, tokens, false);
                event = (RestoreRequestEvent)request.request();
                if (event.invalidTokens != null && !event.invalidTokens.isEmpty()) {
                    LogHelper.warning((String)"Tokens %s not restored", (Object[])new Object[]{String.join((CharSequence)",", event.invalidTokens)});
                }
            }
            invalidTokens = event.invalidTokens;
        }
        return new RequestRestoreReport(refreshed, invalidTokens, event.userInfo);
    }

    private static synchronized Map<String, String> makeNewTokens(Collection<String> keys) {
        HashMap<String, String> tokens = new HashMap<String, String>();
        for (ExtendedTokenCallback cb : extendedTokenCallbacks) {
            for (String tokenName : keys) {
                ExtendedToken newToken = cb.tryGetNewToken(tokenName);
                if (newToken == null) continue;
                tokens.put(tokenName, newToken.token);
                Request.addExtendedToken(tokenName, newToken);
            }
        }
        return tokens;
    }

    public static void requestError(String message) throws RequestException {
        throw new RequestException(message);
    }

    public void addExtendedTokenCallback(ExtendedTokenCallback cb) {
        extendedTokenCallbacks.add(cb);
    }

    public void removeExtendedTokenCallback(ExtendedTokenCallback cb) {
        extendedTokenCallbacks.remove(cb);
    }

    public void addOAuthChangeHandler(BiConsumer<String, AuthRequestEvent.OAuthRequestEvent> eventHandler) {
        oauthChangeHandlers.add(eventHandler);
    }

    public void removeOAuthChangeHandler(BiConsumer<String, AuthRequestEvent.OAuthRequestEvent> eventHandler) {
        oauthChangeHandlers.remove(eventHandler);
    }

    public R request() throws Exception {
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException("Request already started");
        }
        if (!Request.isAvailable()) {
            throw new RequestException("RequestService not initialized");
        }
        return this.requestDo(requestService);
    }

    @Deprecated
    public R request(StdWebSocketService service) throws Exception {
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException("Request already started");
        }
        return this.requestDo(service);
    }

    public R request(RequestService service) throws Exception {
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException("Request already started");
        }
        return this.requestDo(service);
    }

    protected R requestDo(RequestService service) throws Exception {
        return (R)service.requestSync(this);
    }

    public static class ExtendedToken {
        public final String token;
        public final long expire;

        public ExtendedToken(String token, long expire) {
            this.token = token;
            long time = System.currentTimeMillis();
            this.expire = expire < time / 2L ? time + expire : expire;
        }
    }

    public static class RequestRestoreReport {
        public final boolean refreshed;
        public final List<String> invalidExtendedTokens;
        public final CurrentUserRequestEvent.UserInfo userInfo;

        public RequestRestoreReport(boolean refreshed, List<String> invalidExtendedTokens, CurrentUserRequestEvent.UserInfo userInfo) {
            this.refreshed = refreshed;
            this.invalidExtendedTokens = invalidExtendedTokens;
            this.userInfo = userInfo;
        }
    }

    public static interface ExtendedTokenCallback {
        public ExtendedToken tryGetNewToken(String var1);
    }
}

