/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.core.backend;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import pro.gravit.launcher.core.api.features.ProfileFeatureAPI;
import pro.gravit.launcher.core.api.method.AuthMethod;
import pro.gravit.launcher.core.api.method.AuthMethodPassword;
import pro.gravit.launcher.core.api.model.SelfUser;
import pro.gravit.launcher.core.api.model.Texture;
import pro.gravit.launcher.core.api.model.UserPermissions;
import pro.gravit.launcher.core.backend.UserSettings;
import pro.gravit.launcher.core.backend.extensions.Extension;

public interface LauncherBackendAPI {
    public void setCallback(MainCallback var1);

    public CompletableFuture<LauncherInitData> init();

    public void selectAuthMethod(AuthMethod var1);

    public CompletableFuture<SelfUser> tryAuthorize();

    public CompletableFuture<SelfUser> authorize(String var1, AuthMethodPassword var2);

    public CompletableFuture<List<ProfileFeatureAPI.ClientProfile>> fetchProfiles();

    public ClientProfileSettings makeClientProfileSettings(ProfileFeatureAPI.ClientProfile var1);

    public void saveClientProfileSettings(ClientProfileSettings var1);

    public CompletableFuture<ReadyProfile> downloadProfile(ProfileFeatureAPI.ClientProfile var1, ClientProfileSettings var2, DownloadCallback var3);

    public CompletableFuture<byte[]> fetchTexture(Texture var1);

    public CompletableFuture<List<Java>> getAvailableJava();

    public CompletableFuture<ServerPingInfo> pingServer(ProfileFeatureAPI.ClientProfile var1);

    public void registerUserSettings(String var1, Class<? extends UserSettings> var2);

    public UserSettings getUserSettings(String var1, Function<String, UserSettings> var2);

    public UserPermissions getPermissions();

    public boolean hasPermission(String var1);

    public String getUsername();

    public SelfUser getSelfUser();

    public boolean isTestMode();

    public ResourceLayer makeResourceLayer(List<Path> var1);

    public <T extends Extension> T getExtension(Class<T> var1);

    public void shutdown();

    public static interface ResourceLayer {
        public URL getURL(Path var1) throws IOException;
    }

    public static interface ServerPingInfo {
        public int getMaxOnline();

        public int getOnline();

        public List<String> getPlayerNames();
    }

    public static interface Java {
        public int getMajorVersion();

        public Path getPath();
    }

    public static class DownloadCallback {
        public static final String STAGE_ASSET_VERIFY = "assetVerify";
        public static final String STAGE_HASHING = "hashing";
        public static final String STAGE_DIFF = "diff";
        public static final String STAGE_DOWNLOAD = "download";
        public static final String STAGE_DELETE_EXTRA = "deleteExtra";
        public static final String STAGE_DONE_PART = "done.part";
        public static final String STAGE_DONE = "done";

        public void onStage(String stage) {
        }

        public void onCanCancel(Runnable cancel) {
        }

        public void onTotalDownload(long total) {
        }

        public void onCurrentDownloaded(long current) {
        }
    }

    public static class RunCallback {
        public void onStarted() {
        }

        public void onCanTerminate(Runnable terminate) {
        }

        public void onFinished(int code) {
        }

        public void onNormalOutput(byte[] buf, int offset, int size) {
        }

        public void onErrorOutput(byte[] buf, int offset, int size) {
        }
    }

    public static class MainCallback {
        public void onChangeStatus(String status) {
        }

        public void onProfiles(List<ProfileFeatureAPI.ClientProfile> profiles) {
        }

        public void onAuthorize(SelfUser selfUser) {
        }

        public void onNotify(String header, String description) {
        }

        public void onShutdown() {
        }
    }

    public static interface ClientProfileSettings {
        public long getReservedMemoryBytes(MemoryClass var1);

        public long getMaxMemoryBytes(MemoryClass var1);

        public void setReservedMemoryBytes(MemoryClass var1, long var2);

        public Set<Flag> getFlags();

        public Set<Flag> getAvailableFlags();

        public boolean hasFlag(Flag var1);

        public void addFlag(Flag var1);

        public void removeFlag(Flag var1);

        public Set<ProfileFeatureAPI.OptionalMod> getAllOptionals();

        public Set<ProfileFeatureAPI.OptionalMod> getEnabledOptionals();

        public void enableOptional(ProfileFeatureAPI.OptionalMod var1, ChangedOptionalStatusCallback var2);

        public void disableOptional(ProfileFeatureAPI.OptionalMod var1, ChangedOptionalStatusCallback var2);

        public Java getSelectedJava();

        public Java getRecommendedJava();

        public void setSelectedJava(Java var1);

        public boolean isRecommended(Java var1);

        public boolean isCompatible(Java var1);

        public ClientProfileSettings copy();

        public static interface ChangedOptionalStatusCallback {
            public void onChanged(ProfileFeatureAPI.OptionalMod var1, boolean var2);
        }

        public static enum MemoryClass {
            TOTAL;

        }

        public static enum Flag {
            AUTO_ENTER,
            FULLSCREEN,
            LINUX_WAYLAND_SUPPORT,
            DEBUG_SKIP_FILE_MONITOR;

        }
    }

    public static interface ReadyProfile {
        public ProfileFeatureAPI.ClientProfile getClientProfile();

        public ClientProfileSettings getSettings();

        public void run(RunCallback var1) throws Exception;
    }

    public record LauncherInitData(List<AuthMethod> methods) {
    }
}

