/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.helper;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import pro.gravit.launcher.core.backend.LauncherBackendAPI;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;

public class JavaHelper {
    private static List<JavaVersion> javaVersionsCache;
    public static final List<String> javaFxModules;

    public static Path tryGetOpenJFXPath(Path jvmDir) {
        Path debianJfxPath;
        String dirName = jvmDir.getFileName().toString();
        Path parent = jvmDir.getParent();
        if (parent == null) {
            return null;
        }
        Path archJFXPath = parent.resolve(dirName.replace("openjdk", "openjfx"));
        if (Files.isDirectory(archJFXPath, new LinkOption[0])) {
            return archJFXPath;
        }
        Path arch2JFXPath = parent.resolve(dirName.replace("jdk", "openjfx"));
        if (Files.isDirectory(arch2JFXPath, new LinkOption[0])) {
            return arch2JFXPath;
        }
        if (JVMHelper.OS_TYPE == JVMHelper.OS.LINUX && Files.isDirectory(debianJfxPath = Paths.get("/usr/share/openjfx", new String[0]), new LinkOption[0])) {
            return debianJfxPath;
        }
        return null;
    }

    public static Path tryFindModule(Path path, String moduleName) {
        Path result = path.resolve(moduleName.concat(".jar"));
        if (IOHelper.isFile(result)) {
            return result;
        }
        result = path.resolve("lib").resolve(moduleName.concat(".jar"));
        if (!IOHelper.isFile(result)) {
            return null;
        }
        return result;
    }

    public static boolean tryAddModule(List<Path> paths, String moduleName, StringBuilder args) {
        for (Path path : paths) {
            Path result;
            if (path == null || (result = JavaHelper.tryFindModule(path, moduleName)) == null) continue;
            if (!args.isEmpty()) {
                args.append(File.pathSeparatorChar);
            }
            args.append(result.toAbsolutePath());
            return true;
        }
        return false;
    }

    public static synchronized List<JavaVersion> findJava() {
        String[] path;
        if (javaVersionsCache != null) {
            return javaVersionsCache;
        }
        ArrayList<String> javaPaths = new ArrayList<String>(4);
        ArrayList<JavaVersion> result = new ArrayList<JavaVersion>(4);
        JavaHelper.tryAddJava(javaPaths, result, JavaVersion.getCurrentJavaVersion());
        for (String p : path = System.getenv("PATH").split(JVMHelper.OS_TYPE == JVMHelper.OS.MUSTDIE ? ";" : ":")) {
            try {
                Path javaExecPath;
                Path p1 = Paths.get(p, new String[0]);
                Path path2 = javaExecPath = JVMHelper.OS_TYPE == JVMHelper.OS.MUSTDIE ? p1.resolve("java.exe") : p1.resolve("java");
                if (!Files.exists(javaExecPath, new LinkOption[0]) || (p1 = (javaExecPath = javaExecPath.toRealPath(new LinkOption[0])).getParent().getParent()) == null) continue;
                JavaHelper.tryAddJava(javaPaths, result, JavaVersion.getByPath(p1));
                JavaHelper.trySearchJava(javaPaths, result, p1.getParent());
            }
            catch (NullPointerException | InvalidPathException p1) {
            }
            catch (IOException e) {
                LogHelper.error(e);
            }
        }
        if (JVMHelper.OS_TYPE == JVMHelper.OS.MUSTDIE) {
            Path rootDrive = IOHelper.getRoot();
            try {
                JavaHelper.trySearchJava(javaPaths, result, rootDrive.resolve("Program Files").resolve("Java"));
                JavaHelper.trySearchJava(javaPaths, result, rootDrive.resolve("Program Files").resolve("AdoptOpenJDK"));
                JavaHelper.trySearchJava(javaPaths, result, rootDrive.resolve("Program Files").resolve("Eclipse Foundation"));
                JavaHelper.trySearchJava(javaPaths, result, rootDrive.resolve("Program Files").resolve("Eclipse Adoptium"));
                JavaHelper.trySearchJava(javaPaths, result, rootDrive.resolve("Program Files").resolve("BellSoft"));
            }
            catch (IOException e) {
                LogHelper.error(e);
            }
        } else if (JVMHelper.OS_TYPE == JVMHelper.OS.LINUX) {
            try {
                JavaHelper.trySearchJava(javaPaths, result, Paths.get("/usr/lib/jvm", new String[0]));
            }
            catch (IOException e) {
                LogHelper.error(e);
            }
        }
        javaVersionsCache = result;
        return result;
    }

    private static JavaVersion tryFindJavaByPath(Path path) {
        if (javaVersionsCache == null) {
            return null;
        }
        for (JavaVersion version : javaVersionsCache) {
            if (!version.jvmDir.equals(path)) continue;
            return version;
        }
        return null;
    }

    public static void tryAddJava(List<String> javaPaths, List<JavaVersion> result, JavaVersion version) {
        if (version == null) {
            return;
        }
        Path realPath = version.jvmDir.toAbsolutePath();
        try {
            realPath = realPath.toRealPath(new LinkOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String path = realPath.toString();
        if (javaPaths.contains(path)) {
            return;
        }
        javaPaths.add(path);
        result.add(version);
    }

    public static void trySearchJava(List<String> javaPaths, List<JavaVersion> result, Path path) throws IOException {
        if (path == null || !Files.isDirectory(path, new LinkOption[0])) {
            return;
        }
        Files.list(path).filter(p -> Files.exists(p.resolve("bin").resolve(JVMHelper.OS_TYPE == JVMHelper.OS.MUSTDIE ? "java.exe" : "java"), new LinkOption[0])).forEach(e -> {
            JavaHelper.tryAddJava(javaPaths, result, JavaVersion.getByPath(e));
            if (Files.exists(e.resolve("jre"), new LinkOption[0])) {
                JavaHelper.tryAddJava(javaPaths, result, JavaVersion.getByPath(e.resolve("jre")));
            }
        });
    }

    public static JavaVersionAndBuild getJavaVersion(String version) {
        JavaVersionAndBuild result = new JavaVersionAndBuild();
        if (version.startsWith("1.")) {
            result.version = Integer.parseInt(version.substring(2, 3));
            int pos = version.indexOf(95);
            if (pos != -1) {
                result.build = Integer.parseInt(version.substring(pos + 1));
            }
        } else {
            int dot = version.indexOf(".");
            if (dot != -1) {
                result.version = Integer.parseInt(version.substring(0, dot));
                dot = version.lastIndexOf(".");
                result.build = Integer.parseInt(version.substring(dot + 1));
            } else {
                try {
                    if (version.endsWith("-ea")) {
                        version = version.substring(0, version.length() - 3);
                    }
                    result.version = Integer.parseInt(version);
                    result.build = 0;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    static {
        javaFxModules = List.of("javafx.base", "javafx.graphics", "javafx.fxml", "javafx.controls", "javafx.swing", "javafx.media", "javafx.web");
    }

    public static class JavaVersion
    implements LauncherBackendAPI.Java {
        public final Path jvmDir;
        public final int version;
        public final int build;
        public final JVMHelper.ARCH arch;
        public final List<String> modules;
        public boolean enabledJavaFX;

        public JavaVersion(Path jvmDir, int version, int build, JVMHelper.ARCH arch, boolean enabledJavaFX) {
            this.jvmDir = jvmDir;
            this.version = version;
            this.build = build;
            this.arch = arch;
            this.enabledJavaFX = enabledJavaFX;
            this.modules = version > 8 ? javaFxModules : Collections.unmodifiableList(new ArrayList());
        }

        public JavaVersion(Path jvmDir, int version, int build, JVMHelper.ARCH arch, List<String> modules, boolean enabledJavaFX) {
            this.jvmDir = jvmDir;
            this.version = version;
            this.build = build;
            this.arch = arch;
            this.modules = modules;
            this.enabledJavaFX = enabledJavaFX;
        }

        public static JavaVersion getCurrentJavaVersion() {
            return new JavaVersion(Paths.get(System.getProperty("java.home"), new String[0]), JVMHelper.getVersion(), JVMHelper.JVM_BUILD, JVMHelper.ARCH_TYPE, JavaVersion.isCurrentJavaSupportJavaFX());
        }

        private static boolean isCurrentJavaSupportJavaFX() {
            try {
                Class.forName("javafx.application.Application");
                return true;
            }
            catch (ClassNotFoundException e) {
                if (JVMHelper.getVersion() > 8) {
                    Path jvmDir = Paths.get(System.getProperty("java.home"), new String[0]);
                    return JavaHelper.tryFindModule(jvmDir, "javafx.base") != null;
                }
                return false;
            }
        }

        public static JavaVersion getByPath(Path jvmDir) {
            JavaVersion version = JavaHelper.tryFindJavaByPath(jvmDir);
            if (version != null) {
                return version;
            }
            Path releaseFile = jvmDir.resolve("release");
            JavaVersionAndBuild versionAndBuild = null;
            ArrayList<String> modules = null;
            JVMHelper.ARCH arch = JVMHelper.ARCH_TYPE;
            if (IOHelper.isFile(releaseFile)) {
                try {
                    Properties properties = new Properties();
                    properties.load(IOHelper.newReader(releaseFile));
                    String versionProperty = JavaVersion.getProperty(properties, "JAVA_VERSION");
                    if (versionProperty != null) {
                        versionAndBuild = JavaHelper.getJavaVersion(versionProperty);
                    }
                    try {
                        String archProperty = JavaVersion.getProperty(properties, "OS_ARCH");
                        if (archProperty != null) {
                            arch = JVMHelper.getArch(archProperty);
                        }
                    }
                    catch (Throwable archProperty) {
                        // empty catch block
                    }
                    String modulesProperty = JavaVersion.getProperty(properties, "MODULES");
                    if (modulesProperty != null) {
                        modules = new ArrayList<String>(Arrays.asList(modulesProperty.split(" ")));
                    }
                }
                catch (IOException properties) {
                    // empty catch block
                }
            }
            if (versionAndBuild == null) {
                versionAndBuild = new JavaVersionAndBuild(JavaVersion.isExistExtJavaLibrary(jvmDir, "rt") ? 8 : 9, 0);
            }
            JavaVersion resultJavaVersion = new JavaVersion(jvmDir, versionAndBuild.version, versionAndBuild.build, arch, false);
            if (versionAndBuild.version <= 8) {
                resultJavaVersion.enabledJavaFX = JavaVersion.isExistExtJavaLibrary(jvmDir, "jfxrt");
            } else {
                if (modules != null) {
                    resultJavaVersion.enabledJavaFX = modules.contains("javafx.base");
                }
                if (!resultJavaVersion.enabledJavaFX) {
                    boolean bl = resultJavaVersion.enabledJavaFX = JavaHelper.tryFindModule(jvmDir, "javafx.base") != null;
                    if (!resultJavaVersion.enabledJavaFX) {
                        resultJavaVersion.enabledJavaFX = JavaHelper.tryFindModule(jvmDir.resolve("jre"), "javafx.base") != null;
                    }
                }
            }
            return resultJavaVersion;
        }

        private static String getProperty(Properties properties, String name) {
            String prop = properties.getProperty(name);
            if (prop == null) {
                return null;
            }
            return prop.replaceAll("\"", "");
        }

        public static boolean isExistExtJavaLibrary(Path jvmDir, String name) {
            Path jrePath = jvmDir.resolve("lib").resolve("ext").resolve(name.concat(".jar"));
            Path jrePathLin = jvmDir.resolve("lib").resolve(name.concat(".jar"));
            Path jdkPath = jvmDir.resolve("jre").resolve("lib").resolve("ext").resolve(name.concat(".jar"));
            Path jdkPathLin = jvmDir.resolve("jre").resolve("lib").resolve(name.concat(".jar"));
            return IOHelper.isFile(jrePath) || IOHelper.isFile(jdkPath) || IOHelper.isFile(jdkPathLin) || IOHelper.isFile(jrePathLin);
        }

        @Override
        public int getMajorVersion() {
            return this.version;
        }

        @Override
        public Path getPath() {
            return this.jvmDir;
        }
    }

    public static class JavaVersionAndBuild {
        public int version;
        public int build;

        public JavaVersionAndBuild(int version, int build) {
            this.version = version;
            this.build = build;
        }

        public JavaVersionAndBuild() {
        }
    }
}

