/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.runtime.backend;

import java.io.EOFException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.base.events.request.AuthRequestEvent;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launcher.base.profiles.ClientProfileBuilder;
import pro.gravit.launcher.base.profiles.PlayerProfile;
import pro.gravit.launcher.core.api.features.ProfileFeatureAPI;
import pro.gravit.launcher.core.backend.LauncherBackendAPI;
import pro.gravit.launcher.runtime.backend.ClientDownloadImpl;
import pro.gravit.launcher.runtime.backend.LauncherBackendImpl;
import pro.gravit.launcher.runtime.backend.ProfileSettingsImpl;
import pro.gravit.launcher.runtime.client.ClientLauncherProcess;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.JavaHelper;

public class ReadyProfileImpl
implements LauncherBackendAPI.ReadyProfile {
    private final LauncherBackendImpl backend;
    private ClientProfile profile;
    private final ProfileSettingsImpl settings;
    private final ClientDownloadImpl.DownloadedDir clientDir;
    private final ClientDownloadImpl.DownloadedDir assetDir;
    private final ClientDownloadImpl.DownloadedDir javaDir;
    private volatile Thread writeParamsThread;
    private volatile Thread runThread;
    private volatile ClientLauncherProcess process;
    private volatile Process nativeProcess;
    private volatile LauncherBackendAPI.RunCallback callback;

    public ReadyProfileImpl(LauncherBackendImpl backend, ClientProfile profile, ProfileSettingsImpl settings, ClientDownloadImpl.DownloadedDir clientDir, ClientDownloadImpl.DownloadedDir assetDir, ClientDownloadImpl.DownloadedDir javaDir) {
        this.backend = backend;
        this.profile = profile;
        this.settings = settings;
        this.clientDir = clientDir;
        this.assetDir = assetDir;
        this.javaDir = javaDir;
    }

    @Override
    public ProfileFeatureAPI.ClientProfile getClientProfile() {
        return this.profile;
    }

    @Override
    public LauncherBackendAPI.ClientProfileSettings getSettings() {
        return this.settings;
    }

    @Override
    public void run(LauncherBackendAPI.RunCallback callback) {
        JavaHelper.JavaVersion java;
        if (this.isAlive()) {
            this.terminate();
        }
        this.callback = callback;
        if (this.backend.hasPermission("launcher.debug.skipfilemonitor") && this.settings.hasFlag(LauncherBackendAPI.ClientProfileSettings.Flag.DEBUG_SKIP_FILE_MONITOR)) {
            ClientProfileBuilder builder = new ClientProfileBuilder(this.profile);
            builder.setUpdate(new ArrayList<String>());
            builder.setUpdateVerify(new ArrayList<String>());
            builder.setUpdateExclusions(new ArrayList<String>());
            this.profile = builder.createClientProfile();
        }
        if ((java = this.settings.getSelectedJava()) == null) {
            java = this.settings.getRecommendedJava();
        }
        this.process = new ClientLauncherProcess(this.clientDir.path(), this.assetDir.path(), java, this.clientDir.path().resolve("resourcepacks"), this.profile, new PlayerProfile(this.backend.getSelfUser()), this.settings.view, this.backend.getSelfUser().getAccessToken(), this.clientDir.dir(), this.assetDir.dir(), this.javaDir == null ? null : this.javaDir.dir(), new AuthRequestEvent.OAuthRequestEvent(this.backend.getAuthToken()), this.backend.getAuthMethod().getName());
        this.process.params.ram = (int)(this.settings.getReservedMemoryBytes(LauncherBackendAPI.ClientProfileSettings.MemoryClass.TOTAL) >> 20);
        if (this.process.params.ram > 0) {
            this.process.jvmArgs.add("-Xms" + this.process.params.ram + "M");
            this.process.jvmArgs.add("-Xmx" + this.process.params.ram + "M");
        }
        this.process.params.fullScreen = this.settings.hasFlag(LauncherBackendAPI.ClientProfileSettings.Flag.FULLSCREEN);
        this.process.params.autoEnter = this.settings.hasFlag(LauncherBackendAPI.ClientProfileSettings.Flag.AUTO_ENTER);
        if (JVMHelper.OS_TYPE == JVMHelper.OS.LINUX) {
            this.process.params.lwjglGlfwWayland = this.settings.hasFlag(LauncherBackendAPI.ClientProfileSettings.Flag.LINUX_WAYLAND_SUPPORT);
        }
        this.writeParamsThread = new Thread(this::writeParams);
        this.writeParamsThread.setDaemon(true);
        this.writeParamsThread.start();
        this.runThread = new Thread(this::readThread);
        this.runThread.setDaemon(true);
        this.runThread.start();
    }

    private void readThread() {
        try {
            this.process.start(true);
            this.nativeProcess = this.process.getProcess();
            this.callback.onCanTerminate(this::terminate);
            InputStream stream = this.nativeProcess.getInputStream();
            byte[] buf = IOHelper.newBuffer();
            try {
                int length = stream.read(buf);
                while (length >= 0) {
                    this.callback.onNormalOutput(buf, 0, length);
                    length = stream.read(buf);
                }
            }
            catch (EOFException length) {
                // empty catch block
            }
            if (this.nativeProcess.isAlive()) {
                int code = this.nativeProcess.waitFor();
                this.callback.onFinished(code);
            }
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                return;
            }
            this.terminate();
        }
    }

    public void terminate() {
        if (this.nativeProcess == null) {
            return;
        }
        this.nativeProcess.destroyForcibly();
    }

    public boolean isAlive() {
        return this.nativeProcess != null && this.nativeProcess.isAlive();
    }

    private void writeParams() {
        try {
            this.process.runWriteParams(new InetSocketAddress("127.0.0.1", Launcher.getConfig().clientPort));
        }
        catch (Throwable e) {
            this.terminate();
        }
    }
}

