/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.runtime.backend;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import pro.gravit.launcher.base.vfs.Vfs;
import pro.gravit.launcher.base.vfs.VfsDirectory;
import pro.gravit.launcher.base.vfs.directory.OverlayVfsDirectory;
import pro.gravit.launcher.core.backend.LauncherBackendAPI;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;

public class ResourceLayerImpl
implements LauncherBackendAPI.ResourceLayer {
    private final Path vfsPath;

    public ResourceLayerImpl(Path basePath, List<Path> overlayList) {
        if (overlayList == null || overlayList.isEmpty()) {
            this.vfsPath = basePath;
            return;
        }
        ArrayList<VfsDirectory> overlays = new ArrayList<VfsDirectory>();
        overlays.add((VfsDirectory)Vfs.get().resolve(basePath));
        for (Path e : overlayList) {
            VfsDirectory dir = (VfsDirectory)Vfs.get().resolve(basePath.resolve(e));
            if (dir == null) continue;
            overlays.add(dir);
        }
        OverlayVfsDirectory directory = new OverlayVfsDirectory(overlays);
        String randomName = SecurityHelper.randomStringToken();
        this.vfsPath = Path.of(randomName, new String[0]);
        if (LogHelper.isDevEnabled()) {
            LogHelper.dev("Make overlay %s from %s", this.vfsPath, basePath);
            for (VfsDirectory e : overlays) {
                LogHelper.dev("Layer %s", e.getClass().getSimpleName());
            }
        }
        Vfs.get().put(this.vfsPath, directory);
    }

    @Override
    public URL getURL(Path path) throws IOException {
        return Vfs.get().getURL(this.vfsPath.resolve(path));
    }
}

