/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.runtime.backend;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.base.vfs.VfsFile;
import pro.gravit.utils.helper.SecurityHelper;

public class EncryptedVfsFile
extends VfsFile {
    private final VfsFile parent;
    private final String alg;
    private final SecretKeySpec sKeySpec;
    private final IvParameterSpec iKeySpec;

    public EncryptedVfsFile(VfsFile parent) {
        this.parent = parent;
        this.alg = "AES/CBC/PKCS5Padding";
        try {
            byte[] compat = SecurityHelper.getAESKey((byte[])SecurityHelper.fromHex((String)Launcher.getConfig().runtimeEncryptKey));
            this.sKeySpec = new SecretKeySpec(compat, "AES");
            this.iKeySpec = new IvParameterSpec("8u3d90ikr7o67lsq".getBytes());
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    public InputStream getInputStream() {
        Cipher cipher;
        try {
            cipher = Cipher.getInstance(this.alg);
            cipher.init(2, (Key)this.sKeySpec, this.iKeySpec);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new SecurityException(e);
        }
        return new BufferedInputStream(new CipherInputStream(this.parent.getInputStream(), cipher));
    }
}

