/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.runtime.debug;

import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import pro.gravit.launcher.base.ClientPermissions;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.base.api.AuthService;
import pro.gravit.launcher.base.api.ClientService;
import pro.gravit.launcher.base.events.request.ProfilesRequestEvent;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launcher.base.request.Request;
import pro.gravit.launcher.base.request.update.ProfilesRequest;
import pro.gravit.launcher.runtime.LauncherEngine;
import pro.gravit.launcher.runtime.debug.DebugMain;
import pro.gravit.launcher.runtime.debug.DebugProperties;
import pro.gravit.launcher.runtime.gui.RuntimeProvider;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.launch.BasicLaunch;
import pro.gravit.utils.launch.ClassLoaderControl;
import pro.gravit.utils.launch.Launch;
import pro.gravit.utils.launch.LaunchOptions;
import pro.gravit.utils.launch.LegacyLaunch;
import pro.gravit.utils.launch.ModuleLaunch;

public class ClientRuntimeProvider
implements RuntimeProvider {
    @Override
    public void run(String[] args) {
        ArrayList<String> newArgs = new ArrayList<String>(Arrays.asList(args));
        try {
            ClassLoaderControl classLoaderControl;
            LaunchOptions options;
            String username = DebugProperties.USERNAME;
            String uuid = DebugProperties.UUID;
            String minecraftAccessToken = DebugProperties.MINECRAFT_ACCESS_TOKEN;
            String profileUUID = System.getProperty("launcher.runtime.profileuuid", null);
            String mainClass = System.getProperty("launcher.runtime.mainclass", null);
            String mainModule = System.getProperty("launcher.runtime.mainmodule", null);
            String launchMode = System.getProperty("launcher.runtime.launch", "basic");
            String compatClasses = System.getProperty("launcher.runtime.launch.compat", null);
            String nativesDir = System.getProperty("launcher.runtime.launch.natives", "natives");
            String launcherOptionsPath = System.getProperty("launcher.runtime.launch.options", null);
            boolean enableHacks = Boolean.getBoolean("launcher.runtime.launch.enablehacks");
            ClientPermissions permissions = new ClientPermissions();
            if (mainClass == null) {
                throw new NullPointerException("Add `-Dlauncher.runtime.mainclass=YOUR_MAIN_CLASS` to jvmArgs");
            }
            if (uuid == null) {
                DebugMain.AuthorizationData data = DebugMain.authorize();
                minecraftAccessToken = data.userInfo().accessToken;
                permissions = data.userInfo().permissions;
                username = data.userInfo().playerProfile.username;
                uuid = data.userInfo().playerProfile.uuid.toString();
            }
            if (profileUUID != null) {
                UUID profileUuid = UUID.fromString(profileUUID);
                Object profiles = new ProfilesRequest();
                ProfilesRequestEvent event = (ProfilesRequestEvent)((Request)profiles).request();
                for (ClientProfile profile : event.profiles) {
                    if (!profile.getUUID().equals(profileUuid)) continue;
                    AuthService.profile = profile;
                }
            }
            if (username == null) {
                username = "Player";
            }
            if (uuid == null) {
                uuid = "a7899336-e61c-4e51-b480-0c815b18aed8";
            }
            this.replaceOrCreateArgument(newArgs, "--username", username);
            this.replaceOrCreateArgument(newArgs, "--uuid", uuid);
            this.replaceOrCreateArgument(newArgs, "--accessToken", minecraftAccessToken);
            AuthService.uuid = UUID.fromString(uuid);
            AuthService.username = username;
            AuthService.permissions = permissions;
            Launch launch = switch (launchMode) {
                case "basic" -> new BasicLaunch();
                case "legacy" -> new LegacyLaunch();
                case "module" -> new ModuleLaunch();
                default -> throw new UnsupportedOperationException(String.format("Unknown launch mode: '%s'", launchMode));
            };
            ArrayList<Path> classpath = new ArrayList<Path>();
            try {
                for (String c : System.getProperty("java.class.path").split(File.pathSeparator)) {
                    classpath.add(Paths.get(c, new String[0]));
                }
            }
            catch (Throwable e) {
                LogHelper.error(e);
            }
            if (launcherOptionsPath != null) {
                try (BufferedReader reader = IOHelper.newReader(Paths.get(launcherOptionsPath, new String[0]));){
                    options = Launcher.gsonManager.gson.fromJson((Reader)reader, LaunchOptions.class);
                }
            } else {
                options = new LaunchOptions();
            }
            options.enableHacks = enableHacks;
            ClientService.classLoaderControl = classLoaderControl = launch.init(classpath, nativesDir, options);
            if (compatClasses != null) {
                String[] compatClassesList;
                for (String e : compatClassesList = compatClasses.split(",")) {
                    Class<?> clazz = classLoaderControl.getClass(e);
                    MethodHandle runMethod = MethodHandles.lookup().findStatic(clazz, "run", MethodType.methodType(Void.TYPE, ClassLoaderControl.class));
                    runMethod.invoke(classLoaderControl);
                }
            }
            launch.launch(mainClass, mainModule, Arrays.asList(args));
        }
        catch (Throwable e) {
            LogHelper.error(e);
            LauncherEngine.exitLauncher(-15);
        }
    }

    public void replaceOrCreateArgument(ArrayList<String> args, String name, String value) {
        int index = args.indexOf(name);
        if (index < 0) {
            args.add(name);
            if (value != null) {
                args.add(value);
            }
            return;
        }
        if (value != null) {
            int valueIndex = index + 1;
            args.set(valueIndex, value);
        }
    }

    @Override
    public void preLoad() {
    }

    @Override
    public void init(boolean clientInstance) {
    }
}

