/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.runtime.backend;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import pro.gravit.launcher.base.ClientPermissions;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launcher.base.vfs.Vfs;
import pro.gravit.launcher.base.vfs.directory.FileVfsDirectory;
import pro.gravit.launcher.base.vfs.file.CachedVfsFile;
import pro.gravit.launcher.base.vfs.file.UrlVfsFile;
import pro.gravit.launcher.core.api.LauncherAPIHolder;
import pro.gravit.launcher.core.api.features.AuthFeatureAPI;
import pro.gravit.launcher.core.api.features.CoreFeatureAPI;
import pro.gravit.launcher.core.api.features.HardwareVerificationFeatureAPI;
import pro.gravit.launcher.core.api.features.ProfileFeatureAPI;
import pro.gravit.launcher.core.api.features.TextureUploadFeatureAPI;
import pro.gravit.launcher.core.api.method.AuthMethod;
import pro.gravit.launcher.core.api.method.AuthMethodPassword;
import pro.gravit.launcher.core.api.model.SelfUser;
import pro.gravit.launcher.core.api.model.Texture;
import pro.gravit.launcher.core.api.model.UserPermissions;
import pro.gravit.launcher.core.backend.LauncherBackendAPI;
import pro.gravit.launcher.core.backend.UserSettings;
import pro.gravit.launcher.core.backend.exceptions.LauncherBackendException;
import pro.gravit.launcher.core.backend.extensions.Extension;
import pro.gravit.launcher.core.backend.extensions.TextureUploadExtension;
import pro.gravit.launcher.runtime.NewLauncherSettings;
import pro.gravit.launcher.runtime.backend.BackendSettings;
import pro.gravit.launcher.runtime.backend.ClientDownloadImpl;
import pro.gravit.launcher.runtime.backend.ECKeyHolder;
import pro.gravit.launcher.runtime.backend.EncryptedVfsFile;
import pro.gravit.launcher.runtime.backend.ProfileSettingsImpl;
import pro.gravit.launcher.runtime.backend.ResourceLayerImpl;
import pro.gravit.launcher.runtime.client.DirBridge;
import pro.gravit.launcher.runtime.client.ServerPinger;
import pro.gravit.launcher.runtime.debug.DebugMain;
import pro.gravit.launcher.runtime.managers.SettingsManager;
import pro.gravit.launcher.runtime.utils.HWIDProvider;
import pro.gravit.launcher.runtime.utils.LauncherUpdater;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.JavaHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;

public class LauncherBackendImpl
implements LauncherBackendAPI,
TextureUploadExtension {
    private final ClientDownloadImpl clientDownloadImpl = new ClientDownloadImpl(this);
    private volatile LauncherBackendAPI.MainCallback callback;
    ExecutorService executorService;
    private volatile AuthMethod authMethod;
    private SettingsManager settingsManager;
    private NewLauncherSettings allSettings;
    private BackendSettings backendSettings;
    private volatile ECKeyHolder ecKeyHolder;
    private volatile Map<UUID, ProfileFeatureAPI.ClientProfile> profiles;
    private volatile UserPermissions permissions;
    private volatile SelfUser selfUser;
    private volatile List<LauncherBackendAPI.Java> availableJavas;
    private volatile CompletableFuture<List<LauncherBackendAPI.Java>> availableJavasFuture;
    private volatile CompletableFuture<Void> processHardwareFuture;
    private volatile Path vfsRootPath;
    private final Map<UUID, CompletableFuture<LauncherBackendAPI.ServerPingInfo>> pingFutures = new ConcurrentHashMap<UUID, CompletableFuture<LauncherBackendAPI.ServerPingInfo>>();
    private static final Pattern JAVA_VERSION_PATTERN = Pattern.compile("Java (?<version>.+) b(?<build>.+) (?<os>.+) (?<arch>.+) javafx (?<javafx>.+)");

    @Override
    public void setCallback(LauncherBackendAPI.MainCallback callback) {
        this.callback = callback;
    }

    private void doInit() throws Exception {
        this.executorService = Executors.newScheduledThreadPool(2, r -> {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            return thread;
        });
        this.registerUserSettings("backend", BackendSettings.class);
        this.settingsManager = new SettingsManager();
        this.settingsManager.generateConfigIfNotExists();
        this.settingsManager.loadConfig();
        this.allSettings = this.settingsManager.getConfig();
        this.backendSettings = (BackendSettings)this.getUserSettings("backend", k -> new BackendSettings());
        this.permissions = new ClientPermissions();
        this.ecKeyHolder = new ECKeyHolder();
        this.ecKeyHolder.readKeys();
        DirBridge.dirUpdates = DirBridge.defaultUpdatesDir;
    }

    @Override
    public CompletableFuture<LauncherBackendAPI.LauncherInitData> init() {
        try {
            this.doInit();
        }
        catch (Throwable e) {
            return CompletableFuture.failedFuture(e);
        }
        CompletableFuture<CoreFeatureAPI.LauncherUpdateInfo> feature = this.isTestMode() ? CompletableFuture.completedFuture(new CoreFeatureAPI.LauncherUpdateInfo(null, "Unknown", false, false)) : LauncherAPIHolder.core().checkUpdates();
        return feature.thenCombineAsync(LauncherAPIHolder.core().getAuthMethods(), (updatesInfo, authMethods) -> {
            if (updatesInfo.required()) {
                Path tempFile;
                try {
                    tempFile = LauncherUpdater.prepareUpdate(URI.create(updatesInfo.url()).toURL());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                this.callback.onShutdown();
                this.shutdown();
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    try (InputStream input = IOHelper.newInput(tempFile);){
                        try (OutputStream output = IOHelper.newOutput(LauncherUpdater.getLauncherPath());){
                            input.transferTo(output);
                        }
                        LauncherUpdater.restart();
                    }
                    catch (IOException e) {
                        LogHelper.error(e);
                    }
                }));
            }
            return new LauncherBackendAPI.LauncherInitData((List<AuthMethod>)authMethods);
        }, (Executor)this.executorService);
    }

    public AuthFeatureAPI.AuthToken getAuthToken() {
        return this.backendSettings.auth.toToken();
    }

    public AuthMethod getAuthMethod() {
        return this.authMethod;
    }

    @Override
    public void selectAuthMethod(AuthMethod method) {
        this.authMethod = method;
        LauncherAPIHolder.changeAuthId(method.getName());
    }

    @Override
    public CompletableFuture<SelfUser> tryAuthorize() {
        if (this.authMethod == null) {
            return CompletableFuture.failedFuture(new LauncherBackendException("This method call not allowed before select authMethod"));
        }
        if (this.backendSettings.auth == null) {
            return CompletableFuture.failedFuture(new LauncherBackendException("Auth data not found"));
        }
        if (this.backendSettings.auth.expireIn > 0L && LocalDateTime.ofInstant(Instant.ofEpochMilli(this.backendSettings.auth.expireIn), ZoneOffset.UTC).isBefore(LocalDateTime.now(ZoneOffset.UTC))) {
            return ((CompletableFuture)LauncherAPIHolder.auth().refreshToken(this.backendSettings.auth.refreshToken).thenCompose(response -> {
                this.setAuthToken((AuthFeatureAPI.AuthToken)response);
                return LauncherAPIHolder.auth().restore(this.backendSettings.auth.accessToken, true);
            })).thenApply(user -> {
                this.onAuthorize((SelfUser)user);
                return user;
            });
        }
        return LauncherAPIHolder.auth().restore(this.backendSettings.auth.accessToken, true).thenApply(user -> {
            this.onAuthorize((SelfUser)user);
            return user;
        });
    }

    private void setAuthToken(AuthFeatureAPI.AuthToken authToken) {
        this.backendSettings.auth = new BackendSettings.AuthorizationData();
        this.backendSettings.auth.accessToken = authToken.getAccessToken();
        this.backendSettings.auth.refreshToken = authToken.getRefreshToken();
        if (authToken.getExpire() <= 0L) {
            this.backendSettings.auth.expireIn = 0L;
        }
        this.backendSettings.auth.expireIn = LocalDateTime.now(ZoneOffset.UTC).plus(authToken.getExpire(), ChronoUnit.MILLIS).toEpochSecond(ZoneOffset.UTC);
    }

    private void onAuthorize(SelfUser selfUser) {
        this.selfUser = selfUser;
        this.permissions = selfUser.getPermissions();
        this.callback.onAuthorize(selfUser);
        if (this.processHardwareFuture == null) {
            this.processHardwareFuture = this.processHardware();
        }
    }

    @Override
    public CompletableFuture<SelfUser> authorize(String login, AuthMethodPassword password) {
        if (this.authMethod == null) {
            return CompletableFuture.failedFuture(new LauncherBackendException("This method call not allowed before select authMethod"));
        }
        return LauncherAPIHolder.auth().auth(login, password).thenApply(response -> {
            this.setAuthToken(response.authToken());
            this.onAuthorize(response.user());
            return response.user();
        });
    }

    @Override
    public CompletableFuture<List<ProfileFeatureAPI.ClientProfile>> fetchProfiles() {
        return LauncherAPIHolder.profile().getProfiles().thenApply(profiles -> {
            this.onProfiles((List<ProfileFeatureAPI.ClientProfile>)profiles);
            this.callback.onProfiles((List<ProfileFeatureAPI.ClientProfile>)profiles);
            return profiles;
        });
    }

    private void onProfiles(List<ProfileFeatureAPI.ClientProfile> profiles) {
        this.profiles = profiles.stream().collect(Collectors.toMap(ProfileFeatureAPI.ClientProfile::getUUID, x -> x));
        for (ProfileFeatureAPI.ClientProfile clientProfile : this.profiles.values()) {
            if (!(clientProfile instanceof ClientProfile)) continue;
            ClientProfile cp = (ClientProfile)clientProfile;
            cp.updateOptionalGraph();
        }
        for (Map.Entry entry : this.backendSettings.settings.entrySet()) {
            ClientProfile profile = (ClientProfile)this.profiles.get(entry.getKey());
            if (profile == null) continue;
            ((ProfileSettingsImpl)entry.getValue()).initAfterGson(profile, this);
        }
    }

    @Override
    public LauncherBackendAPI.ClientProfileSettings makeClientProfileSettings(ProfileFeatureAPI.ClientProfile profile) {
        ProfileSettingsImpl settings = this.backendSettings.settings.get(profile.getUUID());
        if (settings == null) {
            settings = new ProfileSettingsImpl((ClientProfile)profile);
            settings.backend = this;
            settings.updateEnabledMods();
        } else {
            if (settings.backend == null) {
                settings.initAfterGson((ClientProfile)profile, this);
            }
            settings = settings.copy();
        }
        return settings;
    }

    @Override
    public void saveClientProfileSettings(LauncherBackendAPI.ClientProfileSettings settings) {
        ProfileSettingsImpl impl = (ProfileSettingsImpl)settings;
        impl.updateEnabledMods();
        this.backendSettings.settings.put(impl.profile.getUUID(), impl);
    }

    @Override
    public CompletableFuture<LauncherBackendAPI.ReadyProfile> downloadProfile(ProfileFeatureAPI.ClientProfile profile, LauncherBackendAPI.ClientProfileSettings settings, LauncherBackendAPI.DownloadCallback callback) {
        return this.clientDownloadImpl.downloadProfile((ClientProfile)profile, (ProfileSettingsImpl)settings, callback);
    }

    @Override
    public CompletableFuture<byte[]> fetchTexture(Texture texture) {
        return CompletableFuture.failedFuture(new UnsupportedOperationException());
    }

    @Override
    public CompletableFuture<List<LauncherBackendAPI.Java>> getAvailableJava() {
        if (this.availableJavas == null) {
            if (this.availableJavasFuture == null) {
                this.availableJavasFuture = CompletableFuture.supplyAsync(() -> {
                    List<LauncherBackendAPI.Java> javas = this.getCustomJava();
                    if (!Launcher.getConfig().forceUseCustomJava || javas.isEmpty()) {
                        javas.addAll(JavaHelper.findJava());
                    }
                    return javas;
                }, this.executorService).thenApply(e -> {
                    this.availableJavas = e;
                    return e;
                });
            }
            return this.availableJavasFuture;
        }
        return CompletableFuture.completedFuture(this.availableJavas);
    }

    public List<LauncherBackendAPI.Java> getCustomJava() {
        ArrayList<LauncherBackendAPI.Java> versions = new ArrayList<LauncherBackendAPI.Java>();
        if (Launcher.getConfig().customJavaDownload == null) {
            return versions;
        }
        for (Map.Entry<String, String> entry : Launcher.getConfig().customJavaDownload.entrySet()) {
            String javaDir = entry.getKey();
            String javaVersionString = entry.getValue();
            Matcher matcher = JAVA_VERSION_PATTERN.matcher(javaVersionString);
            if (matcher.matches()) {
                String os = matcher.group("os");
                int version = Integer.parseInt(matcher.group("version"));
                int build = Integer.parseInt(matcher.group("build"));
                JVMHelper.ARCH arch = JVMHelper.ARCH.valueOf(matcher.group("arch"));
                boolean javafx = Boolean.parseBoolean(matcher.group("javafx"));
                if (!this.isArchAvailable(arch) || !JVMHelper.OS_TYPE.name.equals(os)) continue;
                Path javaDirectory = DirBridge.dirUpdates.resolve(javaDir);
                LogHelper.debug("In-Launcher Java Version found: Java %d b%d %s javafx %s", version, build, arch.name, Boolean.toString(javafx));
                JavaHelper.JavaVersion javaVersion = new JavaHelper.JavaVersion(javaDirectory, version, build, arch, javafx);
                versions.add(javaVersion);
                continue;
            }
            LogHelper.warning("Java Version: %s does not match", javaVersionString);
        }
        return versions;
    }

    public boolean isArchAvailable(JVMHelper.ARCH arch) {
        if (JVMHelper.ARCH_TYPE == arch) {
            return true;
        }
        if (arch == JVMHelper.ARCH.X86_64 && JVMHelper.OS_TYPE == JVMHelper.OS.MUSTDIE && (JVMHelper.ARCH_TYPE == JVMHelper.ARCH.X86 && !JVMHelper.isJVMMatchesSystemArch() || JVMHelper.ARCH_TYPE == JVMHelper.ARCH.ARM64)) {
            return true;
        }
        return arch == JVMHelper.ARCH.X86_64 && JVMHelper.OS_TYPE == JVMHelper.OS.MACOSX && JVMHelper.ARCH_TYPE == JVMHelper.ARCH.ARM64;
    }

    @Override
    public CompletableFuture<LauncherBackendAPI.ServerPingInfo> pingServer(ProfileFeatureAPI.ClientProfile profile) {
        return this.pingFutures.computeIfAbsent(profile.getUUID(), k -> {
            CompletableFuture future = new CompletableFuture();
            this.executorService.submit(() -> {
                try {
                    ServerPinger pinger = new ServerPinger((ClientProfile)profile);
                    future.complete(pinger.ping());
                }
                catch (Throwable e) {
                    future.completeExceptionally(e);
                }
            });
            return future;
        });
    }

    @Override
    public void registerUserSettings(String name, Class<? extends UserSettings> clazz) {
        UserSettings.providers.register(name, clazz);
    }

    @Override
    public UserSettings getUserSettings(String name, Function<String, UserSettings> ifNotExist) {
        return this.allSettings.userSettings.computeIfAbsent(name, ifNotExist);
    }

    @Override
    public UserPermissions getPermissions() {
        return this.permissions;
    }

    @Override
    public boolean hasPermission(String permission) {
        return this.permissions.hasPerm(permission);
    }

    @Override
    public String getUsername() {
        return this.selfUser == null ? "Player" : this.getUsername();
    }

    @Override
    public SelfUser getSelfUser() {
        return this.selfUser;
    }

    @Override
    public boolean isTestMode() {
        try {
            return DebugMain.IS_DEBUG.get();
        }
        catch (Throwable ex) {
            return false;
        }
    }

    @Override
    public LauncherBackendAPI.ResourceLayer makeResourceLayer(List<Path> overlayList) {
        if (this.vfsRootPath == null) {
            this.vfsRootPath = this.initVfsDirectory();
        }
        return new ResourceLayerImpl(this.vfsRootPath, overlayList);
    }

    @Override
    public <T extends Extension> T getExtension(Class<T> clazz) {
        if (clazz == TextureUploadExtension.class && this.authMethod != null && this.authMethod.getFeatures().contains("assetupload")) {
            return (T)this;
        }
        return null;
    }

    @Override
    public void shutdown() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
        if (this.settingsManager != null) {
            try {
                this.settingsManager.saveConfig();
            }
            catch (IOException e) {
                LogHelper.error("Config not saved", e);
            }
        }
    }

    @Override
    public CompletableFuture<TextureUploadFeatureAPI.TextureUploadInfo> fetchTextureUploadInfo() {
        return LauncherAPIHolder.get().get(TextureUploadFeatureAPI.class).fetchInfo();
    }

    @Override
    public CompletableFuture<Texture> uploadTexture(String name, byte[] bytes, TextureUploadFeatureAPI.UploadSettings settings) {
        return LauncherAPIHolder.get().get(TextureUploadFeatureAPI.class).upload(name, bytes, settings);
    }

    public CompletableFuture<Void> processHardware() {
        HardwareVerificationFeatureAPI featureAPI = LauncherAPIHolder.get().get(HardwareVerificationFeatureAPI.class);
        if (featureAPI == null) {
            return CompletableFuture.completedFuture(null);
        }
        return ((CompletableFuture)featureAPI.getSecurityInfo().thenCompose(response -> {
            if (!response.isRequired()) {
                return CompletableFuture.completedFuture(null);
            }
            byte[] signature = SecurityHelper.sign(response.getSignData(), this.ecKeyHolder.privateKey);
            return featureAPI.privateKeyVerification(this.ecKeyHolder.publicKey, signature);
        })).thenCompose(response -> {
            switch (response.getHardwareCollectLevel()) {
                case NONE: {
                    return featureAPI.sendHardwareInfo(null, null);
                }
                case ONLY_STATISTIC: {
                    HWIDProvider hwidProvider = new HWIDProvider();
                    return featureAPI.sendHardwareInfo(hwidProvider.getStatisticData(), null);
                }
                case ALL: {
                    HWIDProvider hwidProvider = new HWIDProvider();
                    return featureAPI.sendHardwareInfo(hwidProvider.getStatisticData(), hwidProvider.getIdentifyData());
                }
            }
            return CompletableFuture.failedFuture(new UnsupportedOperationException());
        });
    }

    public Path initVfsDirectory() {
        Path defaultPath = Path.of("runtime", new String[0]);
        if (this.isTestMode()) {
            Vfs.get().put(defaultPath, new FileVfsDirectory(defaultPath));
        } else {
            String encryptKey = Launcher.getConfig().runtimeEncryptKey;
            if (encryptKey == null) {
                for (Map.Entry<String, byte[]> e : Launcher.getConfig().runtime.entrySet()) {
                    String realPath = e.getKey();
                    String encodedName = "runtime/" + realPath;
                    try {
                        Vfs.get().put(defaultPath.resolve(realPath), new UrlVfsFile(IOHelper.getResourceURL(encodedName)));
                    }
                    catch (NoSuchFileException noSuchFileException) {}
                }
            } else {
                for (Map.Entry<String, byte[]> e : Launcher.getConfig().runtime.entrySet()) {
                    String realPath = e.getKey();
                    byte[] hash = e.getValue();
                    String encodedName = "runtime/" + SecurityHelper.toHex(hash);
                    try {
                        Vfs.get().put(defaultPath.resolve(realPath), new CachedVfsFile(new EncryptedVfsFile(new UrlVfsFile(IOHelper.getResourceURL(encodedName)))));
                    }
                    catch (NoSuchFileException noSuchFileException) {}
                }
            }
        }
        if (LogHelper.isDevEnabled()) {
            Vfs.get().debugPrint(LogHelper.Level.DEV);
        }
        return defaultPath;
    }
}

