/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.runtime.backend;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import oshi.SystemInfo;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launcher.base.profiles.optional.OptionalFile;
import pro.gravit.launcher.base.profiles.optional.OptionalView;
import pro.gravit.launcher.core.LauncherNetworkAPI;
import pro.gravit.launcher.core.api.features.ProfileFeatureAPI;
import pro.gravit.launcher.core.backend.LauncherBackendAPI;
import pro.gravit.launcher.runtime.backend.LauncherBackendImpl;
import pro.gravit.launcher.runtime.utils.SystemMemory;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.JavaHelper;

public class ProfileSettingsImpl
implements LauncherBackendAPI.ClientProfileSettings {
    transient ClientProfile profile;
    transient LauncherBackendImpl backend;
    @LauncherNetworkAPI
    private Map<LauncherBackendAPI.ClientProfileSettings.MemoryClass, Long> ram;
    @LauncherNetworkAPI
    private Set<LauncherBackendAPI.ClientProfileSettings.Flag> flags;
    @LauncherNetworkAPI
    private Set<String> enabled;
    @LauncherNetworkAPI
    private String saveJavaPath;
    transient OptionalView view;
    volatile transient JavaHelper.JavaVersion selectedJava;

    public ProfileSettingsImpl() {
    }

    public ProfileSettingsImpl(ClientProfile profile) {
        this.profile = profile;
        ClientProfile.ProfileDefaultSettings def = profile.getSettings();
        this.ram = new HashMap<LauncherBackendAPI.ClientProfileSettings.MemoryClass, Long>();
        this.ram.put(LauncherBackendAPI.ClientProfileSettings.MemoryClass.TOTAL, (long)def.ram << 20);
        this.flags = new HashSet<LauncherBackendAPI.ClientProfileSettings.Flag>();
        if (def.autoEnter) {
            this.flags.add(LauncherBackendAPI.ClientProfileSettings.Flag.AUTO_ENTER);
        }
        if (def.fullScreen) {
            this.flags.add(LauncherBackendAPI.ClientProfileSettings.Flag.FULLSCREEN);
        }
        this.view = new OptionalView(profile);
        if (JVMHelper.OS_TYPE == JVMHelper.OS.LINUX && System.getenv("WAYLAND_DISPLAY") != null) {
            this.flags.add(LauncherBackendAPI.ClientProfileSettings.Flag.LINUX_WAYLAND_SUPPORT);
        }
    }

    public long getReservedMemoryBytes(LauncherBackendAPI.ClientProfileSettings.MemoryClass memoryClass) {
        return this.ram.getOrDefault(memoryClass, 0L);
    }

    public long getMaxMemoryBytes(LauncherBackendAPI.ClientProfileSettings.MemoryClass memoryClass) {
        try {
            return SystemMemory.getPhysicalMemorySize();
        }
        catch (Throwable e) {
            SystemInfo systemInfo = new SystemInfo();
            return systemInfo.getHardware().getMemory().getTotal();
        }
    }

    public void setReservedMemoryBytes(LauncherBackendAPI.ClientProfileSettings.MemoryClass memoryClass, long value) {
        this.ram.put(memoryClass, value);
    }

    public Set<LauncherBackendAPI.ClientProfileSettings.Flag> getFlags() {
        return Collections.unmodifiableSet(this.flags);
    }

    public Set<LauncherBackendAPI.ClientProfileSettings.Flag> getAvailableFlags() {
        HashSet<LauncherBackendAPI.ClientProfileSettings.Flag> set = new HashSet<LauncherBackendAPI.ClientProfileSettings.Flag>();
        set.add(LauncherBackendAPI.ClientProfileSettings.Flag.AUTO_ENTER);
        set.add(LauncherBackendAPI.ClientProfileSettings.Flag.FULLSCREEN);
        if (JVMHelper.OS_TYPE == JVMHelper.OS.LINUX) {
            set.add(LauncherBackendAPI.ClientProfileSettings.Flag.LINUX_WAYLAND_SUPPORT);
        }
        if (this.backend.hasPermission("launcher.debug.skipfilemonitor")) {
            set.add(LauncherBackendAPI.ClientProfileSettings.Flag.DEBUG_SKIP_FILE_MONITOR);
        }
        return set;
    }

    public boolean hasFlag(LauncherBackendAPI.ClientProfileSettings.Flag flag) {
        return this.flags.contains(flag);
    }

    public void addFlag(LauncherBackendAPI.ClientProfileSettings.Flag flag) {
        this.flags.add(flag);
    }

    public void removeFlag(LauncherBackendAPI.ClientProfileSettings.Flag flag) {
        this.flags.remove(flag);
    }

    public Set<ProfileFeatureAPI.OptionalMod> getAllOptionals() {
        return this.view.all;
    }

    public Set<ProfileFeatureAPI.OptionalMod> getEnabledOptionals() {
        return this.view.enabled;
    }

    public void enableOptional(ProfileFeatureAPI.OptionalMod mod, LauncherBackendAPI.ClientProfileSettings.ChangedOptionalStatusCallback callback) {
        this.view.enable((OptionalFile)mod, true, (arg_0, arg_1) -> ((LauncherBackendAPI.ClientProfileSettings.ChangedOptionalStatusCallback)callback).onChanged(arg_0, arg_1));
    }

    public void disableOptional(ProfileFeatureAPI.OptionalMod mod, LauncherBackendAPI.ClientProfileSettings.ChangedOptionalStatusCallback callback) {
        this.view.disable((OptionalFile)mod, (arg_0, arg_1) -> ((LauncherBackendAPI.ClientProfileSettings.ChangedOptionalStatusCallback)callback).onChanged(arg_0, arg_1));
    }

    public JavaHelper.JavaVersion getSelectedJava() {
        if (this.selectedJava == null) {
            this.selectedJava = this.getRecommendedJava();
        }
        return this.selectedJava;
    }

    public JavaHelper.JavaVersion getRecommendedJava() {
        JavaHelper.JavaVersion result = null;
        try {
            for (LauncherBackendAPI.Java java : this.backend.getAvailableJava().get()) {
                if (this.isRecommended(java)) {
                    return (JavaHelper.JavaVersion)java;
                }
                if (!this.isCompatible(java)) continue;
                if (result == null) {
                    result = (JavaHelper.JavaVersion)java;
                    continue;
                }
                if (result.getMajorVersion() >= java.getMajorVersion()) continue;
                result = (JavaHelper.JavaVersion)java;
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public void setSelectedJava(LauncherBackendAPI.Java java) {
        this.selectedJava = (JavaHelper.JavaVersion)java;
    }

    public boolean isRecommended(LauncherBackendAPI.Java java) {
        return java.getMajorVersion() == this.profile.getRecommendJavaVersion();
    }

    public boolean isCompatible(LauncherBackendAPI.Java java) {
        return java.getMajorVersion() >= this.profile.getMinJavaVersion() && java.getMajorVersion() <= this.profile.getMaxJavaVersion();
    }

    public ProfileSettingsImpl copy() {
        ProfileSettingsImpl cloned = new ProfileSettingsImpl();
        cloned.backend = this.backend;
        cloned.profile = this.profile;
        cloned.ram = new HashMap<LauncherBackendAPI.ClientProfileSettings.MemoryClass, Long>(this.ram);
        cloned.flags = new HashSet<LauncherBackendAPI.ClientProfileSettings.Flag>(this.flags);
        cloned.enabled = new HashSet<String>(this.enabled);
        if (this.view != null) {
            cloned.view = new OptionalView(this.profile, this.view);
        }
        cloned.selectedJava = this.selectedJava;
        cloned.saveJavaPath = this.saveJavaPath;
        return cloned;
    }

    public void updateEnabledMods() {
        this.enabled = new HashSet<String>();
        for (OptionalFile e : this.view.enabled) {
            this.enabled.add(e.name);
        }
        if (this.selectedJava != null) {
            this.saveJavaPath = this.selectedJava.getPath().toAbsolutePath().toString();
        }
    }

    public void initAfterGson(ClientProfile profile, LauncherBackendImpl backend) {
        this.backend = backend;
        this.profile = profile;
        this.view = new OptionalView(profile);
        for (String e : this.enabled) {
            OptionalFile opt = profile.getOptionalFile(e);
            if (opt == null) continue;
            this.enableOptional((ProfileFeatureAPI.OptionalMod)opt, (var1, var2) -> {});
        }
        if (this.saveJavaPath != null) {
            backend.getAvailableJava().thenAccept(javas -> {
                for (LauncherBackendAPI.Java java : javas) {
                    if (!this.isCompatible(java) || java.getPath() == null || !java.getPath().toAbsolutePath().toString().equals(this.saveJavaPath)) continue;
                    this.selectedJava = (JavaHelper.JavaVersion)java;
                    return;
                }
            });
        }
    }
}

