/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.base.request;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.base.events.request.AuthRequestEvent;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launcher.base.profiles.Texture;
import pro.gravit.launcher.base.request.Request;
import pro.gravit.launcher.base.request.RequestException;
import pro.gravit.launcher.base.request.RequestService;
import pro.gravit.launcher.base.request.auth.AuthRequest;
import pro.gravit.launcher.base.request.auth.CheckServerRequest;
import pro.gravit.launcher.base.request.auth.CurrentUserRequest;
import pro.gravit.launcher.base.request.auth.ExitRequest;
import pro.gravit.launcher.base.request.auth.JoinServerRequest;
import pro.gravit.launcher.base.request.auth.RefreshTokenRequest;
import pro.gravit.launcher.base.request.auth.RestoreRequest;
import pro.gravit.launcher.base.request.auth.SetProfileRequest;
import pro.gravit.launcher.base.request.auth.password.Auth2FAPassword;
import pro.gravit.launcher.base.request.auth.password.AuthAESPassword;
import pro.gravit.launcher.base.request.auth.password.AuthCodePassword;
import pro.gravit.launcher.base.request.auth.password.AuthMultiPassword;
import pro.gravit.launcher.base.request.auth.password.AuthPlainPassword;
import pro.gravit.launcher.base.request.auth.password.AuthTOTPPassword;
import pro.gravit.launcher.base.request.cabinet.AssetUploadInfoRequest;
import pro.gravit.launcher.base.request.cabinet.GetAssetUploadUrl;
import pro.gravit.launcher.base.request.secure.GetSecureLevelInfoRequest;
import pro.gravit.launcher.base.request.secure.HardwareReportRequest;
import pro.gravit.launcher.base.request.secure.VerifySecureLevelKeyRequest;
import pro.gravit.launcher.base.request.update.ProfilesRequest;
import pro.gravit.launcher.base.request.update.UpdateRequest;
import pro.gravit.launcher.base.request.uuid.ProfileByUUIDRequest;
import pro.gravit.launcher.base.request.uuid.ProfileByUsernameRequest;
import pro.gravit.launcher.core.LauncherNetworkAPI;
import pro.gravit.launcher.core.api.features.AuthFeatureAPI;
import pro.gravit.launcher.core.api.features.HardwareVerificationFeatureAPI;
import pro.gravit.launcher.core.api.features.ProfileFeatureAPI;
import pro.gravit.launcher.core.api.features.TextureUploadFeatureAPI;
import pro.gravit.launcher.core.api.features.UserFeatureAPI;
import pro.gravit.launcher.core.api.method.AuthMethodPassword;
import pro.gravit.launcher.core.api.method.password.AuthChainPassword;
import pro.gravit.launcher.core.api.method.password.AuthOAuthPassword;
import pro.gravit.launcher.core.api.method.password.AuthTotpPassword;
import pro.gravit.launcher.core.api.model.SelfUser;
import pro.gravit.launcher.core.api.model.User;
import pro.gravit.launcher.core.hasher.HashedDir;
import pro.gravit.utils.helper.SecurityHelper;

public class RequestFeatureAPIImpl
implements AuthFeatureAPI,
UserFeatureAPI,
ProfileFeatureAPI,
TextureUploadFeatureAPI,
HardwareVerificationFeatureAPI {
    private final RequestService request;
    private final String authId;
    private final HttpClient client = HttpClient.newBuilder().build();

    public RequestFeatureAPIImpl(RequestService request, String authId) {
        this.request = request;
        this.authId = authId;
    }

    @Override
    public CompletableFuture<SelfUser> getCurrentUser() {
        return this.request.request(new CurrentUserRequest()).thenApply(response -> response.userInfo);
    }

    @Override
    public CompletableFuture<AuthFeatureAPI.AuthResponse> auth(String login, AuthMethodPassword password) {
        AuthRequest.ConnectTypes connectType = AuthRequest.ConnectTypes.API;
        if (Request.getExtendedTokens() != null && Request.getExtendedTokens().get("launcher") != null) {
            connectType = AuthRequest.ConnectTypes.CLIENT;
        }
        return this.request.request(new AuthRequest(login, this.convertAuthPasswordAll(password), this.authId, false, connectType)).thenApply(response -> {
            Request.setOAuth(this.authId, response.oauth);
            return new AuthFeatureAPI.AuthResponse(response.makeUserInfo(), response.oauth);
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AuthRequest.AuthPasswordInterface convertAuthPasswordAll(AuthMethodPassword password) {
        Iterator<AuthMethodPassword> iterator;
        AuthMultiPassword multi;
        if (!(password instanceof AuthChainPassword)) return this.convertAuthPassword(password);
        AuthChainPassword authChainPassword = (AuthChainPassword)password;
        try {
            List<AuthMethodPassword> list;
            List<AuthMethodPassword> list2 = list = authChainPassword.list();
            if (list2.size() == 1) {
                return this.convertAuthPassword(list2.get(0));
            }
            if (list2.size() == 2) {
                return new Auth2FAPassword(this.convertAuthPassword(list2.get(0)), this.convertAuthPassword(list2.get(1)));
            }
            multi = new AuthMultiPassword();
            iterator = list2.iterator();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        while (iterator.hasNext()) {
            AuthMethodPassword e = iterator.next();
            multi.list.add(this.convertAuthPassword(e));
        }
        return multi;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AuthRequest.AuthPasswordInterface convertAuthPassword(AuthMethodPassword password) {
        if (password instanceof pro.gravit.launcher.core.api.method.password.AuthPlainPassword) {
            String encryptKey;
            String value;
            pro.gravit.launcher.core.api.method.password.AuthPlainPassword authPlainPassword = (pro.gravit.launcher.core.api.method.password.AuthPlainPassword)password;
            try {
                String string;
                value = string = authPlainPassword.value();
                encryptKey = Launcher.getConfig().passwordEncryptKey;
                if (encryptKey == null) return new AuthPlainPassword(value);
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            try {
                return new AuthAESPassword(SecurityHelper.encrypt(encryptKey, value));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (password instanceof AuthTotpPassword) {
            AuthTotpPassword authTotpPassword = (AuthTotpPassword)password;
            {
                String string;
                String value = string = authTotpPassword.value();
                return new AuthTOTPPassword(value);
            }
        }
        if (password instanceof AuthOAuthPassword) {
            AuthOAuthPassword authOAuthPassword = (AuthOAuthPassword)password;
            {
                String string;
                String redirectUrl = string = authOAuthPassword.redirectUrl();
                return new AuthCodePassword(redirectUrl);
            }
        }
        if (password instanceof AuthRequest.AuthPasswordInterface) {
            return (AuthRequest.AuthPasswordInterface)password;
        }
        if (password != null) throw new UnsupportedOperationException();
        return null;
    }

    @Override
    public CompletableFuture<User> getUserByUsername(String username) {
        return this.request.request(new ProfileByUsernameRequest(username)).thenApply(response -> response.playerProfile);
    }

    @Override
    public CompletableFuture<User> getUserByUUID(UUID uuid) {
        return this.request.request(new ProfileByUUIDRequest(uuid)).thenApply(response -> response.playerProfile);
    }

    @Override
    public CompletableFuture<Void> joinServer(String username, String accessToken, String serverID) {
        return this.request.request(new JoinServerRequest(username, accessToken, serverID)).thenCompose(response -> {
            if (response.allow) {
                return CompletableFuture.completedFuture(null);
            }
            return CompletableFuture.failedFuture(new RequestException("Not allowed"));
        });
    }

    @Override
    public CompletableFuture<Void> joinServer(UUID uuid, String accessToken, String serverID) {
        return this.request.request(new JoinServerRequest(uuid, accessToken, serverID)).thenCompose(response -> {
            if (response.allow) {
                return CompletableFuture.completedFuture(null);
            }
            return CompletableFuture.failedFuture(new RequestException("Not allowed"));
        });
    }

    @Override
    public CompletableFuture<UserFeatureAPI.CheckServerResponse> checkServer(String username, String serverID, boolean extended) {
        return this.request.request(new CheckServerRequest(username, serverID, extended, extended)).thenApply(response -> new UserFeatureAPI.CheckServerResponse(response.playerProfile, response.hardwareId, response.sessionId, response.sessionProperties));
    }

    @Override
    public CompletableFuture<AuthFeatureAPI.AuthToken> refreshToken(String refreshToken) {
        return this.request.request(new RefreshTokenRequest(this.authId, refreshToken)).thenApply(response -> response.oauth);
    }

    @Override
    public CompletableFuture<SelfUser> restore(String accessToken, boolean fetchUser) {
        HashMap<String, String> extended = new HashMap<String, String>();
        if (Request.getExtendedTokens() != null) {
            for (Map.Entry<String, Request.ExtendedToken> e2 : Request.getExtendedTokens().entrySet()) {
                extended.put(e2.getKey(), e2.getValue().token);
            }
        }
        return this.request.request(new RestoreRequest(this.authId, accessToken, extended, fetchUser)).thenApply(e -> {
            Request.setOAuth(this.authId, new AuthRequestEvent.OAuthRequestEvent(accessToken, null, 0L));
            return e.userInfo;
        });
    }

    @Override
    public CompletableFuture<Void> exit() {
        return this.request.request(new ExitRequest()).thenApply(response -> null);
    }

    @Override
    public CompletableFuture<List<ProfileFeatureAPI.ClientProfile>> getProfiles() {
        return this.request.request(new ProfilesRequest()).thenApply(response -> response.profiles);
    }

    @Override
    public CompletableFuture<Void> changeCurrentProfile(ProfileFeatureAPI.ClientProfile profile) {
        return this.request.request(new SetProfileRequest((ClientProfile)profile)).thenApply(response -> null);
    }

    @Override
    public CompletableFuture<ProfileFeatureAPI.UpdateInfo> fetchUpdateInfo(String dirName) {
        return this.request.request(new UpdateRequest(dirName)).thenApply(response -> new UpdateInfoData(response.hdir, response.url));
    }

    @Override
    public CompletableFuture<TextureUploadFeatureAPI.TextureUploadInfo> fetchInfo() {
        return this.request.request(new AssetUploadInfoRequest()).thenApply(response -> response);
    }

    @Override
    public CompletableFuture<pro.gravit.launcher.core.api.model.Texture> upload(String name, byte[] bytes, TextureUploadFeatureAPI.UploadSettings settings) {
        return ((CompletableFuture)this.request.request(new GetAssetUploadUrl(name)).thenCompose(response -> {
            byte[] postFileData;
            byte[] preFileData;
            String accessToken = response.token == null ? Request.getAccessToken() : response.token.accessToken;
            String boundary = SecurityHelper.toHex(SecurityHelper.randomBytes(32));
            String jsonOptions = settings == null ? "{}" : Launcher.gsonManager.gson.toJson(new TextureUploadOptions(settings.slim()));
            try (ByteArrayOutputStream output = new ByteArrayOutputStream(256);){
                output.write("--".getBytes(StandardCharsets.UTF_8));
                output.write(boundary.getBytes(StandardCharsets.UTF_8));
                output.write("\r\nContent-Disposition: form-data; name=\"options\"\r\nContent-Type: application/json\r\n\r\n".getBytes(StandardCharsets.UTF_8));
                output.write(jsonOptions.getBytes(StandardCharsets.UTF_8));
                output.write("\r\n--".getBytes(StandardCharsets.UTF_8));
                output.write(boundary.getBytes(StandardCharsets.UTF_8));
                output.write("\r\nContent-Disposition: form-data; name=\"file\"; filename=\"file\"\r\nContent-Type: image/png\r\n\r\n".getBytes(StandardCharsets.UTF_8));
                preFileData = output.toByteArray();
            }
            catch (IOException ex) {
                return CompletableFuture.failedFuture(ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream(128);){
                output.write("\r\n--".getBytes(StandardCharsets.UTF_8));
                output.write(boundary.getBytes(StandardCharsets.UTF_8));
                output.write("--\r\n".getBytes(StandardCharsets.UTF_8));
                postFileData = output.toByteArray();
            }
            catch (IOException ex) {
                return CompletableFuture.failedFuture(ex);
            }
            return this.client.sendAsync(HttpRequest.newBuilder().uri(URI.create(response.url)).POST(HttpRequest.BodyPublishers.concat(HttpRequest.BodyPublishers.ofByteArray(preFileData), HttpRequest.BodyPublishers.ofByteArray(bytes), HttpRequest.BodyPublishers.ofByteArray(postFileData))).header("Authorization", "Bearer " + accessToken).header("Content-Type", "multipart/form-data; boundary=\"" + boundary + "\"").header("Accept", "application/json").build(), HttpResponse.BodyHandlers.ofByteArray());
        })).thenCompose(response -> {
            CompletableFuture x22;
            if (response.statusCode() >= 200 && response.statusCode() < 300) {
                CompletableFuture<pro.gravit.launcher.core.api.model.Texture> completableFuture;
                InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream((byte[])response.body()));
                try {
                    completableFuture = CompletableFuture.completedFuture(Launcher.gsonManager.gson.fromJson((Reader)reader, UserTexture.class).toLauncherTexture());
                }
                catch (Throwable t$) {
                    try {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable x22) {
                            t$.addSuppressed(x22);
                        }
                        throw t$;
                    }
                    catch (Throwable e) {
                        return CompletableFuture.failedFuture(e);
                    }
                }
                ((Reader)reader).close();
                return completableFuture;
            }
            InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream((byte[])response.body()));
            try {
                UploadError error = Launcher.gsonManager.gson.fromJson((Reader)reader, UploadError.class);
                x22 = CompletableFuture.failedFuture(new RequestException(error.error()));
            }
            catch (Throwable t$) {
                try {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable x23) {
                        t$.addSuppressed(x23);
                    }
                    throw t$;
                }
                catch (Exception ex) {
                    return CompletableFuture.failedFuture(ex);
                }
            }
            ((Reader)reader).close();
            return x22;
        });
    }

    @Override
    public CompletableFuture<HardwareVerificationFeatureAPI.SecurityLevelInfo> getSecurityInfo() {
        return this.request.request(new GetSecureLevelInfoRequest()).thenApply(response -> response);
    }

    @Override
    public CompletableFuture<HardwareVerificationFeatureAPI.SecurityLevelVerification> privateKeyVerification(PublicKey publicKey, byte[] signature) {
        return this.request.request(new VerifySecureLevelKeyRequest(publicKey.getEncoded(), signature)).thenApply(response -> response);
    }

    @Override
    public CompletableFuture<Void> sendHardwareInfo(HardwareVerificationFeatureAPI.HardwareStatisticData statisticData, HardwareVerificationFeatureAPI.HardwareIdentifyData identifyData) {
        if (statisticData == null && identifyData == null) {
            return this.request.request(new HardwareReportRequest()).thenApply(response -> null);
        }
        HardwareReportRequest.HardwareInfo hardwareInfo = new HardwareReportRequest.HardwareInfo();
        if (statisticData != null) {
            hardwareInfo.bitness = statisticData.arch() == HardwareVerificationFeatureAPI.Arch.X86 || statisticData.arch() == HardwareVerificationFeatureAPI.Arch.ARM32 ? 32 : 64;
            hardwareInfo.totalMemory = statisticData.totalPhysicalMemory();
            hardwareInfo.logicalProcessors = statisticData.logicalProcessors();
            hardwareInfo.physicalProcessors = statisticData.physicalProcessors();
            hardwareInfo.processorMaxFreq = statisticData.processorMaxFreq();
            hardwareInfo.battery = statisticData.battery();
            hardwareInfo.graphicCard = statisticData.graphicCard();
        }
        if (identifyData != null) {
            hardwareInfo.hwDiskId = identifyData.persistentStorageId();
            hardwareInfo.displayId = identifyData.edid();
            hardwareInfo.baseboardSerialNumber = identifyData.baseboardSerialNumber();
        }
        return this.request.request(new HardwareReportRequest(hardwareInfo)).thenApply(response -> null);
    }

    public record UserTexture(@LauncherNetworkAPI String url, @LauncherNetworkAPI String digest, @LauncherNetworkAPI Map<String, String> metadata) {
        pro.gravit.launcher.core.api.model.Texture toLauncherTexture() {
            return new Texture(this.url, SecurityHelper.fromHex(this.digest), this.metadata);
        }
    }

    public record UploadError(@LauncherNetworkAPI String error) {
    }

    public record TextureUploadOptions(boolean modelSlim) {
    }

    public record UpdateInfoData(HashedDir hdir, String url) implements ProfileFeatureAPI.UpdateInfo
    {
        @Override
        public HashedDir getHashedDir() {
            return this.hdir;
        }

        @Override
        public String getUrl() {
            return this.url;
        }
    }
}

