/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.runtime.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.core.LauncherNetworkAPI;
import pro.gravit.launcher.core.hasher.HashedDir;
import pro.gravit.launcher.core.hasher.HashedEntry;
import pro.gravit.utils.helper.IOHelper;

public class AssetIndexHelper {
    public static AssetIndex parse(Path path) throws IOException {
        try (BufferedReader reader = IOHelper.newReader(path);){
            AssetIndex assetIndex = Launcher.gsonManager.gson.fromJson((Reader)reader, AssetIndex.class);
            return assetIndex;
        }
    }

    public static void modifyHashedDir(AssetIndex index, HashedDir original) {
        HashSet<String> hashes = new HashSet<String>();
        for (AssetIndexObject obj : index.objects.values()) {
            hashes.add(obj.hash);
        }
        HashedDir objects = (HashedDir)original.getEntry("objects");
        ArrayList<String> toDeleteDirs = new ArrayList<String>(16);
        for (Map.Entry<String, HashedEntry> entry : objects.map().entrySet()) {
            if (entry.getValue().getType() != HashedEntry.Type.DIR) continue;
            HashedDir dir = (HashedDir)entry.getValue();
            ArrayList<String> toDelete = new ArrayList<String>(16);
            for (String hash : dir.map().keySet()) {
                if (hashes.contains(hash)) continue;
                toDelete.add(hash);
            }
            for (String s : toDelete) {
                dir.remove(s);
            }
            if (!dir.map().isEmpty()) continue;
            toDeleteDirs.add(entry.getKey());
        }
        for (String s : toDeleteDirs) {
            objects.remove(s);
        }
    }

    public static class AssetIndex {
        @LauncherNetworkAPI
        public boolean virtual;
        @LauncherNetworkAPI
        public Map<String, AssetIndexObject> objects;
    }

    public static class AssetIndexObject {
        @LauncherNetworkAPI
        public String hash;
        @LauncherNetworkAPI
        public long size;
    }
}

