/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.helper;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HexFormat;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.VerifyHelper;

public final class IOHelper {
    public static final long MB32 = 0x2000000L;
    public static final Charset UNICODE_CHARSET = StandardCharsets.UTF_8;
    public static final Charset ASCII_CHARSET = StandardCharsets.US_ASCII;
    public static final int MAX_BATCH_SIZE = 128;
    public static final int SOCKET_TIMEOUT = VerifyHelper.verifyInt(Integer.parseUnsignedInt(System.getProperty("launcher.socketTimeout", Integer.toString(30000))), VerifyHelper.POSITIVE, "launcher.socketTimeout can't be <= 0");
    public static final int HTTP_TIMEOUT = VerifyHelper.verifyInt(Integer.parseUnsignedInt(System.getProperty("launcher.httpTimeout", Integer.toString(5000))), VerifyHelper.POSITIVE, "launcher.httpTimeout can't be <= 0");
    public static final int BUFFER_SIZE = VerifyHelper.verifyInt(Integer.parseUnsignedInt(System.getProperty("launcher.bufferSize", Integer.toString(4096))), VerifyHelper.POSITIVE, "launcher.bufferSize can't be <= 0");
    public static final String CROSS_SEPARATOR = "/";
    public static final FileSystem FS = FileSystems.getDefault();
    public static final String PLATFORM_SEPARATOR = FS.getSeparator();
    private static final Pattern PLATFORM_SEPARATOR_PATTERN = Pattern.compile(PLATFORM_SEPARATOR, 16);
    public static final boolean POSIX = FS.supportedFileAttributeViews().contains("posix") || FS.supportedFileAttributeViews().contains("Posix");
    public static final Path JVM_DIR = Paths.get(System.getProperty("java.home"), new String[0]);
    public static final Path HOME_DIR = Paths.get(System.getProperty("user.home"), new String[0]);
    public static final Path WORKING_DIR = Paths.get(System.getProperty("user.dir"), new String[0]);
    public static final String USER_AGENT = System.getProperty("launcher.userAgentDefault", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)");
    private static final OpenOption[] READ_OPTIONS = new OpenOption[]{StandardOpenOption.READ};
    private static final OpenOption[] WRITE_OPTIONS = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING};
    private static final OpenOption[] APPEND_OPTIONS = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND};
    private static final LinkOption[] LINK_OPTIONS = new LinkOption[0];
    private static final CopyOption[] COPY_OPTIONS = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
    private static final Set<FileVisitOption> WALK_OPTIONS = Collections.singleton(FileVisitOption.FOLLOW_LINKS);
    private static final Pattern CROSS_SEPARATOR_PATTERN = Pattern.compile("/", 16);

    private IOHelper() {
    }

    public static void close(AutoCloseable closeable) {
        try {
            closeable.close();
        }
        catch (Exception exc) {
            LogHelper.error(exc);
        }
    }

    public static void close(InputStream in) {
        try {
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void close(OutputStream out) {
        try {
            out.flush();
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Manifest getManifest(Class<?> clazz) {
        Manifest manifest;
        Path path = IOHelper.getCodeSource(clazz);
        JarFile jar = new JarFile(path.toFile());
        try {
            manifest = jar.getManifest();
        }
        catch (Throwable throwable) {
            try {
                try {
                    jar.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        jar.close();
        return manifest;
    }

    public static URL convertToURL(String url) {
        try {
            return new URI(url).toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URL", e);
        }
    }

    public static void copy(Path source, Path target) throws IOException {
        IOHelper.createParentDirs(target);
        Files.copy(source, target, COPY_OPTIONS);
    }

    public static void createParentDirs(Path path) throws IOException {
        Path parent = path.getParent();
        if (parent != null && !IOHelper.isDir(parent)) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
    }

    public static String decode(byte[] bytes) {
        return new String(bytes, UNICODE_CHARSET);
    }

    public static String decodeASCII(byte[] bytes) {
        return new String(bytes, ASCII_CHARSET);
    }

    public static void deleteDir(Path dir, boolean self) throws IOException {
        IOHelper.walk(dir, new DeleteDirVisitor(dir, self), true);
    }

    public static byte[] encode(String s) {
        return s.getBytes(UNICODE_CHARSET);
    }

    public static byte[] encodeASCII(String s) {
        return s.getBytes(ASCII_CHARSET);
    }

    public static boolean exists(Path path) {
        return Files.exists(path, LINK_OPTIONS);
    }

    public static Path getCodeSource(Class<?> clazz) {
        return Paths.get(IOHelper.toURI(clazz.getProtectionDomain().getCodeSource().getLocation()));
    }

    public static String getFileName(Path path) {
        return path.getFileName().toString();
    }

    public static String getIP(SocketAddress address) {
        return ((InetSocketAddress)address).getAddress().getHostAddress();
    }

    public static Path getRoot() {
        return switch (JVMHelper.OS_TYPE) {
            default -> throw new MatchException(null, null);
            case JVMHelper.OS.MUSTDIE -> {
                String drive = System.getenv("SystemDrive").concat("\\");
                yield Paths.get(drive, new String[0]);
            }
            case JVMHelper.OS.LINUX, JVMHelper.OS.MACOSX -> Paths.get(CROSS_SEPARATOR, new String[0]);
        };
    }

    public static byte[] getResourceBytes(String name) throws IOException {
        return IOHelper.read(IOHelper.getResourceURL(name));
    }

    public static URL getResourceURL(String name) throws NoSuchFileException {
        URL url = IOHelper.class.getResource(CROSS_SEPARATOR + name);
        if (url == null) {
            throw new NoSuchFileException(name);
        }
        return url;
    }

    public static boolean hasExtension(Path file, String extension) {
        return IOHelper.getFileName(file).endsWith("." + extension);
    }

    public static boolean isDir(Path path) {
        return Files.isDirectory(path, LINK_OPTIONS);
    }

    public static boolean isEmpty(Path dir) throws IOException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            boolean bl = !stream.iterator().hasNext();
            return bl;
        }
    }

    public static boolean isFile(Path path) {
        return Files.isRegularFile(path, LINK_OPTIONS);
    }

    public static boolean isValidFileName(String fileName) {
        return !fileName.equals(".") && !fileName.equals("..") && fileName.chars().noneMatch(ch -> ch == 47 || ch == 92) && IOHelper.isValidPath(fileName);
    }

    public static boolean isValidPath(String path) {
        try {
            IOHelper.toPath(path);
            return true;
        }
        catch (InvalidPathException ignored) {
            return false;
        }
    }

    public static boolean isValidTextureBounds(int width, int height, boolean cloak) {
        return width % 64 == 0 && (height << 1 == width || !cloak && height == width) && width <= 1024 || cloak && width % 22 == 0 && height % 17 == 0 && width / 22 == height / 17;
    }

    public static void move(Path source, Path target) throws IOException {
        IOHelper.walk(source, new MoveFileVisitor(source, target), true);
    }

    public static byte[] newBuffer() {
        return new byte[BUFFER_SIZE];
    }

    public static ByteArrayOutputStream newByteArrayOutput() {
        return new ByteArrayOutputStream();
    }

    public static char[] newCharBuffer() {
        return new char[BUFFER_SIZE];
    }

    public static URLConnection newConnection(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        if (connection instanceof HttpURLConnection) {
            connection.setReadTimeout(HTTP_TIMEOUT);
            connection.setConnectTimeout(HTTP_TIMEOUT);
            connection.addRequestProperty("User-Agent", USER_AGENT);
        } else {
            connection.setUseCaches(false);
        }
        connection.setDoInput(true);
        connection.setDoOutput(false);
        return connection;
    }

    public static HttpURLConnection newConnectionPost(URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)IOHelper.newConnection(url);
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        return connection;
    }

    public static Deflater newDeflater() {
        Deflater deflater = new Deflater(-1, true);
        deflater.setStrategy(0);
        return deflater;
    }

    public static Inflater newInflater() {
        return new Inflater(true);
    }

    public static InputStream newInput(Path file) throws IOException {
        return Files.newInputStream(file, READ_OPTIONS);
    }

    public static InputStream newBufferedInput(Path file) throws IOException {
        return new BufferedInputStream(Files.newInputStream(file, READ_OPTIONS));
    }

    public static InputStream newInput(URL url) throws IOException {
        return IOHelper.newConnection(url).getInputStream();
    }

    public static BufferedInputStream newBufferedInput(URL url) throws IOException {
        return new BufferedInputStream(IOHelper.newConnection(url).getInputStream());
    }

    public static OutputStream newOutput(Path file) throws IOException {
        return IOHelper.newOutput(file, false);
    }

    public static OutputStream newBufferedOutput(Path file) throws IOException {
        return IOHelper.newBufferedOutput(file, false);
    }

    public static OutputStream newOutput(Path file, boolean append) throws IOException {
        IOHelper.createParentDirs(file);
        return Files.newOutputStream(file, append ? APPEND_OPTIONS : WRITE_OPTIONS);
    }

    public static OutputStream newBufferedOutput(Path file, boolean append) throws IOException {
        IOHelper.createParentDirs(file);
        return new BufferedOutputStream(Files.newOutputStream(file, append ? APPEND_OPTIONS : WRITE_OPTIONS));
    }

    public static BufferedReader newReader(InputStream input) {
        return IOHelper.newReader(input, UNICODE_CHARSET);
    }

    public static BufferedReader newReader(InputStream input, Charset charset) {
        return new BufferedReader(new InputStreamReader(input, charset));
    }

    public static BufferedReader newReader(Path file) throws IOException {
        return Files.newBufferedReader(file, UNICODE_CHARSET);
    }

    public static BufferedReader newReader(URL url) throws IOException {
        URLConnection connection = IOHelper.newConnection(url);
        String charset = connection.getContentEncoding();
        return IOHelper.newReader(connection.getInputStream(), charset == null ? UNICODE_CHARSET : Charset.forName(charset));
    }

    public static Socket newSocket() throws SocketException {
        Socket socket = new Socket();
        IOHelper.setSocketFlags(socket);
        return socket;
    }

    public static BufferedWriter newWriter(FileDescriptor fd) {
        return IOHelper.newWriter(new FileOutputStream(fd));
    }

    public static BufferedWriter newWriter(OutputStream output) {
        return new BufferedWriter(new OutputStreamWriter(output, UNICODE_CHARSET));
    }

    public static BufferedWriter newWriter(Path file) throws IOException {
        return IOHelper.newWriter(file, false);
    }

    public static BufferedWriter newWriter(Path file, boolean append) throws IOException {
        IOHelper.createParentDirs(file);
        return Files.newBufferedWriter(file, UNICODE_CHARSET, append ? APPEND_OPTIONS : WRITE_OPTIONS);
    }

    public static ZipEntry newZipEntry(String name) {
        ZipEntry entry = new ZipEntry(name);
        entry.setTime(0L);
        return entry;
    }

    public static ZipEntry newZipEntry(ZipEntry entry) {
        return IOHelper.newZipEntry(entry.getName());
    }

    public static ZipInputStream newZipInput(InputStream input) {
        return new ZipInputStream(input, UNICODE_CHARSET);
    }

    public static ZipInputStream newZipInput(Path file) throws IOException {
        return IOHelper.newZipInput(IOHelper.newInput(file));
    }

    public static ZipInputStream newZipInput(URL url) throws IOException {
        return IOHelper.newZipInput(IOHelper.newInput(url));
    }

    public static byte[] read(InputStream input) throws IOException {
        try (ByteArrayOutputStream output = IOHelper.newByteArrayOutput();){
            IOHelper.transfer(input, (OutputStream)output);
            byte[] byArray = output.toByteArray();
            return byArray;
        }
    }

    public static void read(InputStream input, byte[] bytes) throws IOException {
        int length;
        for (int offset = 0; offset < bytes.length; offset += length) {
            length = input.read(bytes, offset, bytes.length - offset);
            if (length >= 0) continue;
            throw new EOFException(String.format("%d bytes remaining", bytes.length - offset));
        }
    }

    public static byte[] read(Path file) throws IOException {
        long size = IOHelper.readAttributes(file).size();
        if (size > Integer.MAX_VALUE) {
            throw new IOException("File too big");
        }
        byte[] bytes = new byte[(int)size];
        try (InputStream input = IOHelper.newInput(file);){
            IOHelper.read(input, bytes);
        }
        return bytes;
    }

    public static byte[] read(URL url) throws IOException {
        try (InputStream input = IOHelper.newInput(url);){
            byte[] byArray = IOHelper.read(input);
            return byArray;
        }
    }

    public static BasicFileAttributes readAttributes(Path path) throws IOException {
        return Files.readAttributes(path, BasicFileAttributes.class, LINK_OPTIONS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readTexture(Object input, boolean cloak) throws IOException {
        ImageReader reader = ImageIO.getImageReadersByMIMEType("image/png").next();
        try {
            reader.setInput(ImageIO.createImageInputStream(input), false, false);
            int width = reader.getWidth(0);
            int height = reader.getHeight(0);
            if (!IOHelper.isValidTextureBounds(width, height, cloak)) {
                throw new IOException(String.format("Invalid texture bounds: %dx%d", width, height));
            }
            reader.read(0);
        }
        finally {
            reader.dispose();
        }
    }

    public static String request(URL url) throws IOException {
        return IOHelper.decode(IOHelper.read(url)).trim();
    }

    public static InetSocketAddress resolve(InetSocketAddress address) {
        if (address.isUnresolved()) {
            return new InetSocketAddress(address.getHostString(), address.getPort());
        }
        return address;
    }

    public static Path resolveIncremental(Path dir, String name, String extension) {
        Path path;
        Path original = dir.resolve(name + "." + extension);
        if (!IOHelper.exists(original)) {
            return original;
        }
        int counter = 1;
        while (IOHelper.exists(path = dir.resolve(String.format("%s (%d).%s", name, counter, extension)))) {
            ++counter;
        }
        return path;
    }

    public static Path resolveJavaBin(Path javaDir) {
        return IOHelper.resolveJavaBin(javaDir, false);
    }

    public static Path resolveJavaBin(Path javaDir, boolean isConsole) {
        Path javawExe;
        Path javaBinDir = (javaDir == null ? JVM_DIR : javaDir).resolve("bin");
        if (!isConsole && !LogHelper.isDebugEnabled() && IOHelper.isFile(javawExe = javaBinDir.resolve("javaw.exe"))) {
            return javawExe;
        }
        Path javaExe = javaBinDir.resolve("java.exe");
        if (IOHelper.isFile(javaExe)) {
            return javaExe;
        }
        Path java = javaBinDir.resolve("java");
        if (IOHelper.isFile(java)) {
            return java;
        }
        throw new RuntimeException("Java binary wasn't found");
    }

    public static void setSocketFlags(Socket socket) throws SocketException {
        socket.setKeepAlive(false);
        socket.setTcpNoDelay(false);
        socket.setReuseAddress(true);
        socket.setSoTimeout(SOCKET_TIMEOUT);
        try {
            socket.setTrafficClass(28);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        socket.setPerformancePreferences(1, 0, 2);
    }

    public static String toAbsPathString(Path path) {
        return IOHelper.toAbsPath(path).toFile().getAbsolutePath();
    }

    public static Path toAbsPath(Path path) {
        return path.normalize().toAbsolutePath();
    }

    public static byte[] toByteArray(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(in.available());
        IOHelper.transfer(in, (OutputStream)out);
        return out.toByteArray();
    }

    public static Path toPath(String path) {
        return Paths.get(CROSS_SEPARATOR_PATTERN.matcher(path).replaceAll(Matcher.quoteReplacement(PLATFORM_SEPARATOR)), new String[0]);
    }

    public static String toString(Path path) {
        return PLATFORM_SEPARATOR_PATTERN.matcher(path.toString()).replaceAll(Matcher.quoteReplacement(CROSS_SEPARATOR));
    }

    public static URI toURI(URL url) {
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static URL toURL(Path path) {
        try {
            return path.toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new InternalError(e);
        }
    }

    public static void transfer(byte[] write, Path file, boolean append) throws IOException {
        try (OutputStream out = IOHelper.newOutput(file, append);){
            out.write(write);
        }
    }

    public static long transfer(InputStream input, OutputStream output) throws IOException {
        long transferred = 0L;
        byte[] buffer = IOHelper.newBuffer();
        int length = input.read(buffer);
        while (length >= 0) {
            output.write(buffer, 0, length);
            transferred += (long)length;
            length = input.read(buffer);
        }
        return transferred;
    }

    public static void transfer(InputStream input, Path file) throws IOException {
        IOHelper.transfer(input, file, false);
    }

    public static long transfer(InputStream input, Path file, boolean append) throws IOException {
        try (OutputStream output = IOHelper.newOutput(file, append);){
            long l = IOHelper.transfer(input, output);
            return l;
        }
    }

    public static void transfer(Path file, OutputStream output) throws IOException {
        try (InputStream input = IOHelper.newInput(file);){
            IOHelper.transfer(input, output);
        }
    }

    public static String urlDecode(String s) {
        return URLDecoder.decode(s, UNICODE_CHARSET);
    }

    public static String urlEncode(String s) {
        return URLEncoder.encode(s, UNICODE_CHARSET);
    }

    public static String urlDecodeStrict(String s) {
        StringBuilder builder = new StringBuilder();
        char[] charArray = s.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (c != '%') {
                builder.append(c);
                continue;
            }
            if (i + 2 >= charArray.length) {
                return null;
            }
            CharBuffer buffer = UNICODE_CHARSET.decode(ByteBuffer.wrap(HexFormat.of().parseHex(CharBuffer.wrap(charArray, i + 1, 2))));
            builder.append(buffer);
            i += 2;
        }
        return builder.toString();
    }

    public static String getPathFromUrlFragment(String urlFragment) {
        return urlFragment.indexOf(63) < 0 ? urlFragment : urlFragment.substring(0, urlFragment.indexOf(63));
    }

    public static String verifyFileName(String fileName) {
        return VerifyHelper.verify(fileName, IOHelper::isValidFileName, String.format("Invalid file name: '%s'", fileName));
    }

    public static int verifyLength(int length, int max) throws IOException {
        if (length < 0 || max < 0 && length != -max || max > 0 && length > max) {
            throw new IOException("Illegal length: " + length);
        }
        return length;
    }

    public static BufferedImage verifyTexture(BufferedImage skin, boolean cloak) {
        return VerifyHelper.verify(skin, i -> IOHelper.isValidTextureBounds(i.getWidth(), i.getHeight(), cloak), String.format("Invalid texture bounds: %dx%d", skin.getWidth(), skin.getHeight()));
    }

    public static String verifyURL(String url) {
        try {
            new URI(url);
            return url;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URL", e);
        }
    }

    public static void walk(Path dir, FileVisitor<Path> visitor, boolean hidden) throws IOException {
        Files.walkFileTree(dir, WALK_OPTIONS, Integer.MAX_VALUE, hidden ? visitor : new SkipHiddenVisitor(visitor));
    }

    public static void write(Path file, byte[] bytes) throws IOException {
        IOHelper.createParentDirs(file);
        Files.write(file, bytes, WRITE_OPTIONS);
    }

    public static InputStream nonClosing(InputStream in) {
        return new FilterInputStream(in){

            @Override
            public void close() {
            }
        };
    }

    public static OutputStream nonClosing(OutputStream out) {
        return new FilterOutputStream(out){

            @Override
            public void write(byte[] b, int offset, int len) throws IOException {
                this.out.write(b, offset, len);
            }

            @Override
            public void close() {
            }
        };
    }

    private static final class DeleteDirVisitor
    extends SimpleFileVisitor<Path> {
        private final Path dir;
        private final boolean self;

        private DeleteDirVisitor(Path dir, boolean self) {
            this.dir = dir;
            this.self = self;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            FileVisitResult result = super.postVisitDirectory(dir, exc);
            if (this.self || !this.dir.equals(dir)) {
                Files.delete(dir);
            }
            return result;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.delete(file);
            return super.visitFile(file, attrs);
        }
    }

    private static class MoveFileVisitor
    implements FileVisitor<Path> {
        private final Path from;
        private final Path to;

        private MoveFileVisitor(Path from, Path to) {
            this.from = from;
            this.to = to;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path file, BasicFileAttributes attrs) throws IOException {
            Path dir = this.to.resolve(this.from.relativize(file));
            if (!IOHelper.isDir(dir)) {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.move(file, this.to.resolve(this.from.relativize(file)), COPY_OPTIONS);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            throw exc;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            if (exc != null) {
                throw exc;
            }
            if (!this.from.equals(dir)) {
                Files.delete(dir);
            }
            return FileVisitResult.CONTINUE;
        }
    }

    private static final class SkipHiddenVisitor
    implements FileVisitor<Path> {
        private final FileVisitor<Path> visitor;

        private SkipHiddenVisitor(FileVisitor<Path> visitor) {
            this.visitor = visitor;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            return Files.isHidden(dir) ? FileVisitResult.CONTINUE : this.visitor.postVisitDirectory(dir, exc);
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            return Files.isHidden(dir) ? FileVisitResult.SKIP_SUBTREE : this.visitor.preVisitDirectory(dir, attrs);
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            return Files.isHidden(file) ? FileVisitResult.CONTINUE : this.visitor.visitFile(file, attrs);
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            return this.visitor.visitFileFailed(file, exc);
        }
    }
}

