/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.base.vfs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import pro.gravit.launcher.base.vfs.VfsDirectory;
import pro.gravit.launcher.base.vfs.VfsEntry;
import pro.gravit.launcher.base.vfs.VfsException;
import pro.gravit.launcher.base.vfs.VfsFile;
import pro.gravit.launcher.base.vfs.directory.SimpleVfsDirectory;
import pro.gravit.launcher.base.vfs.protocol.vfs.VfsURLStreamHandlerProvider;
import pro.gravit.utils.helper.LogHelper;

public class Vfs {
    private final VfsDirectory directory;
    private volatile String name;
    private static final Map<String, Vfs> map = new HashMap<String, Vfs>();
    private static final Vfs defaultImpl = new Vfs();

    public Vfs() {
        this.directory = new SimpleVfsDirectory();
    }

    public Vfs(VfsDirectory directory) {
        this.directory = directory;
    }

    public VfsEntry resolve(Path path) {
        return this.directory.resolve(path);
    }

    public VfsEntry createDirectories(Path path) {
        VfsDirectory current = this.directory;
        for (int i = 0; i < path.getNameCount(); ++i) {
            VfsDirectory vfsDirectory;
            String s = path.getName(i).toString();
            VfsEntry value = current.find(s);
            if (value == null) {
                value = new SimpleVfsDirectory();
                if (current instanceof SimpleVfsDirectory) {
                    SimpleVfsDirectory simpleVfsDirectory = (SimpleVfsDirectory)current;
                    simpleVfsDirectory.put(s, value);
                } else {
                    throw new VfsException(String.format("%s not support add new files", path.getParent()));
                }
            }
            if (!(value instanceof VfsDirectory)) {
                throw new VfsException(String.format("%s not a directory", path.getParent()));
            }
            current = vfsDirectory = (VfsDirectory)value;
        }
        return current;
    }

    public void put(Path path, VfsEntry entry) {
        VfsEntry parent = this.resolve(path.getParent());
        if (parent == null) {
            parent = this.createDirectories(path.getParent());
        }
        if (!(parent instanceof SimpleVfsDirectory)) {
            throw new VfsException(String.format("%s not support add new files", path.getParent()));
        }
        SimpleVfsDirectory dir = (SimpleVfsDirectory)parent;
        dir.put(path.getFileName().toString(), entry);
    }

    public void debugPrint(LogHelper.Level level) {
        this.debugPrint(level, this.directory, Path.of("", new String[0]));
    }

    private void debugPrint(LogHelper.Level level, VfsDirectory vfsDirectory, Path path) {
        try (Stream<String> stream = vfsDirectory.getFiles();){
            for (String e : stream.toList()) {
                VfsEntry entry = vfsDirectory.find(e);
                LogHelper.log(level, String.format("%s - %s", path.resolve(e), entry.getClass().getSimpleName()), false);
                if (!(entry instanceof VfsDirectory)) continue;
                VfsDirectory nextDirectory = (VfsDirectory)entry;
                this.debugPrint(level, nextDirectory, path.resolve(e));
            }
        }
    }

    public static void register(String name, Vfs vfs) {
        map.put(name, vfs);
        vfs.name = name;
    }

    public static Vfs getByName(String name) {
        if (name == null || name.isEmpty()) {
            return defaultImpl;
        }
        return map.get(name);
    }

    public static Vfs get() {
        return defaultImpl;
    }

    public InputStream getInputStream(Path path) throws IOException {
        VfsEntry entry = this.directory.resolve(path);
        if (entry == null) {
            throw new FileNotFoundException(String.format("File %s not found", path));
        }
        if (entry instanceof VfsFile) {
            VfsFile file = (VfsFile)entry;
            return file.getInputStream();
        }
        throw new VfsException(String.format("%s is a directory", path.getParent()));
    }

    public URL getURL(String path) throws IOException {
        return this.getURL(Paths.get(path, new String[0]));
    }

    public URL getURL(Path name) throws IOException {
        URL uRL;
        block10: {
            InputStream stream = this.getInputStream(name);
            try {
                String str = name.toString();
                if (File.separatorChar != '/') {
                    str = str.replace(File.separatorChar, '/');
                }
                uRL = new URI("vfs", this.name, "/" + str, null).toURL();
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (UnsupportedOperationException ex) {
                    throw new FileNotFoundException(name.toString());
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
            stream.close();
        }
        return uRL;
    }

    static {
        URL.setURLStreamHandlerFactory(new VfsURLStreamHandlerProvider());
        Vfs.register("", defaultImpl);
    }
}

