/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.runtime.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launcher.core.backend.LauncherBackendAPI;
import pro.gravit.launcher.core.serialize.HInput;
import pro.gravit.launcher.core.serialize.HOutput;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.VerifyHelper;

public final class ServerPinger {
    private static final String LEGACY_PING_HOST_MAGIC = "\u00a71";
    private static final String LEGACY_PING_HOST_CHANNEL = "MC|PingHost";
    private static final Pattern LEGACY_PING_HOST_DELIMETER = Pattern.compile("\u0000", 16);
    private static final int PACKET_LENGTH = 65535;
    private final InetSocketAddress address;
    private final int protocol;
    private final ClientProfile.Version version;
    private final Object cacheLock = new Object();
    private Result cache = null;
    private Exception cacheException = null;
    private Instant cacheTime = null;

    public ServerPinger(ClientProfile profile) {
        this(profile.getDefaultServerProfile(), profile.getVersion());
    }

    public ServerPinger(ClientProfile.ServerProfile profile, ClientProfile.Version version) {
        if (profile == null) {
            throw new NullPointerException("ServerProfile null");
        }
        this.address = profile.toSocketAddress();
        this.version = Objects.requireNonNull(version, "version");
        this.protocol = profile.protocol;
    }

    private static String readUTF16String(HInput input) throws IOException {
        int length = input.readUnsignedShort() << 1;
        byte[] encoded = input.readByteArray(-length);
        return new String(encoded, StandardCharsets.UTF_16BE);
    }

    private static void writeUTF16String(HOutput output, String s) throws IOException {
        output.writeShort((short)s.length());
        output.stream.write(s.getBytes(StandardCharsets.UTF_16BE));
    }

    /*
     * Exception decompiling
     */
    private Result doPing() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Result legacyPing(HInput input, HOutput output, boolean mc16) throws IOException {
        output.writeUnsignedByte(254);
        output.writeUnsignedByte(1);
        if (mc16) {
            byte[] customPayloadPacket;
            output.writeUnsignedByte(250);
            ServerPinger.writeUTF16String(output, LEGACY_PING_HOST_CHANNEL);
            try (ByteArrayOutputStream packetArray = IOHelper.newByteArrayOutput();){
                try (HOutput packetOutput = new HOutput(packetArray);){
                    packetOutput.writeUnsignedByte(74);
                    ServerPinger.writeUTF16String(packetOutput, this.address.getHostString());
                    packetOutput.writeInt(this.address.getPort());
                }
                customPayloadPacket = packetArray.toByteArray();
            }
            output.writeShort((short)customPayloadPacket.length);
            output.stream.write(customPayloadPacket);
        }
        output.flush();
        int kickPacketID = input.readUnsignedByte();
        if (kickPacketID != 255) {
            throw new IOException("Illegal kick packet ID: " + kickPacketID);
        }
        String response = ServerPinger.readUTF16String(input);
        LogHelper.debug("Ping response (legacy): '%s'", response);
        String[] splitted = LEGACY_PING_HOST_DELIMETER.split(response);
        if (splitted.length != 6) {
            throw new IOException("Tokens count mismatch");
        }
        String magic = splitted[0];
        if (!magic.equals(LEGACY_PING_HOST_MAGIC)) {
            throw new IOException("Magic file mismatch: " + magic);
        }
        int protocol = Integer.parseInt(splitted[1]);
        String clientVersion = splitted[2];
        int onlinePlayers = VerifyHelper.verifyInt(Integer.parseInt(splitted[4]), VerifyHelper.NOT_NEGATIVE, "onlinePlayers can't be < 0");
        int maxPlayers = VerifyHelper.verifyInt(Integer.parseInt(splitted[5]), VerifyHelper.NOT_NEGATIVE, "maxPlayers can't be < 0");
        return new Result(onlinePlayers, maxPlayers, response);
    }

    private Result modernPing(HInput input, HOutput output, int protocol) throws IOException {
        String response;
        byte[] handshakePacket;
        try (ByteArrayOutputStream packetArray = IOHelper.newByteArrayOutput();){
            try (HOutput packetOutput = new HOutput(packetArray);){
                packetOutput.writeVarInt(0);
                packetOutput.writeVarInt(protocol > 0 ? protocol : 4);
                packetOutput.writeString(this.address.getHostString(), 0);
                packetOutput.writeShort((short)this.address.getPort());
                packetOutput.writeVarInt(1);
            }
            handshakePacket = packetArray.toByteArray();
        }
        output.writeByteArray(handshakePacket, 65535);
        output.writeVarInt(1);
        output.writeVarInt(0);
        output.flush();
        int ab = 0;
        while (ab <= 0) {
            ab = IOHelper.verifyLength(input.readVarInt(), 65535);
        }
        byte[] statusPacket = input.readByteArray(-ab);
        try (HInput packetInput = new HInput(statusPacket);){
            int statusPacketID = packetInput.readVarInt();
            if (statusPacketID != 0) {
                throw new IOException("Illegal status packet ID: " + statusPacketID);
            }
            response = packetInput.readString(65535);
            LogHelper.dev("Ping response (modern): '%s'", response);
        }
        JsonElement element = JsonParser.parseString(response);
        if (element.isJsonPrimitive()) {
            throw new IOException(element.getAsString());
        }
        JsonObject object = element.getAsJsonObject();
        if (object.has("error")) {
            throw new IOException(object.get("error").getAsString());
        }
        JsonObject playersObject = object.get("players").getAsJsonObject();
        int online = playersObject.get("online").getAsInt();
        int max = playersObject.get("max").getAsInt();
        return new Result(online, max, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result ping() throws IOException {
        Instant now = Instant.now();
        Object object = this.cacheLock;
        synchronized (object) {
            if (this.cacheTime == null || Duration.between(now, this.cacheTime).toMillis() >= (long)IOHelper.SOCKET_TIMEOUT) {
                this.cacheTime = now;
                try {
                    this.cache = this.doPing();
                    this.cacheException = null;
                }
                catch (IOException | IllegalArgumentException e) {
                    this.cache = null;
                    this.cacheException = e;
                }
            }
            if (this.cache == null) {
                if (this.cacheException instanceof IOException) {
                    throw (IOException)this.cacheException;
                }
                if (this.cacheException instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)this.cacheException;
                }
                this.cacheException = new IOException("Unavailable");
                throw (IOException)this.cacheException;
            }
            return this.cache;
        }
    }

    public static final class Result
    implements LauncherBackendAPI.ServerPingInfo {
        public final int onlinePlayers;
        public final int maxPlayers;
        public final String raw;

        public Result(int onlinePlayers, int maxPlayers, String raw) {
            this.onlinePlayers = VerifyHelper.verifyInt(onlinePlayers, VerifyHelper.NOT_NEGATIVE, "onlinePlayers can't be < 0");
            this.maxPlayers = VerifyHelper.verifyInt(maxPlayers, VerifyHelper.NOT_NEGATIVE, "maxPlayers can't be < 0");
            this.raw = raw;
        }

        public boolean isOverfilled() {
            return this.onlinePlayers >= this.maxPlayers;
        }

        @Override
        public int getMaxOnline() {
            return this.maxPlayers;
        }

        @Override
        public int getOnline() {
            return this.onlinePlayers;
        }

        @Override
        public List<String> getPlayerNames() {
            return List.of();
        }
    }
}

