/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.runtime.utils;

import java.util.Iterator;
import java.util.List;
import oshi.SystemInfo;
import oshi.hardware.Display;
import oshi.hardware.GraphicsCard;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.software.os.OperatingSystem;
import pro.gravit.launcher.base.request.secure.HardwareReportRequest;
import pro.gravit.launcher.core.api.features.HardwareVerificationFeatureAPI;
import pro.gravit.utils.helper.JVMHelper;

public class HWIDProvider {
    public final SystemInfo systemInfo = new SystemInfo();
    public final OperatingSystem system = this.systemInfo.getOperatingSystem();
    public final HardwareAbstractionLayer hardware = this.systemInfo.getHardware();

    public int getBitness() {
        return this.system.getBitness();
    }

    public long getTotalMemory() {
        return this.hardware.getMemory().getTotal();
    }

    public long getProcessorMaxFreq() {
        return this.hardware.getProcessor().getMaxFreq();
    }

    public int getProcessorPhysicalCount() {
        return this.hardware.getProcessor().getPhysicalProcessorCount();
    }

    public int getProcessorLogicalCount() {
        return this.hardware.getProcessor().getLogicalProcessorCount();
    }

    public boolean isBattery() {
        List powerSources = this.hardware.getPowerSources();
        return powerSources != null && !powerSources.isEmpty();
    }

    public String getHWDiskID() {
        List hwDiskStore = this.hardware.getDiskStores();
        long size = 0L;
        HWDiskStore maxStore = null;
        for (HWDiskStore store : hwDiskStore) {
            if (store.getSize() <= size) continue;
            maxStore = store;
            size = store.getSize();
        }
        if (maxStore != null) {
            return maxStore.getSerial();
        }
        return null;
    }

    public GraphicsCard getGraphicCard() {
        List graphicsCards = this.hardware.getGraphicsCards();
        GraphicsCard result = null;
        long size = 0L;
        for (GraphicsCard card : graphicsCards) {
            long vram = card.getVRam();
            if (vram <= size) continue;
            result = card;
            size = vram;
        }
        return result;
    }

    public String getGraphicCardName() {
        GraphicsCard card = this.getGraphicCard();
        if (card == null) {
            return null;
        }
        return card.getName();
    }

    public long getGraphicCardMemory() {
        GraphicsCard card = this.getGraphicCard();
        if (card == null) {
            return 0L;
        }
        return card.getVRam();
    }

    public byte[] getDisplayID() {
        List displays = this.hardware.getDisplays();
        if (displays == null || displays.isEmpty()) {
            return null;
        }
        Iterator iterator = displays.iterator();
        if (iterator.hasNext()) {
            Display display = (Display)iterator.next();
            return display.getEdid();
        }
        return null;
    }

    public String getBaseboardSerialNumber() {
        return this.hardware.getComputerSystem().getBaseboard().getSerialNumber();
    }

    public HardwareVerificationFeatureAPI.HardwareStatisticData getStatisticData() {
        return new HardwareVerificationFeatureAPI.HardwareStatisticData(JVMHelper.ARCH.toHardwareFeatureArch((JVMHelper.ARCH)JVMHelper.ARCH_TYPE), JVMHelper.OS.toHardwareFeatureOs((JVMHelper.OS)JVMHelper.OS_TYPE), this.getTotalMemory(), this.getProcessorLogicalCount(), this.getProcessorPhysicalCount(), this.getProcessorMaxFreq(), this.isBattery(), this.getGraphicCardName());
    }

    public HardwareVerificationFeatureAPI.HardwareIdentifyData getIdentifyData() {
        return new HardwareVerificationFeatureAPI.HardwareIdentifyData(this.getBaseboardSerialNumber(), this.getHWDiskID(), this.getDisplayID());
    }

    public HardwareReportRequest.HardwareInfo getHardwareInfo(boolean needSerial) {
        HardwareReportRequest.HardwareInfo info = new HardwareReportRequest.HardwareInfo();
        info.bitness = this.getBitness();
        info.logicalProcessors = this.getProcessorLogicalCount();
        info.physicalProcessors = this.getProcessorPhysicalCount();
        info.processorMaxFreq = this.getProcessorMaxFreq();
        info.totalMemory = this.getTotalMemory();
        info.battery = this.isBattery();
        info.graphicCard = this.getGraphicCardName();
        if (needSerial) {
            info.hwDiskId = this.getHWDiskID();
            info.displayId = this.getDisplayID();
            info.baseboardSerialNumber = this.getBaseboardSerialNumber();
        }
        return info;
    }
}

