/*
 * Decompiled with CFR 0.152.
 */
package com.gravitlauncher.socketbridge;

import com.gravitlauncher.socketbridge.Constants;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public final class MessageHeader {
    public static final int BASE_HEADER_SIZE = 27;
    private final String name;
    private final boolean isResponse;
    private final long requestId;
    private final long contentLength;

    public MessageHeader(String name, boolean isResponse, long requestId, long contentLength) {
        this.name = name;
        this.isResponse = isResponse;
        this.requestId = requestId;
        this.contentLength = contentLength;
    }

    public byte[] serialize() {
        byte[] nameBytes = this.name.getBytes(StandardCharsets.UTF_8);
        ByteBuffer buffer = ByteBuffer.allocate(27 + nameBytes.length);
        buffer.putLong(Constants.MAGIC_NUMBER);
        buffer.putShort((short)nameBytes.length);
        buffer.putLong(this.contentLength);
        buffer.putLong(this.requestId);
        buffer.put((byte)(this.isResponse ? 1 : 0));
        buffer.put(nameBytes);
        return buffer.array();
    }

    public static long calculateSize(ByteBuffer buffer) {
        if (buffer.remaining() < 27) {
            return 27 - buffer.remaining();
        }
        long magicNumber = buffer.getLong();
        if (magicNumber != Constants.MAGIC_NUMBER) {
            throw new RuntimeException("Invalid magic number");
        }
        short nameLen = buffer.getShort();
        long contentLen = buffer.getLong();
        long totalLen = (long)(27 + nameLen) + contentLen - 8L - 2L - 8L;
        return totalLen - (long)buffer.remaining();
    }

    public static MessageHeader deserialize(ByteBuffer buffer) {
        long magicNumber = buffer.getLong();
        if (magicNumber != Constants.MAGIC_NUMBER) {
            throw new RuntimeException("Invalid magic number");
        }
        short nameLen = buffer.getShort();
        long contentLen = buffer.getLong();
        long requestId = buffer.getLong();
        boolean isResponse = buffer.get() != 0;
        byte[] nameBytes = new byte[nameLen];
        buffer.get(nameBytes);
        return new MessageHeader(new String(nameBytes, StandardCharsets.UTF_8), isResponse, requestId, contentLen);
    }

    public String name() {
        return this.name;
    }

    public boolean isResponse() {
        return this.isResponse;
    }

    public long requestId() {
        return this.requestId;
    }

    public long contentLength() {
        return this.contentLength;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        MessageHeader that = (MessageHeader)obj;
        return Objects.equals(this.name, that.name) && this.isResponse == that.isResponse && this.requestId == that.requestId && this.contentLength == that.contentLength;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.isResponse, this.requestId, this.contentLength);
    }

    public String toString() {
        return "MessageHeader[name=" + this.name + ", isResponse=" + this.isResponse + ", requestId=" + this.requestId + ", contentLength=" + this.contentLength + ']';
    }
}

