/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.base;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Flow;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import pro.gravit.launcher.core.CertificatePinningTrustManager;
import pro.gravit.launcher.core.LauncherInject;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class Downloader {
    @LauncherInject(value="launcher.certificatePinning")
    private static boolean isCertificatePinning;
    @LauncherInject(value="launcher.noHttp2")
    private static boolean isNoHttp2;
    private static volatile SSLSocketFactory sslSocketFactory;
    private static volatile SSLContext sslContext;
    protected final HttpClient client;
    protected final ExecutorService executor;
    protected final Queue<DownloadTask> tasks = new ConcurrentLinkedDeque<DownloadTask>();
    protected CompletableFuture<Void> future;

    protected Downloader(HttpClient client, ExecutorService executor) {
        this.client = client;
        this.executor = executor;
    }

    public static ThreadFactory getDaemonThreadFactory(String name) {
        return task -> {
            Thread thread = new Thread(task);
            thread.setName(name);
            thread.setDaemon(true);
            return thread;
        };
    }

    public static HttpClient.Builder newHttpClientBuilder() {
        try {
            if (isCertificatePinning) {
                return HttpClient.newBuilder().sslContext(Downloader.makeSSLContext()).version(isNoHttp2 ? HttpClient.Version.HTTP_1_1 : HttpClient.Version.HTTP_2).followRedirects(HttpClient.Redirect.NORMAL);
            }
            return HttpClient.newBuilder().version(isNoHttp2 ? HttpClient.Version.HTTP_1_1 : HttpClient.Version.HTTP_2).followRedirects(HttpClient.Redirect.NORMAL);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    public static SSLSocketFactory makeSSLSocketFactory() throws NoSuchAlgorithmException, CertificateException, KeyStoreException, IOException, KeyManagementException {
        if (sslSocketFactory != null) {
            return sslSocketFactory;
        }
        SSLContext sslContext = Downloader.makeSSLContext();
        sslSocketFactory = sslContext.getSocketFactory();
        return sslSocketFactory;
    }

    public static SSLContext makeSSLContext() throws NoSuchAlgorithmException, CertificateException, KeyStoreException, IOException, KeyManagementException {
        if (sslContext != null) {
            return sslContext;
        }
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, CertificatePinningTrustManager.getTrustManager().getTrustManagers(), new SecureRandom());
        return sslContext;
    }

    public static Downloader downloadFile(URI uri, Path path, ExecutorService executor) {
        boolean closeExecutor = false;
        if (executor == null) {
            executor = Executors.newSingleThreadExecutor(Downloader.getDaemonThreadFactory("Downloader"));
            closeExecutor = true;
        }
        Downloader downloader = Downloader.newDownloader(executor);
        downloader.future = downloader.downloadFile(uri, path);
        if (closeExecutor) {
            ExecutorService finalExecutor = executor;
            downloader.future = ((CompletableFuture)downloader.future.thenAccept(e -> finalExecutor.shutdownNow())).exceptionallyCompose(ex -> {
                finalExecutor.shutdownNow();
                return CompletableFuture.failedFuture(ex);
            });
        }
        return downloader;
    }

    public static Downloader downloadList(List<SizedFile> files, String baseURL, Path targetDir, DownloadCallback callback, ExecutorService executor, int threads) throws Exception {
        boolean closeExecutor = false;
        LogHelper.info("Download with Java 11+ HttpClient");
        if (executor == null) {
            executor = Executors.newWorkStealingPool(Math.min(3, threads));
            closeExecutor = true;
        }
        Downloader downloader = Downloader.newDownloader(executor);
        downloader.future = downloader.downloadFiles(files, baseURL, targetDir, callback, executor, threads);
        if (closeExecutor) {
            ExecutorService finalExecutor = executor;
            downloader.future = ((CompletableFuture)downloader.future.thenAccept(e -> finalExecutor.shutdownNow())).exceptionallyCompose(ex -> {
                finalExecutor.shutdownNow();
                return CompletableFuture.failedFuture(ex);
            });
        }
        return downloader;
    }

    public static Downloader newDownloader(ExecutorService executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        HttpClient.Builder builder = Downloader.newHttpClientBuilder().executor(executor);
        HttpClient client = builder.build();
        return new Downloader(client, executor);
    }

    public void cancel() {
        for (DownloadTask task : this.tasks) {
            if (task.isCompleted()) continue;
            task.cancel();
        }
        this.tasks.clear();
    }

    public boolean isCanceled() {
        return this.executor.isTerminated();
    }

    public CompletableFuture<Void> getFuture() {
        return this.future;
    }

    public CompletableFuture<Void> downloadFile(URI uri, Path path) {
        try {
            IOHelper.createParentDirs(path);
        }
        catch (IOException e) {
            return CompletableFuture.failedFuture(e);
        }
        return this.client.sendAsync(HttpRequest.newBuilder().GET().uri(uri).build(), HttpResponse.BodyHandlers.ofFile(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING)).thenCompose(t -> {
            if (t.statusCode() < 200 || t.statusCode() >= 400) {
                return CompletableFuture.failedFuture(new IOException(String.format("Failed to download %s: code %d", uri.toString(), t.statusCode())));
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    public CompletableFuture<Void> downloadFile(String url, Path path, DownloadCallback callback, ExecutorService executor) throws Exception {
        return this.downloadFiles(new ArrayList<SizedFile>(List.of(new SizedFile(url, path.getFileName().toString()))), null, path.getParent(), callback, executor, 1);
    }

    public CompletableFuture<Void> downloadFile(String url, Path path, long size, DownloadCallback callback, ExecutorService executor) throws Exception {
        return this.downloadFiles(new ArrayList<SizedFile>(List.of(new SizedFile(url, path.getFileName().toString(), size))), null, path.getParent(), callback, executor, 1);
    }

    public CompletableFuture<Void> downloadFiles(List<SizedFile> files, String baseURL, Path targetDir, DownloadCallback callback, ExecutorService executor, int threads) throws Exception {
        URI baseUri = baseURL == null ? null : new URI(baseURL);
        Collections.shuffle(files);
        ConcurrentLinkedDeque<SizedFile> queue = new ConcurrentLinkedDeque<SizedFile>(files);
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        AtomicInteger currentThreads = new AtomicInteger(threads);
        ConsumerObject consumerObject = new ConsumerObject();
        Consumer<HttpResponse> next = e -> {
            SizedFile file;
            if (callback != null && e != null) {
                callback.onComplete((Path)e.body());
            }
            if ((file = (SizedFile)queue.poll()) == null) {
                if (currentThreads.decrementAndGet() == 0) {
                    future.complete(null);
                }
                return;
            }
            try {
                DownloadTask task = this.sendAsync(file, baseUri, targetDir, callback);
                ((CompletableFuture)((CompletableFuture)task.completableFuture.thenCompose(res -> {
                    if (res.statusCode() < 200 || res.statusCode() >= 300) {
                        return CompletableFuture.failedFuture(new IOException(String.format("Failed to download %s: code %d", file.urlPath != null ? file.urlPath : file.filePath, res.statusCode())));
                    }
                    return CompletableFuture.completedFuture(res);
                })).thenAccept(consumerObject.next)).exceptionally(ec -> {
                    future.completeExceptionally((Throwable)ec);
                    return null;
                });
            }
            catch (Exception exception) {
                LogHelper.error(exception);
                future.completeExceptionally(exception);
            }
        };
        consumerObject.next = next;
        for (int i = 0; i < threads; ++i) {
            next.accept(null);
        }
        return future;
    }

    protected DownloadTask sendAsync(SizedFile file, URI baseUri, Path targetDir, DownloadCallback callback) throws Exception {
        IOHelper.createParentDirs(targetDir.resolve(file.filePath));
        ProgressTrackingBodyHandler<Path> bodyHandler = this.makeBodyHandler(targetDir.resolve(file.filePath), callback);
        CompletableFuture<HttpResponse<Path>> future = this.client.sendAsync(this.makeHttpRequest(baseUri, file.urlPath), bodyHandler);
        AtomicReference<Object> task = new AtomicReference<Object>(null);
        task.set(new DownloadTask(bodyHandler, null));
        this.tasks.add(task.get());
        ((DownloadTask)task.get()).completableFuture = future.thenApply(e -> {
            this.tasks.remove(task.get());
            return e;
        });
        return task.get();
    }

    public static URI makeURI(URI baseUri, String filePath) throws URISyntaxException {
        URI uri;
        if (filePath.startsWith("http://") || filePath.startsWith("https://")) {
            return URI.create(filePath);
        }
        if (baseUri != null) {
            String scheme = baseUri.getScheme();
            Object host = baseUri.getHost();
            int port = baseUri.getPort();
            if (port != -1) {
                host = (String)host + ":" + port;
            }
            String path = baseUri.getPath();
            uri = new URI(scheme, (String)host, path + filePath, "", "");
        } else {
            uri = new URI(filePath);
        }
        return uri;
    }

    protected HttpRequest makeHttpRequest(URI baseUri, String filePath) throws URISyntaxException {
        URI uri = Downloader.makeURI(baseUri, filePath);
        return HttpRequest.newBuilder().GET().uri(uri).header("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/45.0.2454.85 Safari/537.36").build();
    }

    protected ProgressTrackingBodyHandler<Path> makeBodyHandler(Path file, DownloadCallback callback) {
        return new ProgressTrackingBodyHandler<Path>(HttpResponse.BodyHandlers.ofFile(file, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING), callback);
    }

    public static interface DownloadCallback {
        public void apply(long var1);

        public void onComplete(Path var1);
    }

    public static class DownloadTask {
        public final ProgressTrackingBodyHandler<Path> bodyHandler;
        public CompletableFuture<HttpResponse<Path>> completableFuture;

        public DownloadTask(ProgressTrackingBodyHandler<Path> bodyHandler, CompletableFuture<HttpResponse<Path>> completableFuture) {
            this.bodyHandler = bodyHandler;
            this.completableFuture = completableFuture;
        }

        public boolean isCompleted() {
            return this.completableFuture.isDone() | this.completableFuture.isCompletedExceptionally();
        }

        public void cancel() {
            this.bodyHandler.cancel();
        }
    }

    public static class SizedFile {
        public final String urlPath;
        public final String filePath;
        public final long size;

        public SizedFile(String path, long size) {
            this.urlPath = path;
            this.filePath = path;
            this.size = size;
        }

        public SizedFile(String urlPath, String filePath, long size) {
            this.urlPath = urlPath;
            this.filePath = filePath;
            this.size = size;
        }

        public SizedFile(String urlPath, String filePath) {
            this.urlPath = urlPath;
            this.filePath = filePath;
            this.size = -1L;
        }
    }

    private static class ConsumerObject {
        Consumer<HttpResponse<Path>> next = null;

        private ConsumerObject() {
        }
    }

    public static class ProgressTrackingBodyHandler<T>
    implements HttpResponse.BodyHandler<T> {
        private final HttpResponse.BodyHandler<T> delegate;
        private final DownloadCallback callback;
        private ProgressTrackingBodySubscriber subscriber;
        private boolean isCanceled = false;

        public ProgressTrackingBodyHandler(HttpResponse.BodyHandler<T> delegate, DownloadCallback callback) {
            this.delegate = delegate;
            this.callback = callback;
        }

        @Override
        public HttpResponse.BodySubscriber<T> apply(HttpResponse.ResponseInfo responseInfo) {
            this.subscriber = new ProgressTrackingBodySubscriber(this.delegate.apply(responseInfo));
            if (this.isCanceled) {
                this.subscriber.cancel();
            }
            return this.subscriber;
        }

        public void cancel() {
            this.isCanceled = true;
            if (this.subscriber != null) {
                this.subscriber.cancel();
            }
        }

        private class ProgressTrackingBodySubscriber
        implements HttpResponse.BodySubscriber<T> {
            private final HttpResponse.BodySubscriber<T> delegate;
            private Flow.Subscription subscription;
            private boolean isCanceled = false;

            public ProgressTrackingBodySubscriber(HttpResponse.BodySubscriber<T> delegate) {
                this.delegate = delegate;
            }

            @Override
            public CompletionStage<T> getBody() {
                return this.delegate.getBody();
            }

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                this.subscription = subscription;
                if (this.isCanceled) {
                    subscription.cancel();
                }
                this.delegate.onSubscribe(subscription);
            }

            @Override
            public void onNext(List<ByteBuffer> byteBuffers) {
                long diff = 0L;
                for (ByteBuffer buffer : byteBuffers) {
                    diff += (long)buffer.remaining();
                }
                if (ProgressTrackingBodyHandler.this.callback != null) {
                    ProgressTrackingBodyHandler.this.callback.apply(diff);
                }
                this.delegate.onNext(byteBuffers);
            }

            @Override
            public void onError(Throwable throwable) {
                this.delegate.onError(throwable);
            }

            @Override
            public void onComplete() {
                this.delegate.onComplete();
            }

            public void cancel() {
                this.isCanceled = true;
                if (this.subscription != null) {
                    this.subscription.cancel();
                }
            }
        }
    }
}

