/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.runtime;

import java.nio.file.Paths;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.base.LauncherConfig;
import pro.gravit.launcher.base.modules.events.OfflineModeEvent;
import pro.gravit.launcher.base.modules.events.PreConfigPhase;
import pro.gravit.launcher.base.profiles.optional.actions.OptionalAction;
import pro.gravit.launcher.base.profiles.optional.triggers.OptionalTrigger;
import pro.gravit.launcher.base.request.Request;
import pro.gravit.launcher.base.request.RequestCoreFeatureAPIImpl;
import pro.gravit.launcher.base.request.RequestException;
import pro.gravit.launcher.base.request.RequestFeatureAPIImpl;
import pro.gravit.launcher.base.request.RequestService;
import pro.gravit.launcher.base.request.auth.AuthRequest;
import pro.gravit.launcher.base.request.auth.GetAvailabilityAuthRequest;
import pro.gravit.launcher.base.request.websockets.OfflineRequestService;
import pro.gravit.launcher.base.request.websockets.StdWebSocketService;
import pro.gravit.launcher.client.BasicLauncherEventHandler;
import pro.gravit.launcher.client.ClientLauncherEntryPoint;
import pro.gravit.launcher.client.ClientLauncherMethods;
import pro.gravit.launcher.client.ClientParams;
import pro.gravit.launcher.client.RuntimeLauncherCoreModule;
import pro.gravit.launcher.client.events.ClientExitPhase;
import pro.gravit.launcher.client.utils.NativeJVMHalt;
import pro.gravit.launcher.core.LauncherTrustManager;
import pro.gravit.launcher.core.api.LauncherAPI;
import pro.gravit.launcher.core.api.LauncherAPIHolder;
import pro.gravit.launcher.core.api.features.AuthFeatureAPI;
import pro.gravit.launcher.core.api.features.HardwareVerificationFeatureAPI;
import pro.gravit.launcher.core.api.features.ProfileFeatureAPI;
import pro.gravit.launcher.core.api.features.TextureUploadFeatureAPI;
import pro.gravit.launcher.core.api.features.UserFeatureAPI;
import pro.gravit.launcher.core.backend.LauncherBackendAPIHolder;
import pro.gravit.launcher.runtime.LauncherEngineWrapper;
import pro.gravit.launcher.runtime.backend.LauncherBackendImpl;
import pro.gravit.launcher.runtime.client.DirBridge;
import pro.gravit.launcher.runtime.client.RuntimeGsonManager;
import pro.gravit.launcher.runtime.client.events.ClientEngineInitPhase;
import pro.gravit.launcher.runtime.client.events.ClientPreGuiPhase;
import pro.gravit.launcher.runtime.console.ModulesCommand;
import pro.gravit.launcher.runtime.gui.NoRuntimeProvider;
import pro.gravit.launcher.runtime.gui.RuntimeProvider;
import pro.gravit.launcher.runtime.managers.ConsoleManager;
import pro.gravit.launcher.start.RuntimeModuleManager;
import pro.gravit.utils.helper.EnvHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;

public class LauncherEngine {
    public static ClientParams clientParams;
    public static RuntimeModuleManager modulesManager;
    public final boolean clientInstance;
    private final AtomicBoolean started = new AtomicBoolean(false);
    public RuntimeProvider runtimeProvider;
    public Class<? extends RuntimeProvider> basicRuntimeProvider;

    private LauncherEngine(boolean clientInstance, Class<? extends RuntimeProvider> basicRuntimeProvider) {
        this.clientInstance = clientInstance;
        this.basicRuntimeProvider = basicRuntimeProvider;
    }

    public static X509Certificate[] getCertificates(Class<?> clazz) {
        Object[] signers = clazz.getSigners();
        if (signers == null) {
            return null;
        }
        return (X509Certificate[])Arrays.stream(signers).filter(c -> c instanceof X509Certificate).map(c -> (X509Certificate)c).toArray(X509Certificate[]::new);
    }

    public static void checkClass(Class<?> clazz) throws SecurityException {
        LauncherTrustManager trustManager = Launcher.getConfig().trustManager;
        if (trustManager == null) {
            return;
        }
        X509Certificate[] certificates = LauncherEngine.getCertificates(clazz);
        if (certificates == null) {
            throw new SecurityException(String.format("Class %s not signed", clazz.getName()));
        }
        try {
            trustManager.checkCertificatesSuccess(certificates, trustManager::stdCertificateChecker);
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    public static void beforeExit(int code) {
        try {
            modulesManager.invokeEvent(new ClientExitPhase(code));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void forceExit(int code) {
        try {
            System.exit(code);
        }
        catch (Throwable e) {
            NativeJVMHalt.haltA(code);
        }
    }

    public static void exitLauncher(int code) {
        LauncherEngine.beforeExit(code);
        LauncherEngine.forceExit(code);
    }

    public static boolean contains(String[] array, String value) {
        for (String s : array) {
            if (!s.equals(value)) continue;
            return true;
        }
        return false;
    }

    public static void main(String ... args) throws Throwable {
        JVMHelper.checkStackTrace(LauncherEngineWrapper.class);
        JVMHelper.verifySystemProperties(Launcher.class, false);
        LauncherEngine.checkClass(LauncherEngine.class.getClassLoader().getClass());
        EnvHelper.checkDangerousParams();
        LauncherEngine.verifyNoAgent();
        if (LauncherEngine.contains(args, "--log-output") && Launcher.getConfig().environment != LauncherConfig.LauncherEnvironment.PROD) {
            LogHelper.addOutput(Paths.get("Launcher.log", new String[0]));
        }
        LogHelper.printVersion("Launcher");
        LogHelper.printLicense("Launcher");
        LauncherEngine.checkClass(LauncherEngineWrapper.class);
        LauncherEngine.checkClass(LauncherEngine.class);
        LauncherEngine.checkClass(ClientLauncherEntryPoint.class);
        modulesManager = new RuntimeModuleManager();
        modulesManager.loadModule(new RuntimeLauncherCoreModule());
        LauncherConfig.initModules(modulesManager);
        modulesManager.initModules(null);
        LauncherEngine.initGson(modulesManager);
        ConsoleManager.initConsole();
        modulesManager.invokeEvent(new PreConfigPhase());
        Launcher.getConfig();
        long startTime = System.currentTimeMillis();
        try {
            LauncherEngine.newInstance(false).start(args);
        }
        catch (Exception e) {
            LogHelper.error(e);
            return;
        }
        long endTime = System.currentTimeMillis();
        LogHelper.debug("Launcher started in %dms", endTime - startTime);
        LauncherEngine.exitLauncher(0);
    }

    public static void initGson(RuntimeModuleManager modulesManager) {
        AuthRequest.registerProviders();
        GetAvailabilityAuthRequest.registerProviders();
        OptionalAction.registerProviders();
        OptionalTrigger.registerProviders();
        Launcher.gsonManager = new RuntimeGsonManager(modulesManager);
        Launcher.gsonManager.initGson();
    }

    public static void verifyNoAgent() {
        if (JVMHelper.RUNTIME_MXBEAN.getInputArguments().stream().filter(e -> e != null && !e.isEmpty()).anyMatch(e -> e.contains("javaagent"))) {
            throw new SecurityException("JavaAgent found");
        }
    }

    public static RequestService initOffline() {
        OfflineRequestService service = new OfflineRequestService();
        ClientLauncherMethods.applyBasicOfflineProcessors(service);
        OfflineModeEvent event = new OfflineModeEvent(service);
        modulesManager.invokeEvent(event);
        return event.service;
    }

    public static LauncherEngine newInstance(boolean clientInstance) {
        return new LauncherEngine(clientInstance, NoRuntimeProvider.class);
    }

    public static LauncherEngine newInstance(boolean clientInstance, Class<? extends RuntimeProvider> basicRuntimeProvider) {
        return new LauncherEngine(clientInstance, basicRuntimeProvider);
    }

    public void start(String ... args) throws Throwable {
        LauncherConfig config = Launcher.getConfig();
        config.apply();
        ClientPreGuiPhase event = new ClientPreGuiPhase(null);
        modulesManager.invokeEvent(event);
        this.runtimeProvider = event.runtimeProvider;
        if (this.runtimeProvider == null) {
            this.runtimeProvider = this.basicRuntimeProvider.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        this.runtimeProvider.init(this.clientInstance);
        if (!Request.isAvailable()) {
            RequestService service;
            String address = config.address;
            LogHelper.debug("Start async connection to %s", address);
            try {
                service = StdWebSocketService.initWebSockets(address).get();
            }
            catch (Throwable e) {
                if (LogHelper.isDebugEnabled()) {
                    LogHelper.error(e);
                }
                LogHelper.warning("Launcher in offline mode");
                service = LauncherEngine.initOffline();
            }
            Request.setRequestService(service);
            if (service instanceof StdWebSocketService) {
                ((StdWebSocketService)service).reconnectCallback = () -> {
                    LogHelper.debug("WebSocket connect closed. Try reconnect");
                    try {
                        Request.reconnect();
                    }
                    catch (Exception e) {
                        LogHelper.error(e);
                        throw new RequestException("Connection failed", e);
                    }
                };
            }
        }
        Request.startAutoRefresh();
        Request.getRequestService().registerEventHandler(new BasicLauncherEventHandler());
        LauncherAPIHolder.setCoreAPI(new RequestCoreFeatureAPIImpl(Request.getRequestService()));
        LauncherAPIHolder.setCreateApiFactory(authId -> {
            RequestFeatureAPIImpl impl = new RequestFeatureAPIImpl(Request.getRequestService(), (String)authId);
            return new LauncherAPI(Map.of(AuthFeatureAPI.class, impl, UserFeatureAPI.class, impl, ProfileFeatureAPI.class, impl, TextureUploadFeatureAPI.class, impl, HardwareVerificationFeatureAPI.class, impl));
        });
        LauncherBackendAPIHolder.setApi(new LauncherBackendImpl());
        Objects.requireNonNull(args, "args");
        if (this.started.getAndSet(true)) {
            throw new IllegalStateException("Launcher has been already started");
        }
        this.registerCommands();
        modulesManager.invokeEvent(new ClientEngineInitPhase(this));
        this.runtimeProvider.preLoad();
        LogHelper.debug("Dir: %s", DirBridge.dir);
        this.runtimeProvider.run(args);
    }

    private void registerCommands() {
        ConsoleManager.handler.registerCommand("modules", new ModulesCommand());
    }
}

