/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.launch;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.module.Configuration;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReader;
import java.lang.module.ModuleReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import pro.gravit.utils.helper.HackHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.launch.ClassLoaderControl;
import pro.gravit.utils.launch.Launch;
import pro.gravit.utils.launch.LaunchOptions;
import pro.gravit.utils.launch.ModuleHacks;

public class ModuleLaunch
implements Launch {
    private ModuleClassLoader moduleClassLoader;
    private Configuration configuration;
    private ModuleLayer.Controller controller;
    private ModuleFinder moduleFinder;
    private ModuleLayer layer;
    private MethodHandles.Lookup hackLookup;
    private boolean disablePackageDelegateSupport;
    private static final MethodHandle ENABLE_NATIVE_ACCESS;

    @Override
    public ClassLoaderControl init(List<Path> files, String nativePath, LaunchOptions options) {
        this.disablePackageDelegateSupport = options.disablePackageDelegateSupport;
        this.moduleClassLoader = new ModuleClassLoader((URL[])files.stream().map(e -> {
            try {
                return e.toUri().toURL();
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
        }).toArray(URL[]::new), ClassLoader.getPlatformClassLoader());
        this.moduleClassLoader.nativePath = nativePath;
        if (options.enableHacks) {
            this.hackLookup = HackHelper.createHackLookup(ModuleLaunch.class);
        }
        if (options.moduleConf != null) {
            Module source;
            Module target;
            String pkg;
            String moduleName;
            String[] split;
            this.moduleFinder = ModuleFinder.of((Path[])options.moduleConf.modulePath.stream().map(x$0 -> Paths.get(x$0, new String[0])).map(Path::toAbsolutePath).toArray(Path[]::new));
            if (options.moduleConf.enableModularClassTransform) {
                AtomicReference<ModuleClassLoader> clRef = new AtomicReference<ModuleClassLoader>(this.moduleClassLoader);
                this.moduleFinder = new CustomModuleFinder(this.moduleFinder, clRef);
            }
            ModuleLayer bootLayer = ModuleLayer.boot();
            if (options.moduleConf.modules.contains("ALL-MODULE-PATH")) {
                Set<ModuleReference> set = this.moduleFinder.findAll();
                if (LogHelper.isDevEnabled()) {
                    for (ModuleReference m : set) {
                        LogHelper.dev("Found module %s in %s", m.descriptor().name(), m.location().map(URI::toString).orElse("unknown"));
                    }
                    LogHelper.dev("Found %d modules", set.size());
                }
                for (ModuleReference m : set) {
                    options.moduleConf.modules.add(m.descriptor().name());
                }
                options.moduleConf.modules.remove("ALL-MODULE-PATH");
            }
            this.configuration = bootLayer.configuration().resolveAndBind(this.moduleFinder, ModuleFinder.of(new Path[0]), options.moduleConf.modules);
            this.controller = ModuleLayer.defineModulesWithOneLoader(this.configuration, List.of(bootLayer), this.moduleClassLoader);
            this.layer = this.controller.layer();
            for (Map.Entry<String, String> entry : options.moduleConf.exports.entrySet()) {
                split = entry.getKey().split("/");
                moduleName = split[0];
                pkg = split[1];
                LogHelper.dev("Export module: %s package: %s to %s", moduleName, pkg, entry.getValue());
                Module source2 = this.layer.findModule(split[0]).orElse(null);
                if (source2 == null) {
                    throw new RuntimeException(String.format("Module %s not found", moduleName));
                }
                target = this.layer.findModule(entry.getValue()).orElse(null);
                if (target == null) {
                    throw new RuntimeException(String.format("Module %s not found", entry.getValue()));
                }
                if (options.enableHacks && source2.getLayer() != this.layer) {
                    ModuleHacks.createController(this.hackLookup, source2.getLayer()).addExports(source2, pkg, target);
                    continue;
                }
                this.controller.addExports(source2, pkg, target);
            }
            for (Map.Entry<String, String> entry : options.moduleConf.opens.entrySet()) {
                split = entry.getKey().split("/");
                moduleName = split[0];
                pkg = split[1];
                LogHelper.dev("Open module: %s package: %s to %s", moduleName, pkg, entry.getValue());
                Module source2 = this.layer.findModule(split[0]).orElse(null);
                if (source2 == null) {
                    throw new RuntimeException(String.format("Module %s not found", moduleName));
                }
                target = this.layer.findModule(entry.getValue()).orElse(null);
                if (target == null) {
                    throw new RuntimeException(String.format("Module %s not found", entry.getValue()));
                }
                if (options.enableHacks && source2.getLayer() != this.layer) {
                    ModuleHacks.createController(this.hackLookup, source2.getLayer()).addOpens(source2, pkg, target);
                    continue;
                }
                this.controller.addOpens(source2, pkg, target);
            }
            for (Map.Entry<String, String> entry : options.moduleConf.reads.entrySet()) {
                LogHelper.dev("Read module %s to %s", entry.getKey(), entry.getValue());
                source = this.layer.findModule(entry.getKey()).orElse(null);
                if (source == null) {
                    throw new RuntimeException(String.format("Module %s not found", entry.getKey()));
                }
                Module target2 = this.layer.findModule(entry.getValue()).orElse(null);
                if (target2 == null) {
                    throw new RuntimeException(String.format("Module %s not found", entry.getValue()));
                }
                if (options.enableHacks && source.getLayer() != this.layer) {
                    ModuleHacks.createController(this.hackLookup, source.getLayer()).addReads(source, target2);
                    continue;
                }
                this.controller.addReads(source, target2);
            }
            for (String string : options.moduleConf.enableNativeAccess) {
                LogHelper.dev("Enable Native Access %s", string);
                source = this.layer.findModule(string).orElse(null);
                if (source == null) {
                    throw new RuntimeException(String.format("Module %s not found", string));
                }
                if (ENABLE_NATIVE_ACCESS == null) continue;
                try {
                    ENABLE_NATIVE_ACCESS.invoke(this.controller, source);
                }
                catch (Throwable ex) {
                    throw new RuntimeException(ex);
                }
            }
            this.moduleClassLoader.initializeWithLayer(this.layer);
        }
        return this.moduleClassLoader.makeControl();
    }

    @Override
    public void launch(String mainClass, String mainModuleName, Collection<String> args) throws Throwable {
        Thread.currentThread().setContextClassLoader(this.moduleClassLoader);
        if (mainModuleName == null) {
            Class<?> mainClazz = Class.forName(mainClass, true, this.moduleClassLoader);
            MethodHandle mainMethod = MethodHandles.lookup().findStatic(mainClazz, "main", MethodType.methodType(Void.TYPE, String[].class)).asFixedArity();
            JVMHelper.fullGC();
            mainMethod.asFixedArity().invokeWithArguments(new Object[]{args.toArray(new String[0])});
            return;
        }
        Module mainModule = this.layer.findModule(mainModuleName).orElseThrow();
        Module unnamed = ModuleLaunch.class.getClassLoader().getUnnamedModule();
        if (unnamed != null) {
            this.controller.addOpens(mainModule, ModuleLaunch.getPackageFromClass(mainClass), unnamed);
        }
        ClassLoader loader = mainModule.getClassLoader();
        Class<?> mainClazz = Class.forName(mainClass, true, loader);
        MethodHandle mainMethod = MethodHandles.lookup().findStatic(mainClazz, "main", MethodType.methodType(Void.TYPE, String[].class));
        mainMethod.asFixedArity().invokeWithArguments(new Object[]{args.toArray(new String[0])});
    }

    private static String getPackageFromClass(String clazz) {
        int index = clazz.lastIndexOf(".");
        if (index >= 0) {
            return clazz.substring(0, index);
        }
        return clazz;
    }

    static {
        MethodHandle mh;
        try {
            mh = MethodHandles.lookup().findVirtual(ModuleLayer.Controller.class, "enableNativeAccess", MethodType.methodType(ModuleLayer.Controller.class, Module.class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            mh = null;
        }
        ENABLE_NATIVE_ACCESS = mh;
    }

    private class ModuleClassLoader
    extends URLClassLoader {
        private final ClassLoader SYSTEM_CLASS_LOADER;
        private final List<ClassLoaderControl.ClassTransformer> transformers;
        private final Map<String, Class<?>> classMap;
        private final Map<String, Module> packageToModule;
        private String nativePath;
        private final List<String> packages;

        public ModuleClassLoader(URL[] urls, ClassLoader parent) {
            super("LAUNCHER", urls, parent);
            this.SYSTEM_CLASS_LOADER = ClassLoader.getSystemClassLoader();
            this.transformers = new ArrayList<ClassLoaderControl.ClassTransformer>();
            this.classMap = new ConcurrentHashMap();
            this.packageToModule = new HashMap<String, Module>();
            this.packages = new ArrayList<String>();
            this.packages.add("pro.gravit.launcher.");
            this.packages.add("pro.gravit.utils.");
        }

        private void initializeWithLayer(ModuleLayer layer) {
            for (Module m : layer.modules()) {
                for (String p : m.getPackages()) {
                    this.packageToModule.put(p, m);
                }
            }
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (name != null && !ModuleLaunch.this.disablePackageDelegateSupport) {
                for (String pkg : this.packages) {
                    if (!name.startsWith(pkg)) continue;
                    return this.SYSTEM_CLASS_LOADER.loadClass(name);
                }
            }
            return super.loadClass(name, resolve);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            Class<?> clazz = this.findClass(null, name);
            if (clazz == null) {
                throw new ClassNotFoundException(name);
            }
            return clazz;
        }

        @Override
        protected Class<?> findClass(String moduleName, String name) {
            String pkg;
            Module module;
            Class<?> clazz = this.classMap.get(name);
            if (clazz != null) {
                return clazz;
            }
            if (name != null && !this.transformers.isEmpty()) {
                boolean needTransform = false;
                for (ClassLoaderControl.ClassTransformer t : this.transformers) {
                    if (!t.filter(moduleName, name)) continue;
                    needTransform = true;
                    break;
                }
                if (needTransform) {
                    String rawClassName = name.replace(".", "/").concat(".class");
                    try (InputStream input = this.getResourceAsStream(rawClassName);){
                        byte[] bytes = IOHelper.read(input);
                        bytes = this.transformClass(moduleName, name, bytes);
                        clazz = this.defineClass(name, bytes, 0, bytes.length);
                    }
                    catch (IOException e) {
                        return null;
                    }
                }
            }
            if (clazz == null && ModuleLaunch.this.layer != null && name != null && (module = this.packageToModule.get(pkg = ModuleLaunch.getPackageFromClass(name))) != null) {
                try {
                    clazz = module.getClassLoader().loadClass(name);
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }
            if (clazz == null) {
                try {
                    clazz = super.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }
            if (clazz != null) {
                this.classMap.put(name, clazz);
                return clazz;
            }
            return null;
        }

        private byte[] transformClass(String moduleName, String name, byte[] bytes) {
            for (ClassLoaderControl.ClassTransformer t : this.transformers) {
                if (!t.filter(moduleName, name)) continue;
                bytes = t.transform(moduleName, name, null, bytes);
            }
            return bytes;
        }

        @Override
        public String findLibrary(String name) {
            if (this.nativePath == null) {
                return null;
            }
            return this.nativePath.concat(IOHelper.PLATFORM_SEPARATOR).concat(JVMHelper.NATIVE_PREFIX).concat(name).concat(JVMHelper.NATIVE_EXTENSION);
        }

        public void addAllowedPackage(String pkg) {
            this.packages.add(pkg);
        }

        public void clearAllowedPackages() {
            this.packages.clear();
        }

        private ModuleClassLoaderControl makeControl() {
            return new ModuleClassLoaderControl();
        }

        static {
            ClassLoader.registerAsParallelCapable();
        }

        private class ModuleClassLoaderControl
        implements ClassLoaderControl {
            private ModuleClassLoaderControl() {
            }

            @Override
            public void addLauncherPackage(String prefix) {
                ModuleClassLoader.this.addAllowedPackage(prefix);
            }

            @Override
            public void clearLauncherPackages() {
                ModuleClassLoader.this.clearAllowedPackages();
            }

            @Override
            public void addTransformer(ClassLoaderControl.ClassTransformer transformer) {
                ModuleClassLoader.this.transformers.add(transformer);
            }

            @Override
            public void addURL(URL url) {
                ModuleClassLoader.this.addURL(url);
            }

            @Override
            public void addJar(Path path) {
                try {
                    ModuleClassLoader.this.addURL(path.toUri().toURL());
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public URL[] getURLs() {
                return ModuleClassLoader.this.getURLs();
            }

            @Override
            public Class<?> getClass(String name) throws ClassNotFoundException {
                return Class.forName(name, false, ModuleClassLoader.this);
            }

            @Override
            public ClassLoader getClassLoader() {
                return ModuleClassLoader.this;
            }

            @Override
            public Object getJava9ModuleController() {
                return ModuleLaunch.this.controller;
            }

            @Override
            public MethodHandles.Lookup getHackLookup() {
                return ModuleLaunch.this.hackLookup;
            }
        }
    }

    private class CustomModuleFinder
    implements ModuleFinder {
        private final ModuleFinder delegate;
        private final AtomicReference<ModuleClassLoader> cl;

        public CustomModuleFinder(ModuleFinder delegate, AtomicReference<ModuleClassLoader> cl) {
            this.delegate = delegate;
            this.cl = cl;
        }

        @Override
        public Optional<ModuleReference> find(String name) {
            return this.delegate.find(name).map(this::makeModuleReference);
        }

        @Override
        public Set<ModuleReference> findAll() {
            return this.delegate.findAll().stream().map(this::makeModuleReference).collect(Collectors.toSet());
        }

        private CustomModuleReference makeModuleReference(ModuleReference x) {
            return new CustomModuleReference(x.descriptor(), x.location().orElse(null), x, this.cl);
        }
    }

    private class CustomModuleReader
    implements ModuleReader {
        private final ModuleReader delegate;
        private final AtomicReference<ModuleClassLoader> cl;
        private final ModuleDescriptor descriptor;

        public CustomModuleReader(ModuleLaunch moduleLaunch, ModuleReader delegate, AtomicReference<ModuleClassLoader> cl, ModuleDescriptor descriptor) {
            this.delegate = delegate;
            this.cl = cl;
            this.descriptor = descriptor;
        }

        @Override
        public Optional<URI> find(String name) throws IOException {
            return this.delegate.find(name);
        }

        @Override
        public Optional<InputStream> open(String name) throws IOException {
            ModuleClassLoader classLoader = this.cl.get();
            if (classLoader == null || !name.endsWith(".class")) {
                return this.delegate.open(name);
            }
            Optional<InputStream> inputOptional = this.delegate.open(name);
            if (inputOptional.isEmpty()) {
                return inputOptional;
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                inputOptional.get().transferTo(output);
                String realClassName = name.replace("/", ".").substring(0, name.length() - ".class".length() - 1);
                byte[] bytes = classLoader.transformClass(this.descriptor.name(), realClassName, output.toByteArray());
                Optional<InputStream> optional = Optional.of(new ByteArrayInputStream(bytes));
                return optional;
            }
        }

        @Override
        public Optional<ByteBuffer> read(String name) throws IOException {
            return this.delegate.read(name);
        }

        @Override
        public void release(ByteBuffer bb) {
            this.delegate.release(bb);
        }

        @Override
        public Stream<String> list() throws IOException {
            return this.delegate.list();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }
    }

    private class CustomModuleReference
    extends ModuleReference {
        private final ModuleReference delegate;
        private final AtomicReference<ModuleClassLoader> cl;

        public CustomModuleReference(ModuleDescriptor descriptor, URI location, ModuleReference delegate, AtomicReference<ModuleClassLoader> cl) {
            super(descriptor, location);
            this.delegate = delegate;
            this.cl = cl;
        }

        @Override
        public ModuleReader open() throws IOException {
            return new CustomModuleReader(ModuleLaunch.this, this.delegate.open(), this.cl, this.descriptor());
        }
    }
}

