/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.runtime.backend;

import java.io.IOException;
import java.nio.file.Path;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.InvalidKeySpecException;
import pro.gravit.launcher.runtime.client.DirBridge;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;

public class ECKeyHolder {
    public ECPublicKey publicKey;
    public ECPrivateKey privateKey;

    public ECPublicKey getClientPublicKey() {
        return this.publicKey;
    }

    public byte[] sign(byte[] bytes) {
        return SecurityHelper.sign((byte[])bytes, (ECPrivateKey)this.privateKey);
    }

    public void readKeys() throws IOException, InvalidKeySpecException {
        if (this.privateKey != null || this.publicKey != null) {
            return;
        }
        Path dir = DirBridge.dir;
        Path publicKeyFile = dir.resolve("public.key");
        Path privateKeyFile = dir.resolve("private.key");
        if (IOHelper.isFile((Path)publicKeyFile) && IOHelper.isFile((Path)privateKeyFile)) {
            LogHelper.info((String)"Reading EC keypair");
            this.publicKey = SecurityHelper.toPublicECDSAKey((byte[])IOHelper.read((Path)publicKeyFile));
            this.privateKey = SecurityHelper.toPrivateECDSAKey((byte[])IOHelper.read((Path)privateKeyFile));
        } else {
            LogHelper.info((String)"Generating EC keypair");
            KeyPair pair = SecurityHelper.genECDSAKeyPair((SecureRandom)new SecureRandom());
            this.publicKey = (ECPublicKey)pair.getPublic();
            this.privateKey = (ECPrivateKey)pair.getPrivate();
            LogHelper.info((String)"Writing EC keypair list");
            IOHelper.write((Path)publicKeyFile, (byte[])this.publicKey.getEncoded());
            IOHelper.write((Path)privateKeyFile, (byte[])this.privateKey.getEncoded());
        }
    }
}

