/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.core.openid;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class QueryBuilder {
    private final String uri;
    private final StringBuilder query = new StringBuilder();

    public QueryBuilder(String uri) {
        this.uri = uri;
    }

    public static QueryBuilder get(String uri) {
        Objects.requireNonNull(uri, "uri");
        if (uri.endsWith("/")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        return new QueryBuilder(uri);
    }

    public static QueryBuilder post() {
        return new QueryBuilder(null);
    }

    public QueryBuilder addQuery(String key, String value) {
        if (!this.query.isEmpty()) {
            this.query.append('&');
        }
        this.query.append(URLEncoder.encode(key, StandardCharsets.UTF_8)).append('=').append(URLEncoder.encode(value, StandardCharsets.UTF_8));
        return this;
    }

    public String toUriString() {
        if (this.uri != null) {
            if (this.query.isEmpty()) {
                return this.uri;
            }
            return this.uri + "?" + String.valueOf(this.query);
        }
        return this.toQueryString();
    }

    public String toQueryString() {
        return this.query.toString();
    }

    public String toString() {
        return this.toUriString();
    }
}

