/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.texture;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.base.profiles.Texture;
import pro.gravit.launchserver.auth.texture.TextureProvider;
import pro.gravit.utils.helper.CommonHelper;
import pro.gravit.utils.helper.IOHelper;

public final class RequestTextureProvider
extends TextureProvider {
    public String skinURL;
    public String cloakURL;
    public String skinLocalPath;
    public String cloakLocalPath;

    public RequestTextureProvider() {
    }

    public RequestTextureProvider(String skinURL, String cloakURL) {
        this.skinURL = skinURL;
        this.cloakURL = cloakURL;
    }

    private static Texture getTexture(String url, boolean cloak) throws IOException {
        try {
            return new Texture(url, cloak, null);
        }
        catch (FileNotFoundException ignored) {
            return null;
        }
    }

    private static Texture getTexture(String url, Path local, boolean cloak) throws IOException {
        try {
            return new Texture(url, local, cloak, null);
        }
        catch (FileNotFoundException ignored) {
            return null;
        }
    }

    public static String getTextureURL(String url, UUID uuid, String username, String client) {
        return CommonHelper.replace((String)url, (String[])new String[]{"username", IOHelper.urlEncode((String)username), "uuid", IOHelper.urlEncode((String)uuid.toString()), "hash", IOHelper.urlEncode((String)Launcher.toHash((UUID)uuid)), "client", IOHelper.urlEncode((String)(client == null ? "unknown" : client))});
    }

    @Override
    public void close() {
    }

    @Override
    public Texture getCloakTexture(UUID uuid, String username, String client) throws IOException {
        String textureUrl = RequestTextureProvider.getTextureURL(this.cloakURL, uuid, username, client);
        if (this.cloakLocalPath == null) {
            return RequestTextureProvider.getTexture(textureUrl, true);
        }
        String path = RequestTextureProvider.getTextureURL(this.cloakLocalPath, uuid, username, client);
        return RequestTextureProvider.getTexture(textureUrl, Paths.get(path, new String[0]), true);
    }

    @Override
    public Texture getSkinTexture(UUID uuid, String username, String client) throws IOException {
        String textureUrl = RequestTextureProvider.getTextureURL(this.skinURL, uuid, username, client);
        if (this.skinLocalPath == null) {
            return RequestTextureProvider.getTexture(textureUrl, false);
        }
        String path = RequestTextureProvider.getTextureURL(this.skinLocalPath, uuid, username, client);
        return RequestTextureProvider.getTexture(textureUrl, Paths.get(path, new String[0]), false);
    }
}

