/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.binary.tasks;

import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.core.api.features.CoreFeatureAPI;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.binary.JARLauncherBinary;
import pro.gravit.launchserver.binary.PipelineContext;
import pro.gravit.launchserver.binary.tasks.LauncherBuildTask;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.UnpackHelper;

public class PrepareBuildTask
implements LauncherBuildTask {
    private final LaunchServer server;
    private final Path result;
    private final JARLauncherBinary launcherBinary;
    private final transient Logger logger = LogManager.getLogger();

    public PrepareBuildTask(LaunchServer server) {
        this.server = server;
        this.launcherBinary = (JARLauncherBinary)server.launcherBinaries.get(CoreFeatureAPI.UpdateVariant.JAR);
        this.result = this.launcherBinary.buildDir.resolve("Launcher-clean.jar");
    }

    @Override
    public String getName() {
        return "UnpackFromResources";
    }

    @Override
    public Path process(PipelineContext context) throws IOException {
        this.launcherBinary.coreLibs.clear();
        this.launcherBinary.addonLibs.clear();
        this.launcherBinary.files.clear();
        IOHelper.walk((Path)this.server.launcherLibraries, (FileVisitor)new ListFileVisitor(this.launcherBinary.coreLibs), (boolean)false);
        if (Files.isDirectory(this.server.launcherLibrariesCompile, new LinkOption[0])) {
            IOHelper.walk((Path)this.server.launcherLibrariesCompile, (FileVisitor)new ListFileVisitor(this.launcherBinary.addonLibs), (boolean)false);
        }
        try (Stream<Path> stream = Files.walk(this.server.launcherPack, FileVisitOption.FOLLOW_LINKS).filter(e -> {
            try {
                return !Files.isDirectory(e, new LinkOption[0]) && !Files.isHidden(e);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        });){
            Map<String, Path> map = stream.collect(Collectors.toMap(k -> this.server.launcherPack.relativize((Path)k).toString().replace("\\", "/"), v -> v));
            this.launcherBinary.files.putAll(map);
        }
        UnpackHelper.unpack((URL)PrepareBuildTask.class.getResource("/Launcher.jar"), (Path)this.result);
        if (!Files.exists(this.launcherBinary.runtimeDir, new LinkOption[0])) {
            Files.createDirectories(this.launcherBinary.runtimeDir, new FileAttribute[0]);
        }
        return this.result;
    }

    private static final class ListFileVisitor
    extends SimpleFileVisitor<Path> {
        private final List<Path> lst;

        private ListFileVisitor(List<Path> lst) {
            this.lst = lst;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (!Files.isDirectory(file, new LinkOption[0]) && file.toFile().getName().endsWith(".jar")) {
                this.lst.add(file);
            }
            return super.visitFile(file, attrs);
        }
    }
}

