/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.service;

import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import java.security.PublicKey;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.AuthProviderPair;
import pro.gravit.launchserver.auth.profiles.ProfilesProvider;
import pro.gravit.launchserver.command.Command;
import pro.gravit.utils.command.SubCommand;

public class TokenCommand
extends Command {
    private final transient Logger logger = LogManager.getLogger();

    public TokenCommand(final LaunchServer server) {
        super(server);
        this.childCommands.put("info", new SubCommand("[token]", "print token info"){

            public void invoke(String ... args) throws Exception {
                this.verifyArgs(args, 1);
                JwtParser parser = Jwts.parser().verifyWith((PublicKey)server.keyAgreementManager.ecdsaPublicKey).build();
                Jws claims = parser.parseSignedClaims((CharSequence)args[0]);
                TokenCommand.this.logger.info("Token: {}", claims.getPayload());
            }
        });
        this.childCommands.put("server", new SubCommand("[profileName] (authId) (public only)", "generate new server token"){

            public void invoke(String ... args) {
                AuthProviderPair pair = args.length > 1 ? server.config.getAuthProviderPair(args[1]) : server.config.getAuthProviderPair();
                boolean publicOnly = args.length <= 2 || Boolean.parseBoolean(args[2]);
                ProfilesProvider.UncompletedProfile profile = null;
                for (ProfilesProvider.UncompletedProfile p : server.config.profilesProvider.getProfiles(null)) {
                    if (!p.getName().equals(args[0]) && !p.getUuid().toString().equals(args[0])) continue;
                    profile = p;
                    break;
                }
                if (profile == null) {
                    TokenCommand.this.logger.warn("Profile {} not found", (Object)args[0]);
                }
                if (pair == null) {
                    TokenCommand.this.logger.error("AuthId {} not found", (Object)args[1]);
                    return;
                }
                String token = server.authManager.newCheckServerToken(profile != null ? profile.getUuid().toString() : args[0], pair.name, publicOnly);
                TokenCommand.this.logger.info("Server token {} authId {}: {}", (Object)args[0], (Object)pair.name, (Object)token);
            }
        });
    }

    public String getArgsDescription() {
        return "[server/info/token name] [args]";
    }

    public String getUsageDescription() {
        return "jwt management";
    }

    public void invoke(String ... args) throws Exception {
        this.invokeSubcommands(args);
    }
}

