/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket.response.update;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.netty.channel.ChannelHandlerContext;
import java.security.Key;
import java.security.PublicKey;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Base64;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.base.events.RequestEvent;
import pro.gravit.launcher.base.events.request.LauncherRequestEvent;
import pro.gravit.launcher.core.api.features.CoreFeatureAPI;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.AuthProviderPair;
import pro.gravit.launchserver.auth.updates.UpdatesProvider;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.response.SimpleResponse;
import pro.gravit.launchserver.socket.response.WebSocketServerResponse;
import pro.gravit.launchserver.socket.response.auth.AuthResponse;
import pro.gravit.launchserver.socket.response.auth.RestoreResponse;
import pro.gravit.utils.Version;

public class LauncherResponse
extends SimpleResponse {
    public Version version;
    public String hash;
    public byte[] digest;
    public int launcher_type;
    public CoreFeatureAPI.UpdateVariant variant;
    public String secureHash;
    public String secureSalt;

    @Override
    public String getType() {
        return "launcher";
    }

    @Override
    public void execute(ChannelHandlerContext ctx, Client client) {
        byte[] hashToCheck;
        UpdatesProvider.UpdateInfo info;
        byte[] bytes = this.hash != null ? Base64.getDecoder().decode(this.hash) : this.digest;
        CoreFeatureAPI.UpdateVariant variant = CoreFeatureAPI.UpdateVariant.JAR;
        if (this.launcher_type == 2) {
            variant = CoreFeatureAPI.UpdateVariant.EXE_WINDOWS_X86_64;
        }
        if (this.variant != null) {
            variant = this.variant;
        }
        if ((info = this.server.config.updatesProvider.checkUpdates(variant, new UpdatesProvider.BuildSecretsCheck(this.secureHash, this.secureSalt, hashToCheck = bytes))) != null) {
            this.sendResult((RequestEvent)new LauncherRequestEvent(true, info.url()));
        } else {
            client.checkSign = true;
            this.sendResult((RequestEvent)new LauncherRequestEvent(false, null, this.createLauncherExtendedToken(), this.server.config.netty.security.launcherTokenExpire * 1000L));
        }
    }

    public String createLauncherExtendedToken() {
        return ((JwtBuilder)((JwtBuilder)Jwts.builder().setIssuer("LaunchServer")).claim("checkSign", (Object)true).setExpiration(Date.from(LocalDateTime.now().plusSeconds(this.server.config.netty.security.launcherTokenExpire).toInstant(ZoneOffset.UTC)))).signWith((Key)this.server.keyAgreementManager.ecdsaPrivateKey, SignatureAlgorithm.ES256).compact();
    }

    @Override
    public WebSocketServerResponse.ThreadSafeStatus getThreadSafeStatus() {
        return WebSocketServerResponse.ThreadSafeStatus.READ_WRITE;
    }

    public static class LauncherTokenVerifier
    implements RestoreResponse.ExtendedTokenProvider {
        private final JwtParser parser;
        private final Logger logger = LogManager.getLogger();

        public LauncherTokenVerifier(LaunchServer server) {
            this.parser = Jwts.parser().verifyWith((PublicKey)server.keyAgreementManager.ecdsaPublicKey).requireIssuer("LaunchServer").build();
        }

        @Override
        public boolean accept(Client client, AuthProviderPair pair, String extendedToken) {
            try {
                Jws jwt = this.parser.parseClaimsJws((CharSequence)extendedToken);
                client.checkSign = (Boolean)((Claims)jwt.getBody()).get("checkSign", Boolean.class);
                client.type = AuthResponse.ConnectTypes.CLIENT;
                return true;
            }
            catch (Exception e) {
                this.logger.error("JWT check failed", (Throwable)e);
                return false;
            }
        }
    }
}

