/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Path;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.base.modules.LauncherModule;
import pro.gravit.launcher.base.modules.events.PreConfigPhase;
import pro.gravit.launcher.base.profiles.optional.actions.OptionalAction;
import pro.gravit.launcher.base.profiles.optional.triggers.OptionalTrigger;
import pro.gravit.launcher.base.request.auth.AuthRequest;
import pro.gravit.launcher.base.request.auth.GetAvailabilityAuthRequest;
import pro.gravit.launcher.core.LauncherTrustManager;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.LaunchServerBuilder;
import pro.gravit.launchserver.auth.core.AuthCoreProvider;
import pro.gravit.launchserver.auth.mix.MixProvider;
import pro.gravit.launchserver.auth.password.PasswordVerifier;
import pro.gravit.launchserver.auth.profiles.ProfilesProvider;
import pro.gravit.launchserver.auth.protect.ProtectHandler;
import pro.gravit.launchserver.auth.texture.TextureProvider;
import pro.gravit.launchserver.auth.updates.UpdatesProvider;
import pro.gravit.launchserver.components.Component;
import pro.gravit.launchserver.config.LaunchServerConfig;
import pro.gravit.launchserver.manangers.CertificateManager;
import pro.gravit.launchserver.manangers.LaunchServerGsonManager;
import pro.gravit.launchserver.modules.impl.LaunchServerModulesManager;
import pro.gravit.launchserver.socket.WebSocketService;
import pro.gravit.utils.command.CommandHandler;
import pro.gravit.utils.command.JLineCommandHandler;
import pro.gravit.utils.command.StdCommandHandler;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;

public class LaunchServerStarter {
    public static final boolean allowUnsigned = Boolean.getBoolean("launchserver.allowUnsigned");
    public static final boolean prepareMode = Boolean.getBoolean("launchserver.prepareMode");
    private static final Logger logger = LogManager.getLogger();

    public static void main(String[] args) throws Exception {
        LaunchServerConfig config;
        JLineCommandHandler localCommandHandler;
        JVMHelper.verifySystemProperties(LaunchServer.class, (boolean)false);
        LogHelper.printVersion((String)"LaunchServer");
        LogHelper.printLicense((String)"LaunchServer");
        Path dir = IOHelper.WORKING_DIR;
        try {
            Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider");
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        catch (ClassNotFoundException | NoClassDefFoundError ex) {
            LogHelper.error((String)"Library BouncyCastle not found! Is directory 'libraries' empty?");
            return;
        }
        LaunchServer.LaunchServerDirectories directories = new LaunchServer.LaunchServerDirectories();
        directories.dir = dir;
        directories.collect();
        CertificateManager certificateManager = new CertificateManager();
        try {
            certificateManager.readTrustStore(directories.trustStore);
        }
        catch (CertificateException e) {
            throw new IOException(e);
        }
        LauncherTrustManager.CheckClassResult result = certificateManager.checkClass(LaunchServer.class);
        if (result.type == LauncherTrustManager.CheckClassResultType.SUCCESS) {
            logger.info("LaunchServer signed by {}", (Object)result.endCertificate.getSubjectX500Principal().getName());
        } else if (result.type != LauncherTrustManager.CheckClassResultType.NOT_SIGNED) {
            if (result.exception != null) {
                logger.error((Object)result.exception);
            }
            logger.warn("LaunchServer signed incorrectly. Status: {}", (Object)result.type.name());
        }
        LaunchServer.LaunchServerEnv env = LaunchServer.LaunchServerEnv.PRODUCTION;
        LaunchServerModulesManager modulesManager = new LaunchServerModulesManager(directories.modules, dir.resolve("config"), certificateManager.trustManager);
        modulesManager.autoload();
        modulesManager.initModules(null);
        LaunchServerStarter.registerAll();
        LaunchServerStarter.initGson(modulesManager);
        LaunchServerStarter.printExperimentalBranch();
        Path configFile = IOHelper.exists((Path)dir.resolve("LaunchServer.conf")) ? dir.resolve("LaunchServer.conf") : dir.resolve("LaunchServer.json");
        try {
            Class.forName("org.jline.terminal.Terminal");
            localCommandHandler = new JLineCommandHandler();
            logger.info("JLine2 terminal enabled");
        }
        catch (ClassNotFoundException ignored) {
            localCommandHandler = new StdCommandHandler(true);
            logger.warn("JLine2 isn't in classpath, using std");
        }
        modulesManager.invokeEvent((LauncherModule.Event)new PreConfigPhase());
        LaunchServerStarter.generateConfigIfNotExists(configFile, (CommandHandler)localCommandHandler, env);
        logger.info("Reading LaunchServer config file");
        try (BufferedReader reader = IOHelper.newReader((Path)configFile);){
            config = (LaunchServerConfig)Launcher.gsonManager.gson.fromJson((Reader)reader, LaunchServerConfig.class);
        }
        BasicLaunchServerConfigManager launchServerConfigManager = new BasicLaunchServerConfigManager(configFile);
        LaunchServer server = new LaunchServerBuilder().setDirectories(directories).setEnv(env).setCommandHandler((CommandHandler)localCommandHandler).setConfig(config).setModulesManager(modulesManager).setLaunchServerConfigManager(launchServerConfigManager).setCertificateManager(certificateManager).build();
        List<String> allArgs = List.of(args);
        boolean isPrepareMode = prepareMode || allArgs.contains("--prepare");
        boolean isRunCommand = false;
        ArrayList<String> runCommand = new ArrayList<String>();
        for (String e : allArgs) {
            if (e.equals("--run")) {
                isRunCommand = true;
                continue;
            }
            if (!isRunCommand) continue;
            runCommand.add(e);
            isRunCommand = false;
        }
        for (String cmd : runCommand) {
            localCommandHandler.eval(cmd, false);
        }
        if (!isPrepareMode) {
            server.run();
        } else {
            server.close();
        }
    }

    public static void initGson(LaunchServerModulesManager modulesManager) {
        Launcher.gsonManager = new LaunchServerGsonManager(modulesManager);
        Launcher.gsonManager.initGson();
    }

    public static void registerAll() {
        AuthCoreProvider.registerProviders();
        PasswordVerifier.registerProviders();
        TextureProvider.registerProviders();
        Component.registerComponents();
        ProtectHandler.registerHandlers();
        WebSocketService.registerResponses();
        AuthRequest.registerProviders();
        GetAvailabilityAuthRequest.registerProviders();
        OptionalAction.registerProviders();
        OptionalTrigger.registerProviders();
        MixProvider.registerProviders();
        ProfilesProvider.registerProviders();
        UpdatesProvider.registerProviders();
    }

    private static void printExperimentalBranch() {
        try (BufferedReader reader = IOHelper.newReader((URL)IOHelper.getResourceURL((String)"experimental-build.json"));){
            ExperimentalBuild info = (ExperimentalBuild)Launcher.gsonManager.configGson.fromJson((Reader)reader, ExperimentalBuild.class);
            if (info.features == null || info.features.isEmpty()) {
                return;
            }
            logger.warn("This is experimental build. Please do not use this in production");
            logger.warn("Experimental features: [{}]", (Object)String.join((CharSequence)",", info.features));
            for (String e : info.info) {
                logger.warn(e);
            }
        }
        catch (Throwable e) {
            logger.warn("Build information not found");
        }
    }

    public static void generateConfigIfNotExists(Path configFile, CommandHandler commandHandler, LaunchServer.LaunchServerEnv env) throws IOException {
        int port;
        boolean usingHttps;
        String address;
        if (IOHelper.isFile((Path)configFile)) {
            return;
        }
        logger.info("Creating LaunchServer config");
        LaunchServerConfig newConfig = LaunchServerConfig.getDefault(env);
        if (env.equals((Object)LaunchServer.LaunchServerEnv.TEST)) {
            address = "localhost";
            newConfig.setProjectName("test");
        } else {
            String projectName;
            address = System.getenv("ADDRESS");
            if (address == null) {
                address = System.getProperty("launchserver.address", null);
            }
            if (address == null) {
                System.out.println("External launchServer address:port (default: localhost:9274): ");
                address = commandHandler.readLine();
            }
            if ((projectName = System.getenv("PROJECTNAME")) == null) {
                projectName = System.getProperty("launchserver.projectname", null);
            }
            if (projectName == null) {
                System.out.println("LaunchServer projectName: ");
                projectName = commandHandler.readLine();
            }
            newConfig.setProjectName(projectName);
        }
        if (address == null || address.isEmpty()) {
            logger.error("Address null. Using localhost:9274");
            address = "localhost:9274";
        }
        if (newConfig.projectName == null || newConfig.projectName.isEmpty()) {
            logger.error("ProjectName null. Using MineCraft");
            newConfig.projectName = "MineCraft";
        }
        if (address.startsWith("ws://")) {
            address = address.substring("ws://".length());
            usingHttps = false;
        } else if (address.startsWith("wss://")) {
            address = address.substring("wss://".length());
            usingHttps = true;
        } else if (address.startsWith("http://")) {
            address = address.substring("http://".length());
            usingHttps = false;
        } else if (address.startsWith("https://")) {
            address = address.substring("https://".length());
            usingHttps = true;
        } else {
            usingHttps = false;
        }
        String portString = System.getenv("LISTEN_PORT");
        if (portString == null) {
            portString = System.getProperty("launchserver.listenport", null);
        }
        if (portString != null) {
            port = Integer.parseInt(portString);
        } else if (address.contains(":")) {
            portString = address.substring(address.indexOf(58) + 1);
            try {
                port = Integer.parseInt(portString);
            }
            catch (NumberFormatException e) {
                port = 9274;
                logger.warn("Unknown port {}, using 9274", (Object)portString);
            }
        } else {
            port = 9274;
            logger.info("Address {} doesn't contains port (you want to use nginx?)", (Object)address);
        }
        newConfig.netty.address = (usingHttps ? "wss://" : "ws://") + address + "/api";
        newConfig.netty.downloadURL = (usingHttps ? "https://" : "http://") + address + "/%dirname%/";
        newConfig.netty.launcherURL = (usingHttps ? "https://" : "http://") + address + "/Launcher.jar";
        newConfig.netty.launcherEXEURL = (usingHttps ? "https://" : "http://") + address + "/Launcher.exe";
        newConfig.netty.binds[0].port = port;
        logger.info("Writing LaunchServer config file");
        try (BufferedWriter writer = IOHelper.newWriter((Path)configFile);){
            Launcher.gsonManager.configGson.toJson((Object)newConfig, (Appendable)writer);
        }
    }

    private static class BasicLaunchServerConfigManager
    implements LaunchServer.LaunchServerConfigManager {
        private final Path configFile;

        public BasicLaunchServerConfigManager(Path configFile) {
            this.configFile = configFile;
        }

        @Override
        public LaunchServerConfig readConfig() throws IOException {
            LaunchServerConfig config1;
            try (BufferedReader reader = IOHelper.newReader((Path)this.configFile);){
                config1 = (LaunchServerConfig)Launcher.gsonManager.gson.fromJson((Reader)reader, LaunchServerConfig.class);
            }
            return config1;
        }

        @Override
        public void writeConfig(LaunchServerConfig config) throws IOException {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            try (BufferedWriter writer = IOHelper.newWriter((OutputStream)output);){
                if (Launcher.gsonManager.configGson != null) {
                    Launcher.gsonManager.configGson.toJson((Object)config, (Appendable)writer);
                } else {
                    logger.error("Error writing LaunchServer config file. Gson is null");
                }
            }
            byte[] bytes = output.toByteArray();
            if (bytes.length > 0) {
                IOHelper.write((Path)this.configFile, (byte[])bytes);
            }
        }
    }

    record ExperimentalBuild(List<String> features, List<String> info) {
    }
}

