/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.core.openid;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.UUID;
import pro.gravit.launchserver.auth.HikariSQLSourceConfig;
import pro.gravit.launchserver.auth.core.User;
import pro.gravit.launchserver.auth.core.openid.UserStore;
import pro.gravit.utils.helper.LogHelper;

public class SQLUserStore
implements UserStore {
    private static final String CREATE_USER_TABLE = "create table if not exists `gravit_user` (\n  id int auto_increment,\n  uuid varchar(36),\n  username varchar(255),\n  primary key (id),\n  unique (uuid),\n  unique (username)\n)\n";
    private static final String INSERT_USER = "insert into `gravit_user` (uuid, username) values (?, ?)\n";
    private static final String DELETE_USER_BY_NAME = "delete `gravit_user` where username = ?\n";
    private static final String SELECT_USER_BY_NAME = "select uuid, username from `gravit_user` where username = ?\n";
    private static final String SELECT_USER_BY_UUID = "select uuid, username from `gravit_user` where uuid = ?\n";
    private final HikariSQLSourceConfig sqlSourceConfig;

    public SQLUserStore(HikariSQLSourceConfig sqlSourceConfig) {
        this.sqlSourceConfig = sqlSourceConfig;
    }

    /*
     * Exception decompiling
     */
    @Override
    public User getByUsername(String username) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public User getUserByUUID(UUID uuid) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void createOrUpdateUser(User user) {
        try (Connection connection = this.sqlSourceConfig.getConnection();){
            connection.setAutoCommit(false);
            Savepoint savepoint = connection.setSavepoint();
            try (PreparedStatement deleteUserStmt = connection.prepareStatement(DELETE_USER_BY_NAME);
                 PreparedStatement insertUserStmt = connection.prepareStatement(INSERT_USER);){
                deleteUserStmt.setString(1, user.getUsername());
                deleteUserStmt.execute();
                insertUserStmt.setString(1, user.getUUID().toString());
                insertUserStmt.setString(2, user.getUsername());
                insertUserStmt.execute();
                connection.commit();
                LogHelper.debug((String)"User saved. UUID: %s, username: %s".formatted(user.getUUID(), user.getUsername()));
            }
            catch (Exception e) {
                connection.rollback(savepoint);
                throw e;
            }
        }
        catch (SQLException e) {
            LogHelper.debug((String)"Failed to save user");
            LogHelper.error((Throwable)e);
            throw new RuntimeException("Failed to save user", e);
        }
    }

    public void init() {
        try (Connection connection = this.sqlSourceConfig.getConnection();){
            connection.setAutoCommit(false);
            Savepoint savepoint = connection.setSavepoint();
            try (PreparedStatement createUserTableStmt = connection.prepareStatement(CREATE_USER_TABLE);){
                createUserTableStmt.execute();
                connection.commit();
            }
            catch (Exception e) {
                connection.rollback(savepoint);
                throw e;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

