/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.profiles;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launcher.base.profiles.ClientProfileBuilder;
import pro.gravit.launcher.core.hasher.HashedDir;
import pro.gravit.launcher.core.serialize.HInput;
import pro.gravit.launcher.core.serialize.HOutput;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.Reconfigurable;
import pro.gravit.launchserver.auth.profiles.ProfilesProvider;
import pro.gravit.launchserver.modules.events.LaunchServerUpdatesSyncEvent;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.utils.command.Command;
import pro.gravit.utils.command.SubCommand;
import pro.gravit.utils.helper.IOHelper;

public class LocalProfilesProvider
extends ProfilesProvider
implements Reconfigurable {
    private final transient Logger logger = LogManager.getLogger();
    public String profilesDir = "profiles";
    public String cacheFile = ".updates-cache";
    public String updatesDir = "updates";
    public boolean cacheUpdates = true;
    private volatile transient Map<String, HashedDir> updatesDirMap;
    private volatile transient Map<UUID, LocalProfile> profilesMap;

    @Override
    public ProfilesProvider.UncompletedProfile create(String name, String description, ProfilesProvider.CompletedProfile reference) {
        LocalProfile profile;
        LocalProfile ref = (LocalProfile)reference;
        if (ref != null) {
            ClientProfile newClientProfile = new ClientProfileBuilder(ref.profile).setTitle(name).setInfo(description).setDir(name).setUuid(UUID.randomUUID()).createClientProfile();
            profile = new LocalProfile(this, newClientProfile, ref.clientDir, ref.assetDir);
            Path updatesDirPath = Path.of(this.updatesDir, new String[0]);
            try {
                IOHelper.copy((Path)updatesDirPath.resolve(ref.profile.getDir()), (Path)updatesDirPath.resolve(profile.profile.getDir()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            profile = new LocalProfile(this, new ClientProfileBuilder().setUuid(UUID.randomUUID()).setTitle(name).setInfo(description).setDir(name).setAssetDir("assets").createClientProfile(), null, this.getUpdatesDir("assets"));
        }
        this.pushProfileAndSave(profile);
        return profile;
    }

    @Override
    public void delete(ProfilesProvider.UncompletedProfile profile) {
        LocalProfile p = (LocalProfile)profile;
        this.profilesMap.remove(p.getUuid());
        try {
            Path updatesDirPath = Path.of(this.updatesDir, new String[0]);
            IOHelper.deleteDir((Path)updatesDirPath.resolve(p.profile.getDir()), (boolean)true);
            Files.delete(p.getConfigPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Set<ProfilesProvider.UncompletedProfile> getProfiles(Client client) {
        if (client == null) {
            return new HashSet<ProfilesProvider.UncompletedProfile>(this.profilesMap.values());
        }
        if (!client.isAuth) {
            return new HashSet<ProfilesProvider.UncompletedProfile>();
        }
        HashSet<ProfilesProvider.UncompletedProfile> profiles = new HashSet<ProfilesProvider.UncompletedProfile>();
        for (Map.Entry<UUID, LocalProfile> p : this.profilesMap.entrySet()) {
            UUID uuid = p.getKey();
            LocalProfile profile = p.getValue();
            if (profile.getProfile() != null && profile.getProfile().isLimited()) {
                if (!client.isAuth || client.permissions == null || !client.permissions.hasPerm(String.format("launchserver.profile.%s.show", uuid))) continue;
                profiles.add(profile);
                continue;
            }
            profiles.add(profile);
        }
        return profiles;
    }

    @Override
    public ProfilesProvider.CompletedProfile pushUpdate(ProfilesProvider.UncompletedProfile profile, String tag, ClientProfile clientProfile, List<ProfilesProvider.ProfileAction> assetActions, List<ProfilesProvider.ProfileAction> clientActions, List<ProfilesProvider.UpdateFlag> flags) throws IOException {
        Path updatesDirPath = Path.of(this.updatesDir, new String[0]);
        LocalProfile localProfile = (LocalProfile)profile;
        if (localProfile.profile != null && localProfile.getUuid() != null) {
            clientProfile = new ClientProfileBuilder(clientProfile).setUuid(localProfile.getUuid()).createClientProfile();
        }
        localProfile = new LocalProfile(this, clientProfile, localProfile.clientDir, localProfile.assetDir);
        localProfile.profile = clientProfile;
        if (flags.contains((Object)ProfilesProvider.UpdateFlag.USE_DEFAULT_ASSETS) && this.getUpdatesDir("assets") == null) {
            Path assetDirPath = updatesDirPath.resolve("assets");
            if (!Files.exists(assetDirPath, new LinkOption[0])) {
                Files.createDirectories(assetDirPath, new FileAttribute[0]);
            }
            HashedDir assetsHDir = new HashedDir(assetDirPath, null, true, true);
            this.updatesDirMap.put("assets", assetsHDir);
            localProfile.assetDir = assetsHDir;
        }
        if (assetActions != null && !assetActions.isEmpty()) {
            Path assetDir = updatesDirPath.resolve(clientProfile.getAssetDir());
            LocalProfilesProvider.execute(localProfile.assetDir, assetDir, assetActions);
            localProfile.assetDir = new HashedDir(assetDir, null, true, true);
        }
        if (clientActions != null && !clientActions.isEmpty()) {
            Path clientDir = updatesDirPath.resolve(clientProfile.getDir());
            LocalProfilesProvider.execute(localProfile.clientDir, clientDir, clientActions);
            localProfile.clientDir = new HashedDir(clientDir, null, true, true);
        }
        this.pushProfileAndSave(localProfile);
        return localProfile;
    }

    private void pushProfileAndSave(LocalProfile localProfile) {
        this.profilesMap.put(localProfile.getUuid(), localProfile);
        try (BufferedWriter writer = IOHelper.newWriter((Path)localProfile.getConfigPath());){
            Launcher.gsonManager.configGson.toJson((Object)localProfile.profile, (Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void download(ProfilesProvider.CompletedProfile profile, Map<String, Path> files, boolean assets) throws IOException {
        Path sourceDir = Path.of(this.updatesDir, new String[0]).resolve(assets ? profile.getProfile().getAssetDir() : profile.getProfile().getDir());
        for (Map.Entry<String, Path> e : files.entrySet()) {
            Path source = sourceDir.resolve(e.getKey());
            Path target = e.getValue();
            IOHelper.createParentDirs((Path)target);
            IOHelper.copy((Path)source, (Path)target);
        }
    }

    @Override
    public HashedDir getUnconnectedDirectory(String name) {
        return this.getUpdatesDir(name);
    }

    @Override
    public ProfilesProvider.CompletedProfile get(UUID uuid, String tag) {
        return this.profilesMap.get(uuid);
    }

    @Override
    public ProfilesProvider.CompletedProfile get(String name, String tag) {
        for (LocalProfile p : this.profilesMap.values()) {
            if (p.getName() == null || !p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    private void writeCache(Path file) throws IOException {
        try (HOutput output = new HOutput(IOHelper.newOutput((Path)file));){
            output.writeLength(this.updatesDirMap.size(), 0);
            for (Map.Entry<String, HashedDir> entry : this.updatesDirMap.entrySet()) {
                output.writeString(entry.getKey(), 0);
                entry.getValue().write(output);
            }
        }
        this.logger.debug("Saved {} updates to cache", (Object)this.updatesDirMap.size());
    }

    private void readCache(Path file) throws IOException {
        ConcurrentHashMap<String, HashedDir> updatesDirMap = new ConcurrentHashMap<String, HashedDir>(16);
        try (HInput input = new HInput(IOHelper.newInput((Path)file));){
            int size = input.readLength(0);
            for (int i = 0; i < size; ++i) {
                String name = input.readString(0);
                HashedDir dir = new HashedDir(input);
                updatesDirMap.put(name, dir);
            }
        }
        this.logger.debug("Found {} updates from cache", (Object)updatesDirMap.size());
        this.updatesDirMap = updatesDirMap;
    }

    public void readProfilesDir() throws IOException {
        Path profilesDirPath = Path.of(this.profilesDir, new String[0]);
        ConcurrentHashMap<UUID, LocalProfile> newProfiles = new ConcurrentHashMap<UUID, LocalProfile>();
        IOHelper.walk((Path)profilesDirPath, (FileVisitor)new ProfilesFileVisitor(newProfiles), (boolean)false);
        this.profilesMap = newProfiles;
    }

    public void readUpdatesDir() throws IOException {
        Path cacheFilePath = Path.of(this.cacheFile, new String[0]);
        if (this.cacheUpdates && Files.exists(cacheFilePath, new LinkOption[0])) {
            try {
                this.readCache(cacheFilePath);
                return;
            }
            catch (Throwable e) {
                this.logger.error("Read updates cache failed", e);
            }
        }
        this.sync(null);
    }

    public void sync(Collection<String> dirs) throws IOException {
        this.logger.info("Syncing updates dir");
        ConcurrentHashMap<String, HashedDir> newUpdatesDirMap = new ConcurrentHashMap<String, HashedDir>(16);
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(Path.of(this.updatesDir, new String[0]));){
            for (Path updateDir : dirStream) {
                HashedDir hdir;
                if (Files.isHidden(updateDir)) continue;
                String name = IOHelper.getFileName((Path)updateDir);
                if (!IOHelper.isDir((Path)updateDir)) {
                    if (IOHelper.isFile((Path)updateDir) || !Stream.of(".jar", ".exe", ".hash").noneMatch(e -> updateDir.toString().endsWith((String)e))) continue;
                    this.logger.warn("Not update dir: '{}'", (Object)name);
                    continue;
                }
                if (dirs != null && !dirs.contains(name) && (hdir = this.updatesDirMap.get(name)) != null) {
                    newUpdatesDirMap.put(name, hdir);
                    continue;
                }
                this.logger.info("Syncing '{}' update dir", (Object)name);
                HashedDir updateHDir = new HashedDir(updateDir, null, true, true);
                newUpdatesDirMap.put(name, updateHDir);
            }
        }
        this.updatesDirMap = newUpdatesDirMap;
        if (this.cacheUpdates) {
            try {
                this.writeCache(Path.of(this.cacheFile, new String[0]));
            }
            catch (Throwable e2) {
                this.logger.error("Write updates cache failed", e2);
            }
        }
        this.server.modulesManager.invokeEvent(new LaunchServerUpdatesSyncEvent(this.server));
    }

    public HashedDir getUpdatesDir(String updateName) {
        if (updateName == null) {
            return null;
        }
        return this.updatesDirMap.get(updateName);
    }

    @Override
    public void init(LaunchServer server) {
        super.init(server);
        if (server.env == LaunchServer.LaunchServerEnv.TEST) {
            return;
        }
        try {
            if (!IOHelper.isDir((Path)Path.of(this.updatesDir, new String[0]))) {
                Files.createDirectory(Path.of(this.updatesDir, new String[0]), new FileAttribute[0]);
            }
            this.readUpdatesDir();
        }
        catch (IOException e) {
            this.logger.error("Updates not synced", (Throwable)e);
        }
        try {
            Path profilesDirPath = Path.of(this.profilesDir, new String[0]);
            if (!IOHelper.isDir((Path)profilesDirPath)) {
                Files.createDirectory(profilesDirPath, new FileAttribute[0]);
            }
            this.readProfilesDir();
        }
        catch (IOException e) {
            this.logger.error("Profiles not synced", (Throwable)e);
        }
    }

    public static void execute(HashedDir dir, Path updatesDirPath, List<ProfilesProvider.ProfileAction> actions) throws IOException {
        for (ProfilesProvider.ProfileAction action : actions) {
            LocalProfilesProvider.execute(dir, updatesDirPath, action);
        }
    }

    public static void execute(HashedDir dir, Path updatesDirPath, ProfilesProvider.ProfileAction action) throws IOException {
        switch (action.type()) {
            case UPLOAD: {
                Path target = updatesDirPath.resolve(action.target());
                if (action.source() == null) {
                    IOHelper.createParentDirs((Path)target);
                    IOHelper.transfer((InputStream)action.input().get(), (Path)target);
                    break;
                }
                Path source = Path.of(action.source(), new String[0]);
                if (source.toAbsolutePath().equals(target.toAbsolutePath())) {
                    return;
                }
                if (action.deleteSource()) {
                    IOHelper.createParentDirs((Path)target);
                    IOHelper.move((Path)source, (Path)target);
                    break;
                }
                IOHelper.createParentDirs((Path)target);
                IOHelper.copy((Path)source, (Path)target);
                break;
            }
            case COPY: {
                Path source = updatesDirPath.resolve(action.source());
                Path target = updatesDirPath.resolve(action.target());
                if (source.toAbsolutePath().equals(target.toAbsolutePath())) {
                    return;
                }
                IOHelper.createParentDirs((Path)target);
                IOHelper.copy((Path)source, (Path)target);
                break;
            }
            case MOVE: {
                Path source = updatesDirPath.resolve(action.source());
                Path target = updatesDirPath.resolve(action.target());
                if (source.toAbsolutePath().equals(target.toAbsolutePath())) {
                    return;
                }
                IOHelper.createParentDirs((Path)target);
                IOHelper.move((Path)source, (Path)target);
                break;
            }
            case DELETE: {
                Path target = updatesDirPath.resolve(action.target());
                if (!Files.isDirectory(target, new LinkOption[0])) break;
                IOHelper.deleteDir((Path)target, (boolean)true);
            }
        }
    }

    @Override
    public Map<String, Command> getCommands() {
        return Map.of("sync", new SubCommand("[]", "sync all"){

            public void invoke(String ... args) throws Exception {
                try {
                    if (!IOHelper.isDir((Path)Path.of(LocalProfilesProvider.this.updatesDir, new String[0]))) {
                        Files.createDirectory(Path.of(LocalProfilesProvider.this.updatesDir, new String[0]), new FileAttribute[0]);
                    }
                    LocalProfilesProvider.this.sync(null);
                }
                catch (IOException e) {
                    LocalProfilesProvider.this.logger.error("Updates not synced", (Throwable)e);
                }
                try {
                    Path profilesDirPath = Path.of(LocalProfilesProvider.this.profilesDir, new String[0]);
                    if (!IOHelper.isDir((Path)profilesDirPath)) {
                        Files.createDirectory(profilesDirPath, new FileAttribute[0]);
                    }
                    LocalProfilesProvider.this.readProfilesDir();
                }
                catch (IOException e) {
                    LocalProfilesProvider.this.logger.error("Profiles not synced", (Throwable)e);
                }
                LocalProfilesProvider.this.logger.info("Profiles and updates synced");
            }
        });
    }

    public class LocalProfile
    implements ProfilesProvider.CompletedProfile {
        private volatile ClientProfile profile;
        private volatile HashedDir clientDir;
        private volatile HashedDir assetDir;
        private final Path configPath;

        public LocalProfile(LocalProfilesProvider this$0, ClientProfile profile, HashedDir clientDir, HashedDir assetDir) {
            this.profile = profile;
            this.clientDir = clientDir;
            this.assetDir = assetDir;
            this.configPath = Path.of(this$0.profilesDir, new String[0]).resolve(profile.getDir().concat(".json"));
        }

        public LocalProfile(LocalProfilesProvider this$0, ClientProfile profile, HashedDir clientDir, HashedDir assetDir, Path configPath) {
            this.profile = profile;
            this.clientDir = clientDir;
            this.assetDir = assetDir;
            this.configPath = configPath;
        }

        @Override
        public String getTag() {
            return null;
        }

        @Override
        public ClientProfile getProfile() {
            return this.profile;
        }

        @Override
        public HashedDir getClientDir() {
            return this.clientDir;
        }

        @Override
        public HashedDir getAssetDir() {
            return this.assetDir;
        }

        @Override
        public UUID getUuid() {
            return this.profile.getUUID();
        }

        @Override
        public String getName() {
            return this.profile.getTitle();
        }

        @Override
        public String getDescription() {
            return this.profile.getInfo();
        }

        @Override
        public String getDefaultTag() {
            return null;
        }

        public Path getConfigPath() {
            return this.configPath;
        }
    }

    private final class ProfilesFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Map<UUID, LocalProfile> result;
        private final Logger logger = LogManager.getLogger();

        private ProfilesFileVisitor(Map<UUID, LocalProfile> result) {
            this.result = result;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            ClientProfile profile;
            this.logger.info("Syncing '{}' profile", (Object)IOHelper.getFileName((Path)file));
            try (BufferedReader reader = IOHelper.newReader((Path)file);){
                profile = (ClientProfile)Launcher.gsonManager.gson.fromJson((Reader)reader, ClientProfile.class);
            }
            profile.verify();
            LocalProfile localProfile = new LocalProfile(LocalProfilesProvider.this, profile, LocalProfilesProvider.this.getUpdatesDir(profile.getDir()), LocalProfilesProvider.this.getUpdatesDir(profile.getAssetDir()), file);
            this.result.put(localProfile.getUuid(), localProfile);
            return super.visitFile(file, attrs);
        }
    }
}

