/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.binary;

import java.io.IOException;
import java.nio.file.Path;
import pro.gravit.launcher.core.api.features.CoreFeatureAPI;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.binary.BinaryPipeline;
import pro.gravit.launchserver.binary.PipelineContext;
import pro.gravit.launchserver.binary.tasks.LauncherBuildTask;

public abstract class LauncherBinary
extends BinaryPipeline {
    public final LaunchServer server;
    public final PipelineContext context;

    protected LauncherBinary(LaunchServer server) {
        this.server = server;
        this.context = new PipelineContext(server);
    }

    public static Path resolve(LaunchServer server, String ext) {
        return Path.of(server.config.binaryName + ext, new String[0]);
    }

    public PipelineContext build() throws IOException {
        long time_start;
        this.logger.info("Building launcher binary file");
        long time_this = time_start = System.currentTimeMillis();
        for (LauncherBuildTask task : this.tasks) {
            this.logger.info("Task {}", (Object)task.getName());
            Path newPath = task.process(this.context);
            if (newPath != null) {
                this.context.setLastest(newPath);
                this.context.putArtifact(task.getName(), newPath);
            }
            long time_task_end = System.currentTimeMillis();
            long time_task = time_task_end - time_this;
            time_this = time_task_end;
            this.logger.info("Task {} processed from {} millis", (Object)task.getName(), (Object)time_task);
        }
        long time_end = System.currentTimeMillis();
        this.logger.info("Build successful from {} millis", (Object)(time_end - time_start));
        return this.context;
    }

    public abstract CoreFeatureAPI.UpdateVariant getVariant();

    public void init() {
    }
}

