package pro.gravit.launchserver;

import pro.gravit.launchserver.config.LaunchServerConfig;
import pro.gravit.launchserver.config.LauncherModulesConfig;
import pro.gravit.launchserver.manangers.CertificateManager;
import pro.gravit.launchserver.manangers.KeyAgreementManager;
import pro.gravit.launchserver.modules.impl.LaunchServerModulesManager;
import pro.gravit.utils.command.CommandHandler;

import java.io.IOException;
import java.nio.file.Path;

public class LaunchServerBuilder {
    private LaunchServerConfig config;
    private CommandHandler commandHandler;
    private LaunchServer.LaunchServerEnv env;
    private LaunchServerModulesManager modulesManager;
    private LaunchServer.LaunchServerDirectories directories = new LaunchServer.LaunchServerDirectories();
    private KeyAgreementManager keyAgreementManager;
    private CertificateManager certificateManager;
    private LaunchServer.LaunchServerConfigManager launchServerConfigManager;
    private LauncherModulesConfig modulesConfig;
    private Integer shardId;

    public LaunchServerBuilder setConfig(LaunchServerConfig config) {
        this.config = config;
        return this;
    }

    public LaunchServerBuilder setEnv(LaunchServer.LaunchServerEnv env) {
        this.env = env;
        return this;
    }

    public LaunchServerBuilder setModulesManager(LaunchServerModulesManager modulesManager) {
        this.modulesManager = modulesManager;
        return this;
    }

    public LaunchServerBuilder setCommandHandler(CommandHandler commandHandler) {
        this.commandHandler = commandHandler;
        return this;
    }

    public LaunchServerBuilder setDirectories(LaunchServer.LaunchServerDirectories directories) {
        this.directories = directories;
        return this;
    }

    public LaunchServerBuilder setDir(Path dir) {
        this.directories.dir = dir;
        return this;
    }

    public LaunchServerBuilder setShardId(Integer shardId) {
        this.shardId = shardId;
        return this;
    }

    public LaunchServerBuilder setLaunchServerConfigManager(LaunchServer.LaunchServerConfigManager launchServerConfigManager) {
        this.launchServerConfigManager = launchServerConfigManager;
        return this;
    }

    public LaunchServer build() throws Exception {
        directories.collect();
        if (launchServerConfigManager == null) {
            launchServerConfigManager = new NullLaunchServerConfigManager();
        }
        if (keyAgreementManager == null) {
            keyAgreementManager = new KeyAgreementManager(directories.keyDirectory);
        }
        if(shardId == null) {
            shardId = Integer.parseInt(System.getProperty("launchserver.shardId", "0"));
        }
        return new LaunchServer(directories, env, config, launchServerConfigManager, modulesManager, keyAgreementManager, commandHandler, certificateManager, shardId, modulesConfig);
    }

    public LaunchServerBuilder setCertificateManager(CertificateManager certificateManager) {
        this.certificateManager = certificateManager;
        return this;
    }

    public LaunchServerBuilder setKeyAgreementManager(KeyAgreementManager keyAgreementManager) {
        this.keyAgreementManager = keyAgreementManager;
        return this;
    }

    public LaunchServerBuilder setModulesConfig(LauncherModulesConfig modulesConfig) {
        this.modulesConfig = modulesConfig;
        return this;
    }

    private static class NullLaunchServerConfigManager implements LaunchServer.LaunchServerConfigManager {
        @Override
        public LaunchServerConfig readConfig() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeConfig(LaunchServerConfig config) {
            throw new UnsupportedOperationException();
        }

        @Override
        public LauncherModulesConfig readModulesConfig() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeModulesConfig(LauncherModulesConfig config) throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}
