/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.config;

import io.netty.handler.logging.LogLevel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.base.LauncherConfig;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.AuthProviderPair;
import pro.gravit.launchserver.auth.core.RejectAuthCoreProvider;
import pro.gravit.launchserver.auth.profiles.LocalProfilesProvider;
import pro.gravit.launchserver.auth.profiles.ProfilesProvider;
import pro.gravit.launchserver.auth.protect.ProtectHandler;
import pro.gravit.launchserver.auth.protect.StdProtectHandler;
import pro.gravit.launchserver.auth.texture.RequestTextureProvider;
import pro.gravit.launchserver.auth.updates.LocalUpdatesProvider;
import pro.gravit.launchserver.auth.updates.UpdatesProvider;
import pro.gravit.launchserver.components.AuthLimiterComponent;
import pro.gravit.launchserver.components.Component;
import pro.gravit.launchserver.components.ProGuardComponent;
import pro.gravit.launchserver.socket.NettyObjectFactory;

public final class LaunchServerConfig {
    private static final List<String> oldMirrorList = List.of("https://mirror.gravit.pro/5.2.x/", "https://mirror.gravit.pro/5.3.x/", "https://mirror.gravitlauncher.com/5.2.x/", "https://mirror.gravitlauncher.com/5.3.x/", "https://mirror.gravitlauncher.com/5.4.x/", "https://mirror.gravitlauncher.com/5.5.x/", "https://mirror.gravitlauncher.com/5.6.x/");
    private final transient Logger logger = LogManager.getLogger();
    public String projectName;
    public String[] mirrors;
    public LauncherConfig.LauncherEnvironment env;
    public Map<String, AuthProviderPair> auth;
    public ProtectHandler protectHandler;
    public Map<String, Component> components;
    public ProfilesProvider profilesProvider = new LocalProfilesProvider();
    public UpdatesProvider updatesProvider = new LocalUpdatesProvider();
    public NettyConfig netty;
    public LauncherConf launcher;
    public JarSignerConf sign;
    private transient LaunchServer server = null;
    private transient AuthProviderPair authDefault;

    public static LaunchServerConfig getDefault(LaunchServer.LaunchServerEnv env) {
        LaunchServerConfig newConfig = new LaunchServerConfig();
        newConfig.mirrors = new String[]{"https://mirror.gravitlauncher.com/5.7.x/"};
        newConfig.env = LauncherConfig.LauncherEnvironment.STD;
        newConfig.auth = new HashMap<String, AuthProviderPair>();
        AuthProviderPair a = new AuthProviderPair(new RejectAuthCoreProvider(), new RequestTextureProvider("http://example.com/skins/%username%.png", "http://example.com/cloaks/%username%.png"));
        a.displayName = "Default";
        newConfig.auth.put("std", a);
        newConfig.protectHandler = new StdProtectHandler();
        newConfig.netty = new NettyConfig();
        newConfig.netty.fileServerEnabled = true;
        newConfig.netty.binds = new NettyBindAddress[]{new NettyBindAddress("0.0.0.0", 9274)};
        newConfig.netty.performance = new NettyPerformanceConfig();
        newConfig.netty.performance.mode = NettyObjectFactory.NettyFactoryMode.AUTO;
        newConfig.netty.performance.bossThread = 2;
        newConfig.netty.performance.workerThread = 8;
        newConfig.netty.performance.schedulerThread = 2;
        newConfig.launcher = new LauncherConf();
        newConfig.launcher.compress = true;
        newConfig.launcher.deleteTempFiles = true;
        newConfig.launcher.stripLineNumbers = true;
        newConfig.launcher.customJvmOptions.add("-Dfile.encoding=UTF-8");
        newConfig.sign = new JarSignerConf();
        newConfig.components = new HashMap<String, Component>();
        AuthLimiterComponent authLimiterComponent = new AuthLimiterComponent();
        authLimiterComponent.rateLimit = 3;
        authLimiterComponent.rateLimitMillis = TimeUnit.SECONDS.toMillis(8L);
        authLimiterComponent.message = "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d \u043b\u0438\u043c\u0438\u0442 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0439";
        newConfig.components.put("authLimiter", authLimiterComponent);
        ProGuardComponent proGuardComponent = new ProGuardComponent();
        newConfig.components.put("proguard", proGuardComponent);
        newConfig.profilesProvider = new LocalProfilesProvider();
        newConfig.updatesProvider = new LocalUpdatesProvider();
        return newConfig;
    }

    public void setLaunchServer(LaunchServer server) {
        this.server = server;
    }

    public AuthProviderPair getAuthProviderPair(String name) {
        return this.auth.get(name);
    }

    public AuthProviderPair getAuthProviderPair() {
        if (this.authDefault != null) {
            return this.authDefault;
        }
        for (AuthProviderPair pair : this.auth.values()) {
            if (!pair.isDefault) continue;
            this.authDefault = pair;
            return pair;
        }
        throw new IllegalStateException("Default AuthProviderPair not found");
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setEnv(LauncherConfig.LauncherEnvironment env) {
        this.env = env;
    }

    public void verify() {
        if (this.auth == null || this.auth.isEmpty()) {
            throw new NullPointerException("AuthProviderPair`s count should be at least one");
        }
        boolean isOneDefault = false;
        for (AuthProviderPair pair : this.auth.values()) {
            if (!pair.isDefault) continue;
            isOneDefault = true;
            break;
        }
        if (this.protectHandler == null) {
            throw new NullPointerException("ProtectHandler must not be null");
        }
        if (!isOneDefault) {
            throw new IllegalStateException("No auth pairs declared by default.");
        }
        if (this.env == null) {
            throw new NullPointerException("Env must not be null");
        }
        if (this.netty == null) {
            throw new NullPointerException("Netty must not be null");
        }
        boolean updateMirror = Boolean.getBoolean("launchserver.config.disableUpdateMirror");
        if (!updateMirror) {
            for (int i = 0; i < this.mirrors.length; ++i) {
                if (this.mirrors[i] == null || !oldMirrorList.contains(this.mirrors[i])) continue;
                this.logger.warn("Replace mirror '{}' to 'https://mirror.gravitlauncher.com/5.6.x/'. If you really need to use original url, use '-Dlaunchserver.config.disableUpdateMirror=true'", (Object)this.mirrors[i]);
                this.mirrors[i] = "https://mirror.gravitlauncher.com/5.7.x/";
            }
        }
    }

    public void init(LaunchServer.ReloadType type) {
        Launcher.applyLauncherEnv((LauncherConfig.LauncherEnvironment)this.env);
        for (Map.Entry<String, AuthProviderPair> provider : this.auth.entrySet()) {
            provider.getValue().init(this.server, provider.getKey());
        }
        if (this.protectHandler != null) {
            this.server.registerObject("protectHandler", this.protectHandler);
            this.protectHandler.init(this.server);
        }
        if (this.profilesProvider != null) {
            this.server.registerObject("profileProvider", this.profilesProvider);
            this.profilesProvider.init(this.server);
        }
        if (this.updatesProvider != null) {
            this.server.registerObject("updatesProvider", this.updatesProvider);
            this.updatesProvider.init(this.server);
        }
        if (this.components != null) {
            this.components.forEach((k, v) -> this.server.registerObject("component.".concat((String)k), v));
        }
        if (!type.equals((Object)LaunchServer.ReloadType.NO_AUTH)) {
            for (AuthProviderPair pair : this.auth.values()) {
                this.server.registerObject("auth.".concat(pair.name).concat(".core"), pair.core);
                this.server.registerObject("auth.".concat(pair.name).concat(".texture"), pair.textureProvider);
            }
        }
        Arrays.stream(this.mirrors).forEach(this.server.mirrorManager::addMirror);
    }

    public void close(LaunchServer.ReloadType type) {
        try {
            if (!type.equals((Object)LaunchServer.ReloadType.NO_AUTH)) {
                for (AuthProviderPair pair : this.auth.values()) {
                    this.server.unregisterObject("auth.".concat(pair.name).concat(".core"), pair.core);
                    this.server.unregisterObject("auth.".concat(pair.name).concat(".texture"), pair.textureProvider);
                    pair.close();
                }
            }
            if (type.equals((Object)LaunchServer.ReloadType.FULL)) {
                this.components.forEach((k, component) -> {
                    this.server.unregisterObject("component.".concat((String)k), component);
                    if (component instanceof AutoCloseable) {
                        AutoCloseable autoCloseable = (AutoCloseable)((Object)component);
                        try {
                            autoCloseable.close();
                        }
                        catch (Exception e) {
                            this.logger.error((Object)e);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        if (this.protectHandler != null) {
            this.server.unregisterObject("protectHandler", this.protectHandler);
            this.protectHandler.close();
        }
        if (this.profilesProvider != null) {
            this.server.unregisterObject("profilesProvider", this.profilesProvider);
            this.profilesProvider.close();
        }
        if (this.updatesProvider != null) {
            this.server.unregisterObject("updatesProvider", this.updatesProvider);
            this.updatesProvider.close();
        }
    }

    public static class NettyConfig {
        public boolean fileServerEnabled;
        public boolean ipForwarding;
        public boolean disableWebApiInterface;
        public boolean showHiddenFiles;
        public boolean sendProfileUpdatesEvent = true;
        public String downloadURL;
        public String address;
        public Map<String, NettyUpdatesBind> bindings = new HashMap<String, NettyUpdatesBind>();
        public NettyPerformanceConfig performance;
        public NettySecurityConfig security = new NettySecurityConfig();
        public NettyBindAddress[] binds;
        public LogLevel logLevel = LogLevel.DEBUG;
    }

    public static class NettyBindAddress {
        public String address;
        public int port;

        public NettyBindAddress(String address, int port) {
            this.address = address;
            this.port = port;
        }
    }

    public static class NettyPerformanceConfig {
        public NettyObjectFactory.NettyFactoryMode mode = NettyObjectFactory.NettyFactoryMode.AUTO;
        public int bossThread;
        public int workerThread;
        public int schedulerThread;
        public int maxWebSocketRequestBytes = 0x100000;
        public boolean disableThreadSafeClientObject;
        public NettyExecutorType executorType = NettyExecutorType.VIRTUAL_THREADS;

        public static enum NettyExecutorType {
            NONE,
            DEFAULT,
            WORK_STEAL,
            VIRTUAL_THREADS;

        }
    }

    public static class LauncherConf {
        public boolean compress;
        public boolean stripLineNumbers;
        public boolean deleteTempFiles;
        public boolean certificatePinning;
        public boolean encryptRuntime;
        public List<String> customJvmOptions = new ArrayList<String>();
        public Map<String, String> customJavaDownload = new HashMap<String, String>();
        public boolean forceUseCustomJava;
        public int memoryLimit = 256;
    }

    public static class JarSignerConf {
        public boolean enabled = false;
        public String keyStore = "pathToKey";
        public String keyStoreType = "JKS";
        public String keyStorePass = "mypass";
        public String keyAlias = "myname";
        public String keyPass = "mypass";
        public String metaInfKeyName = "SIGNUMO.RSA";
        public String metaInfSfName = "SIGNUMO.SF";
        public String signAlgo = "SHA256WITHRSA";
        public boolean checkCertificateExpired = true;
    }

    public static class NettySecurityConfig {
        public long hardwareTokenExpire = TimeUnit.HOURS.toSeconds(8L);
        public long publicKeyTokenExpire = TimeUnit.HOURS.toSeconds(8L);
        public long launcherTokenExpire = TimeUnit.HOURS.toSeconds(8L);
    }

    public static class NettyUpdatesBind {
        public String url;
        public boolean zip;
    }
}

