/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket.response.update;

import io.netty.channel.ChannelHandlerContext;
import pro.gravit.launcher.base.events.RequestEvent;
import pro.gravit.launcher.base.events.request.UpdateRequestEvent;
import pro.gravit.launcher.core.hasher.HashedDir;
import pro.gravit.launchserver.config.LaunchServerConfig;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.response.SimpleResponse;
import pro.gravit.utils.helper.IOHelper;

public class UpdateResponse
extends SimpleResponse {
    public String dirName;

    @Override
    public String getType() {
        return "update";
    }

    @Override
    public void execute(ChannelHandlerContext ctx, Client client) {
        if (this.dirName == null) {
            this.sendError("Invalid request");
            return;
        }
        if (client.profile == null) {
            this.sendError("Profile not setted");
            return;
        }
        HashedDir dir = null;
        dir = this.dirName.equals(client.profile.getProfile().getDir()) ? client.profile.getClientDir() : (this.dirName.equals(client.profile.getProfile().getAssetDir()) ? client.profile.getAssetDir() : this.server.config.profilesProvider.getUnconnectedDirectory(this.dirName));
        if (dir == null) {
            this.sendError("Directory %s not found".formatted(this.dirName));
            return;
        }
        String url = this.server.config.netty.downloadURL.replace("%dirname%", IOHelper.urlEncode((String)this.dirName));
        boolean zip = false;
        if (this.server.config.netty.bindings.get(this.dirName) != null) {
            LaunchServerConfig.NettyUpdatesBind bind = this.server.config.netty.bindings.get(this.dirName);
            url = bind.url;
            zip = bind.zip;
        }
        this.sendResult((RequestEvent)new UpdateRequestEvent(dir, url, zip));
    }
}

