/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.core.openid;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Header;
import io.jsonwebtoken.JweHeader;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.Locator;
import io.jsonwebtoken.LocatorAdapter;
import io.jsonwebtoken.io.Parser;
import io.jsonwebtoken.security.Jwk;
import io.jsonwebtoken.security.JwkSet;
import io.jsonwebtoken.security.Jwks;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.security.Key;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import pro.gravit.launcher.base.ClientPermissions;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.base.events.request.GetAvailabilityAuthRequestEvent;
import pro.gravit.launcher.base.request.auth.details.AuthWebViewDetails;
import pro.gravit.launcher.base.request.auth.password.AuthCodePassword;
import pro.gravit.launchserver.auth.AuthException;
import pro.gravit.launchserver.auth.core.AuthCoreProvider;
import pro.gravit.launchserver.auth.core.User;
import pro.gravit.launchserver.auth.core.UserSession;
import pro.gravit.launchserver.auth.core.openid.AccessTokenResponse;
import pro.gravit.launchserver.auth.core.openid.OpenIDConfig;
import pro.gravit.launchserver.auth.core.openid.QueryBuilder;
import pro.gravit.launchserver.auth.core.openid.TokenResponse;
import pro.gravit.launchserver.auth.core.openid.UserEntity;
import pro.gravit.utils.helper.CommonHelper;
import pro.gravit.utils.helper.QueryHelper;

public class OpenIDAuthenticator {
    private static final HttpClient CLIENT = HttpClient.newBuilder().build();
    private final OpenIDConfig openIDConfig;
    private final JwtParser jwtParser;

    public OpenIDAuthenticator(OpenIDConfig openIDConfig) {
        this.openIDConfig = openIDConfig;
        KeyLocator keyLocator = OpenIDAuthenticator.loadKeyLocator(openIDConfig);
        this.jwtParser = Jwts.parser().keyLocator((Locator)keyLocator).requireIssuer(openIDConfig.issuer()).require("azp", (Object)openIDConfig.clientId()).build();
    }

    public List<GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails> getDetails() {
        String state = UUID.randomUUID().toString();
        String uri = QueryBuilder.get(this.openIDConfig.authorizationEndpoint()).addQuery("response_type", "code").addQuery("client_id", this.openIDConfig.clientId()).addQuery("redirect_uri", this.openIDConfig.redirectUri()).addQuery("scope", this.openIDConfig.scopes()).addQuery("state", state).toUriString();
        return List.of(new AuthWebViewDetails(uri, this.openIDConfig.redirectUri()));
    }

    public TokenResponse refreshAccessToken(String oldRefreshToken) {
        String postBody = QueryBuilder.post().addQuery("grant_type", "refresh_token").addQuery("refresh_token", oldRefreshToken).addQuery("client_id", this.openIDConfig.clientId()).addQuery("client_secret", this.openIDConfig.clientSecret()).toString();
        AccessTokenResponse accessTokenResponse = this.requestToken(postBody);
        String accessToken = accessTokenResponse.accessToken();
        String refreshToken = accessTokenResponse.refreshToken();
        try {
            this.readAndVerifyToken(accessToken);
        }
        catch (AuthException e) {
            throw new RuntimeException(e);
        }
        Long accessTokenExpiresIn = Objects.requireNonNullElse(accessTokenResponse.expiresIn(), 0L);
        Long refreshTokenExpiresIn = Objects.requireNonNullElse(accessTokenResponse.refreshExpiresIn(), 0L);
        return new TokenResponse(accessToken, accessTokenExpiresIn, refreshToken, refreshTokenExpiresIn);
    }

    public UserSession getUserSessionByOAuthAccessToken(String accessToken) throws AuthCoreProvider.OAuthAccessTokenExpired {
        Jws<Claims> token;
        try {
            token = this.readAndVerifyToken(accessToken);
        }
        catch (AuthException e) {
            throw new AuthCoreProvider.OAuthAccessTokenExpired("Can't read token", e);
        }
        User user = this.createUserFromToken(token);
        long expiresIn = 0L;
        Date expDate = ((Claims)token.getPayload()).getExpiration();
        if (expDate != null) {
            expiresIn = expDate.toInstant().toEpochMilli();
        }
        return new OpenIDUserSession(user, accessToken, expiresIn);
    }

    public TokenResponse authorize(AuthCodePassword authCode) throws IOException {
        URI uri = URI.create(authCode.uri);
        Map queries = QueryHelper.splitUriQuery((URI)uri);
        String code = (String)CommonHelper.multimapFirstOrNullValue((Object)"code", (Map)queries);
        String error = (String)CommonHelper.multimapFirstOrNullValue((Object)"error", (Map)queries);
        String errorDescription = (String)CommonHelper.multimapFirstOrNullValue((Object)"error_description", (Map)queries);
        if (error != null && !error.isBlank()) {
            throw new AuthException("Auth error. Error: %s, description: %s".formatted(error, errorDescription));
        }
        String postBody = QueryBuilder.post().addQuery("grant_type", "authorization_code").addQuery("code", code).addQuery("redirect_uri", this.openIDConfig.redirectUri()).addQuery("client_id", this.openIDConfig.clientId()).addQuery("client_secret", this.openIDConfig.clientSecret()).toString();
        AccessTokenResponse accessTokenResponse = this.requestToken(postBody);
        String accessToken = accessTokenResponse.accessToken();
        String refreshToken = accessTokenResponse.refreshToken();
        this.readAndVerifyToken(accessToken);
        Long accessTokenExpiresIn = Objects.requireNonNullElse(accessTokenResponse.expiresIn(), 0L);
        Long refreshTokenExpiresIn = Objects.requireNonNullElse(accessTokenResponse.refreshExpiresIn(), 0L);
        return new TokenResponse(accessToken, accessTokenExpiresIn, refreshToken, refreshTokenExpiresIn);
    }

    public User createUserFromToken(String accessToken) throws AuthException {
        return this.createUserFromToken(this.readAndVerifyToken(accessToken));
    }

    private Jws<Claims> readAndVerifyToken(String accessToken) throws AuthException {
        if (accessToken == null) {
            throw new AuthException("Token is null");
        }
        try {
            return this.jwtParser.parseSignedClaims((CharSequence)accessToken);
        }
        catch (JwtException e) {
            throw new AuthException("Bad token", e);
        }
    }

    private User createUserFromToken(Jws<Claims> token) {
        String username = (String)((Claims)token.getPayload()).get(this.openIDConfig.extractorConfig().usernameClaim(), String.class);
        String uuidStr = (String)((Claims)token.getPayload()).get(this.openIDConfig.extractorConfig().uuidClaim(), String.class);
        UUID uuid = UUID.fromString(uuidStr);
        return new UserEntity(username, uuid, new ClientPermissions());
    }

    private AccessTokenResponse requestToken(String postBody) {
        HttpResponse<String> resp;
        HttpRequest request = HttpRequest.newBuilder().uri(this.openIDConfig.tokenUri()).header("Content-Type", "application/x-www-form-urlencoded").header("Accept", "application/json").POST(HttpRequest.BodyPublishers.ofString(postBody)).build();
        try {
            resp = CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        return (AccessTokenResponse)Launcher.gsonManager.gson.fromJson(resp.body(), AccessTokenResponse.class);
    }

    private static KeyLocator loadKeyLocator(OpenIDConfig openIDConfig) {
        HttpResponse<String> response;
        HttpRequest request = HttpRequest.newBuilder(openIDConfig.jwksUri()).GET().build();
        try {
            response = CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        JwkSet jwks = (JwkSet)((Parser)Jwks.setParser().build()).parse((CharSequence)response.body());
        return new KeyLocator(jwks);
    }

    private static class KeyLocator
    extends LocatorAdapter<Key> {
        private final Map<String, Key> keys;

        public KeyLocator(JwkSet jwks) {
            this.keys = jwks.getKeys().stream().collect(Collectors.toMap(jwk -> String.valueOf(jwk.get((Object)"kid")), Jwk::toKey));
        }

        protected Key locate(JweHeader header) {
            return (Key)super.locate(header);
        }

        protected Key locate(JwsHeader header) {
            return this.keys.get(header.getKeyId());
        }

        protected Key doLocate(Header header) {
            return (Key)super.doLocate(header);
        }
    }

    record OpenIDUserSession(User user, String token, long expiresIn) implements UserSession
    {
        @Override
        public String getID() {
            return this.user.getUsername();
        }

        @Override
        public User getUser() {
            return this.user;
        }

        @Override
        public String getMinecraftAccessToken() {
            return this.token;
        }

        @Override
        public long getExpireIn() {
            return this.expiresIn;
        }
    }
}

