/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.profiles;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launcher.core.hasher.HashedDir;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.profiles.LocalProfilesProvider;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.utils.ProviderMap;

public abstract class ProfilesProvider {
    public static final ProviderMap<ProfilesProvider> providers = new ProviderMap("ProfileProvider");
    private static boolean registredProviders = false;
    protected transient LaunchServer server;

    public static void registerProviders() {
        if (!registredProviders) {
            providers.register("local", LocalProfilesProvider.class);
            registredProviders = true;
        }
    }

    public void init(LaunchServer server) {
        this.server = server;
    }

    public abstract UncompletedProfile create(String var1, String var2, CompletedProfile var3);

    public abstract void delete(UncompletedProfile var1);

    public abstract Set<UncompletedProfile> getProfiles(Client var1);

    public abstract CompletedProfile pushUpdate(UncompletedProfile var1, String var2, ClientProfile var3, List<ProfileAction> var4, List<ProfileAction> var5, List<UpdateFlag> var6) throws IOException;

    public abstract void download(CompletedProfile var1, Map<String, Path> var2, boolean var3) throws IOException;

    public abstract HashedDir getUnconnectedDirectory(String var1);

    public abstract CompletedProfile get(UUID var1, String var2);

    public abstract CompletedProfile get(String var1, String var2);

    public CompletedProfile get(UncompletedProfile profile) {
        if (profile == null) {
            return null;
        }
        return this.get(profile.getUuid(), null);
    }

    public void close() {
    }

    public static interface UncompletedProfile {
        public UUID getUuid();

        public String getName();

        public String getDescription();

        public String getDefaultTag();
    }

    public static interface CompletedProfile
    extends UncompletedProfile {
        public String getTag();

        public ClientProfile getProfile();

        public HashedDir getClientDir();

        public HashedDir getAssetDir();
    }

    public static enum UpdateFlag {
        USE_DEFAULT_ASSETS,
        DELETE_SOURCE_FILES;

    }

    public record ProfileAction(ProfileActionType type, String source, String target, Supplier<InputStream> input, Consumer<OutputStream> output, boolean deleteSource) {
        public static ProfileAction upload(Path source, String target, boolean deleteSource) {
            return new ProfileAction(ProfileActionType.UPLOAD, source.toString(), target, null, null, deleteSource);
        }

        public static ProfileAction upload(Supplier<InputStream> input, String target) {
            return new ProfileAction(ProfileActionType.UPLOAD, null, target, input, null, false);
        }

        public static enum ProfileActionType {
            UPLOAD,
            COPY,
            MOVE,
            DELETE;

        }
    }
}

