/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.protect.interfaces;

import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPublicKey;
import java.security.spec.InvalidKeySpecException;
import pro.gravit.launcher.base.events.request.GetSecureLevelInfoRequestEvent;
import pro.gravit.launcher.base.events.request.SecurityReportRequestEvent;
import pro.gravit.launcher.base.events.request.VerifySecureLevelKeyRequestEvent;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.response.secure.SecurityReportResponse;
import pro.gravit.utils.helper.SecurityHelper;

public interface SecureProtectHandler {
    default public byte[] generateSecureLevelKey() {
        return SecurityHelper.randomBytes((int)128);
    }

    default public void verifySecureLevelKey(byte[] publicKey, byte[] data, byte[] signature) throws InvalidKeySpecException, SignatureException {
        if (publicKey == null || signature == null) {
            throw new InvalidKeySpecException();
        }
        ECPublicKey pubKey = SecurityHelper.toPublicECDSAKey((byte[])publicKey);
        Signature sign = SecurityHelper.newECVerifySignature((ECPublicKey)pubKey);
        sign.update(data);
        sign.verify(signature);
    }

    public GetSecureLevelInfoRequestEvent onGetSecureLevelInfo(GetSecureLevelInfoRequestEvent var1);

    public boolean allowGetSecureLevelInfo(Client var1);

    default public SecurityReportRequestEvent onSecurityReport(SecurityReportResponse report, Client client) {
        return new SecurityReportRequestEvent();
    }

    default public VerifySecureLevelKeyRequestEvent onSuccessVerify(Client client) {
        return new VerifySecureLevelKeyRequestEvent();
    }
}

