/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import me.tongfei.progressbar.ProgressBar;
import me.tongfei.progressbar.ProgressBarBuilder;
import me.tongfei.progressbar.ProgressBarStyle;
import pro.gravit.launcher.base.Downloader;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.utils.command.CommandException;

public abstract class Command
extends pro.gravit.utils.command.Command {
    protected final LaunchServer server;

    protected Command(LaunchServer server) {
        this.server = server;
    }

    public Command(Map<String, pro.gravit.utils.command.Command> childCommands, LaunchServer server) {
        super(childCommands);
        this.server = server;
    }

    protected ClientProfile.Version parseClientVersion(String arg) throws CommandException {
        if (arg.isEmpty()) {
            throw new CommandException("ClientVersion can't be empty");
        }
        return (ClientProfile.Version)Launcher.gsonManager.gson.fromJson(arg, ClientProfile.Version.class);
    }

    protected boolean showApplyDialog(String text) throws IOException {
        System.out.printf("%s [Y/N]:", text);
        String response = this.server.commandHandler.readLine().toLowerCase(Locale.ROOT);
        return response.equals("y");
    }

    public static Downloader downloadWithProgressBar(String taskName, List<Downloader.SizedFile> list, String baseUrl, Path targetDir) throws Exception {
        long total = 0L;
        for (Downloader.SizedFile file : list) {
            if (file.size < 0L) continue;
            total += file.size;
        }
        final long totalFiles = list.size();
        final AtomicLong current = new AtomicLong(0L);
        final AtomicLong currentFiles = new AtomicLong(0L);
        final ProgressBar bar = new ProgressBarBuilder().setTaskName(taskName).setInitialMax(total).showSpeed().setStyle(ProgressBarStyle.COLORFUL_UNICODE_BLOCK).setUnit("MB", 0x100000L).build();
        bar.setExtraMessage(" [0/%d]".formatted(totalFiles));
        Downloader downloader = Downloader.downloadList(list, (String)baseUrl, (Path)targetDir, (Downloader.DownloadCallback)new Downloader.DownloadCallback(){

            public void apply(long fullDiff) {
                current.addAndGet(fullDiff);
                bar.stepBy(fullDiff);
            }

            public void onComplete(Path path) {
                bar.setExtraMessage(" [%d/%d]".formatted(currentFiles.incrementAndGet(), totalFiles));
            }
        }, null, (int)4);
        downloader.getFuture().handle((v, e) -> {
            CompletableFuture future = new CompletableFuture();
            bar.close();
            if (e != null) {
                future.completeExceptionally((Throwable)e);
            } else {
                future.complete(null);
            }
            return future;
        });
        return downloader;
    }
}

