/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.hash;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.command.Command;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.SecurityHelper;

public final class IndexAssetCommand
extends Command {
    public static final String INDEXES_DIR = "indexes";
    public static final String OBJECTS_DIR = "objects";
    private static final String JSON_EXTENSION = ".json";
    private final transient Logger logger = LogManager.getLogger();

    public IndexAssetCommand(LaunchServer server) {
        super(server);
    }

    public static Path resolveIndexFile(Path assetDir, String name) {
        return assetDir.resolve(INDEXES_DIR).resolve(name + JSON_EXTENSION);
    }

    public static Path resolveObjectFile(Path assetDir, String hash) {
        return assetDir.resolve(OBJECTS_DIR).resolve(hash.substring(0, 2)).resolve(hash);
    }

    public String getArgsDescription() {
        return "[dir] [index] [output-dir]";
    }

    public String getUsageDescription() {
        return "Index asset dir (1.7.10+)";
    }

    public void invoke(String ... args) throws Exception {
    }

    private final class IndexAssetVisitor
    extends SimpleFileVisitor<Path> {
        private final JsonObject objects;
        private final Path inputAssetDir;
        private final Map<String, Path> uploadMap;

        private IndexAssetVisitor(JsonObject objects, Path inputAssetDir, Map<String, Path> uploadMap) {
            this.objects = objects;
            this.inputAssetDir = inputAssetDir;
            this.uploadMap = uploadMap;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            String name = IOHelper.toString((Path)this.inputAssetDir.relativize(file));
            IndexAssetCommand.this.logger.info("Indexing: '{}'", (Object)name);
            String digest = SecurityHelper.toHex((byte[])SecurityHelper.digest((SecurityHelper.DigestAlgorithm)SecurityHelper.DigestAlgorithm.SHA1, (Path)file));
            IndexObject obj = new IndexObject(attrs.size(), digest);
            this.objects.add(name, Launcher.gsonManager.gson.toJsonTree((Object)obj));
            this.uploadMap.put(IndexAssetCommand.resolveObjectFile(Path.of("", new String[0]), digest).toString(), file);
            return super.visitFile(file, attrs);
        }
    }

    public static class IndexObject {
        final long size;
        final String hash;

        public IndexObject(long size, String hash) {
            this.size = size;
            this.hash = hash;
        }
    }
}

