/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.modules;

import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.command.Command;

public class LoadLauncherModuleCommand
extends Command {
    private final transient Logger logger = LogManager.getLogger();

    public LoadLauncherModuleCommand(LaunchServer server) {
        super(server);
    }

    public String getArgsDescription() {
        return "[name or jar]";
    }

    public String getUsageDescription() {
        return "Launcher module jar file";
    }

    public void invoke(String ... args) throws Exception {
        this.verifyArgs(args, 1);
        Path file = Paths.get(args[0], new String[0]);
        String target = args[0];
        boolean bundled = false;
        if (!target.endsWith(".jar") && !Files.isDirectory(file, new LinkOption[0])) {
            file = this.server.modulesDir.resolve(args[0] + ".jar");
            bundled = true;
        }
        if (!Files.exists(file, new LinkOption[0]) && bundled) {
            target = target.concat("_lmodule");
            file = this.server.modulesDir.resolve(target + ".jar");
        }
        if (!Files.exists(file, new LinkOption[0])) {
            throw new FileNotFoundException(file.toString());
        }
        if (Files.isDirectory(file, new LinkOption[0])) {
            this.server.launcherModuleLoader.registerModule(file);
        } else {
            this.server.launcherModuleLoader.autoload(file);
        }
        if (!this.server.modulesConfig.loadLauncherModules.contains(target)) {
            this.server.modulesConfig.loadLauncherModules.add(target);
            this.server.launchServerConfigManager.writeModulesConfig(this.server.modulesConfig);
        }
        this.logger.info("Launcher module {} loaded from {}", (Object)target, (Object)file);
    }
}

