/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.modules;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.command.Command;

public class ModuleAvailableListCommand
extends Command {
    private final transient Logger logger = LogManager.getLogger();

    public ModuleAvailableListCommand(LaunchServer server) {
        super(server);
    }

    public String getArgsDescription() {
        return null;
    }

    public String getUsageDescription() {
        return "list available modules";
    }

    public void invoke(String ... args) throws IOException {
        try (Stream<Path> stream = Files.list(this.server.modulesDir);){
            stream.forEach(p -> {
                String file = p.getFileName().toString();
                if (!file.endsWith(".jar")) {
                    return;
                }
                if ((file = file.substring(0, file.length() - ".jar".length())).endsWith("_module")) {
                    file = file.substring(0, file.length() - "_module".length());
                    this.logger.info("Found LaunchServer module \t{}", (Object)file);
                } else if (file.endsWith("_lmodule")) {
                    file = file.substring(0, file.length() - "_lmodule".length());
                    this.logger.info("Found launcher module \t{}", (Object)file);
                } else {
                    this.logger.info("Found unknown module \t{}", (Object)file);
                }
            });
        }
    }
}

