/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.manangers;

import com.google.gson.JsonElement;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.utils.helper.IOHelper;

public class MirrorManager {
    protected final ArrayList<Mirror> list = new ArrayList();
    private final transient Logger logger = LogManager.getLogger();
    private final transient HttpClient client = HttpClient.newBuilder().build();
    private Mirror defaultMirror;

    public void addMirror(String mirror) {
        Mirror m = new Mirror(mirror);
        m.enabled = true;
        if (this.defaultMirror == null) {
            this.defaultMirror = m;
        }
        this.list.add(m);
    }

    public void addMirror(String mirror, boolean enabled) {
        Mirror m = new Mirror(mirror);
        m.enabled = enabled;
        if (this.defaultMirror == null && enabled) {
            this.defaultMirror = m;
        }
        this.list.add(m);
    }

    public Mirror getDefaultMirror() {
        return this.defaultMirror;
    }

    public void setDefaultMirror(Mirror m) {
        this.defaultMirror = m;
    }

    public void disableMirror(int index) {
        this.list.get((int)index).enabled = false;
    }

    public void enableMirror(int index) {
        this.list.get((int)index).enabled = true;
    }

    public int size() {
        return this.list.size();
    }

    public boolean downloadZip(Mirror mirror, Path path, String mask, Object ... args) throws IOException {
        if (!mirror.enabled) {
            return false;
        }
        URL url = mirror.getURL(mask, args);
        this.logger.debug("Try download {}", (Object)url.toString());
        try {
            this.downloadZip(url, path);
        }
        catch (IOException e) {
            this.logger.error("Download {} failed({}: {})", (Object)url.toString(), (Object)e.getClass().getName(), (Object)e.getMessage());
            return false;
        }
        return true;
    }

    public void downloadZip(Path path, String mask, Object ... args) throws IOException {
        if (this.downloadZip(this.defaultMirror, path, mask, args)) {
            return;
        }
        for (Mirror mirror : this.list) {
            if (mirror == this.defaultMirror || !this.downloadZip(mirror, path, mask, args)) continue;
            return;
        }
        throw new IOException("Error download %s. All mirrors return error".formatted(path.toString()));
    }

    public JsonElement jsonRequest(Mirror mirror, JsonElement request, String method, String mask, Object ... args) throws IOException {
        if (!mirror.enabled) {
            return null;
        }
        URL url = mirror.getURL(mask, args);
        try {
            HttpResponse<String> response = this.client.send(HttpRequest.newBuilder().method(method, request == null ? HttpRequest.BodyPublishers.noBody() : HttpRequest.BodyPublishers.ofString(Launcher.gsonManager.gson.toJson(request))).uri(url.toURI()).build(), HttpResponse.BodyHandlers.ofString());
            return (JsonElement)Launcher.gsonManager.gson.fromJson(response.body(), JsonElement.class);
        }
        catch (IOException | InterruptedException | URISyntaxException e) {
            this.logger.error("JsonRequest {} failed({}: {})", (Object)url.toString(), (Object)e.getClass().getName(), (Object)e.getMessage());
            return null;
        }
    }

    public JsonElement jsonRequest(JsonElement request, String method, String mask, Object ... args) throws IOException {
        JsonElement result = this.jsonRequest(this.defaultMirror, request, method, mask, args);
        if (result != null) {
            return result;
        }
        for (Mirror mirror : this.list) {
            if (mirror == this.defaultMirror || (result = this.jsonRequest(mirror, request, method, mask, args)) == null) continue;
            return result;
        }
        throw new IOException("Error jsonRequest. All mirrors return error");
    }

    private void downloadZip(URL url, Path dir) throws IOException {
        try (ZipInputStream input = IOHelper.newZipInput((URL)url);){
            Files.createDirectory(dir, new FileAttribute[0]);
            ZipEntry entry = input.getNextEntry();
            while (entry != null) {
                if (entry.isDirectory()) {
                    Files.createDirectory(dir.resolve(IOHelper.toPath((String)entry.getName())), new FileAttribute[0]);
                } else {
                    String name = entry.getName();
                    this.logger.debug("Downloading file: '{}'", (Object)name);
                    IOHelper.transfer((InputStream)input, (Path)dir.resolve(IOHelper.toPath((String)name)));
                }
                entry = input.getNextEntry();
            }
        }
    }

    public static class Mirror {
        final String baseUrl;
        boolean enabled;

        Mirror(String url) {
            this.baseUrl = url;
        }

        private URL formatArgs(String mask, Object ... args) throws MalformedURLException {
            Object[] data = Arrays.stream(args).map(e -> IOHelper.urlEncode((String)e.toString())).toArray();
            return new URL(this.baseUrl.concat(mask.formatted(data)));
        }

        public URL getURL(String mask, Object ... args) throws MalformedURLException {
            return this.formatArgs(mask, args);
        }
    }
}

