/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.helper;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import pro.gravit.launcher.base.Downloader;
import pro.gravit.launcher.core.hasher.HashedDir;
import pro.gravit.launchserver.HttpRequester;

public class AssetsDirHelper {
    public static final String MINECRAFT_VERSIONS_URL = "https://launchermeta.mojang.com/mc/game/version_manifest.json";
    public static final String RESOURCES_DOWNLOAD_URL = "https://resources.download.minecraft.net/";

    public static List<Downloader.SizedFile> makeToDownloadFiles(AssetInfo assetInfo, HashedDir updatesDir) {
        ArrayList<Downloader.SizedFile> toDownload = new ArrayList<Downloader.SizedFile>(128);
        for (Map.Entry e : assetInfo.assets.getAsJsonObject("objects").entrySet()) {
            JsonObject value = ((JsonElement)e.getValue()).getAsJsonObject();
            Object hash = value.get("hash").getAsString();
            hash = ((String)hash).substring(0, 2) + "/" + (String)hash;
            long size = value.get("size").getAsLong();
            String path = "objects/" + (String)hash;
            if (updatesDir.tryFindRecursive(path).isFound()) continue;
            toDownload.add(new Downloader.SizedFile((String)hash, path, size));
        }
        return toDownload;
    }

    public static AssetInfo getAssetInfo(HttpRequester requester, String versionName) throws IOException {
        MinecraftVersions versions = requester.send(requester.get(MINECRAFT_VERSIONS_URL, null), MinecraftVersions.class).getOrThrow();
        String profileUrl = null;
        for (MiniVersionInfo e : versions.versions) {
            if (!e.id.equals(versionName)) continue;
            profileUrl = e.url;
            break;
        }
        MiniVersion profileInfo = requester.send(requester.get(profileUrl, null), MiniVersion.class).getOrThrow();
        String assetsIndexUrl = profileInfo.assetIndex.url;
        String assetIndex = profileInfo.assetIndex.id;
        JsonObject assets = requester.send(requester.get(assetsIndexUrl, null), JsonObject.class).getOrThrow();
        return new AssetInfo(assetIndex, assets);
    }

    public record AssetInfo(String assetIndex, JsonObject assets) {
    }

    public record MinecraftVersions(List<MiniVersionInfo> versions) {
    }

    public record MiniVersionInfo(String id, String url) {
    }

    public record MiniVersion(MinecraftAssetIndexInfo assetIndex) {
    }

    public record MinecraftAssetIndexInfo(String id, String url) {
    }
}

