/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.launchermodules;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.core.LauncherTrustManager;
import pro.gravit.launcher.core.api.features.CoreFeatureAPI;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.asm.InjectClassAcceptor;
import pro.gravit.launchserver.binary.tasks.MainBuildTask;
import pro.gravit.launchserver.launchermodules.LauncherModuleClassLoader;
import pro.gravit.utils.helper.IOHelper;

public class LauncherModuleLoader {
    public final List<ModuleEntity> launcherModules = new ArrayList<ModuleEntity>();
    private final LaunchServer server;
    private volatile LauncherModuleClassLoader classLoader;
    private final transient Logger logger = LogManager.getLogger();

    public LauncherModuleLoader(LaunchServer server) {
        this.server = server;
    }

    public void init() {
        MainBuildTask mainTask = this.server.launcherBinaries.get(CoreFeatureAPI.UpdateVariant.JAR).getTaskByClass(MainBuildTask.class).get();
        mainTask.preBuildHook.registerHook(buildContext -> {
            for (ModuleEntity e : this.launcherModules) {
                if (e.propertyMap != null) {
                    buildContext.properties.putAll(e.propertyMap);
                }
                if (e.modernModule) {
                    buildContext.clientModules.add(e.moduleMainClass);
                } else {
                    buildContext.legacyClientModules.add(e.moduleMainClass);
                }
                buildContext.readerClassPath.add(new JarFile(e.path.toFile()));
            }
        });
        mainTask.postBuildHook.registerHook(buildContext -> {
            for (ModuleEntity e : this.launcherModules) {
                this.logger.debug("Put {} launcher module", (Object)e.path.toString());
                buildContext.pushJarFile(e.path, en -> false, en -> true);
            }
        });
        try {
            this.loadLauncherModules();
        }
        catch (IOException e) {
            this.logger.error((Object)e);
        }
    }

    public void loadLauncherModules() throws IOException {
        this.launcherModules.clear();
        for (String e : this.server.modulesConfig.loadLauncherModules) {
            Path filePath = Path.of(e, new String[0]);
            if (!e.endsWith(".jar") && !Files.isDirectory(filePath, new LinkOption[0])) {
                filePath = this.server.modulesDir.resolve(e + ".jar");
            }
            if (!Files.exists(filePath, new LinkOption[0])) {
                this.logger.warn("Module {} not found", (Object)filePath);
            }
            if (Files.isDirectory(filePath, new LinkOption[0])) {
                this.autoload(filePath);
                continue;
            }
            this.registerModule(filePath);
        }
    }

    public boolean registerModule(Path file) throws IOException {
        Attributes attributes;
        try (JarFile f = new JarFile(file.toFile());){
            attributes = f.getManifest().getMainAttributes();
        }
        String mainClass = attributes.getValue("Module-Main-Class");
        if (mainClass == null) {
            this.logger.error("In module {} MainClass not found", (Object)file.toString());
            return false;
        }
        if (this.classLoader == null) {
            this.classLoader = new LauncherModuleClassLoader(this.server.modulesManager.getModuleClassLoader());
        }
        this.classLoader.addURL(file.toUri().toURL());
        ModuleEntity entity = new ModuleEntity();
        entity.path = file;
        entity.moduleMainClass = mainClass;
        entity.moduleConfigClass = attributes.getValue("Module-Config-Class");
        String requiredModernJava = attributes.getValue("Required-Modern-Java");
        entity.modernModule = Boolean.parseBoolean(requiredModernJava);
        if (entity.moduleConfigClass != null) {
            entity.moduleConfigName = attributes.getValue("Module-Config-Name");
            if (entity.moduleConfigName == null) {
                this.logger.warn("Module-Config-Name in module {} null. Module not configured", (Object)file.toString());
                return false;
            }
            try {
                Object targetConfig;
                Class<?> clazz = this.classLoader.loadClass(entity.moduleConfigClass);
                Path configPath = this.server.modulesManager.getConfigManager().getModuleConfig(entity.moduleConfigName);
                Object defaultConfig = MethodHandles.publicLookup().findStatic(clazz, "getDefault", MethodType.methodType(Object.class)).invoke();
                if (!Files.exists(configPath, new LinkOption[0])) {
                    this.logger.debug("Write default config for module {} to {}", (Object)file.toString(), (Object)configPath.toString());
                    try (BufferedWriter writer = IOHelper.newWriter((Path)configPath);){
                        Launcher.gsonManager.configGson.toJson(defaultConfig, (Appendable)writer);
                    }
                    targetConfig = defaultConfig;
                } else {
                    try (BufferedReader reader = IOHelper.newReader((Path)configPath);){
                        targetConfig = Launcher.gsonManager.configGson.fromJson((Reader)reader, clazz);
                    }
                    catch (Exception e) {
                        this.logger.error("Error when reading config {} in module {}: {}", (Object)configPath, (Object)file, (Object)e);
                        return false;
                    }
                }
                if (entity.propertyMap == null) {
                    entity.propertyMap = new HashMap<String, Object>();
                }
                this.addClassFieldsToProperties(entity.propertyMap, "modules.".concat(entity.moduleConfigName.toLowerCase()), targetConfig, clazz);
            }
            catch (Throwable e) {
                this.logger.error((Object)e);
            }
        }
        this.launcherModules.add(entity);
        return true;
    }

    public void autoload(Path modulesDir) throws IOException {
        IOHelper.walk((Path)modulesDir, (FileVisitor)new ModulesVisitor(), (boolean)false);
    }

    public void addClassFieldsToProperties(Map<String, Object> propertyMap, String prefix, Object object, Class<?> classOfObject) throws IllegalAccessException {
        Field[] fields;
        for (Field field : fields = classOfObject.getFields()) {
            if ((field.getModifiers() & 8) != 0) continue;
            Object obj = field.get(object);
            String propertyName = prefix.concat(".").concat(field.getName().toLowerCase(Locale.US));
            if (InjectClassAcceptor.isSerializableValue(obj)) {
                this.logger.trace("Property name {}", (Object)propertyName);
                propertyMap.put(propertyName, obj);
                continue;
            }
            this.addClassFieldsToProperties(propertyMap, propertyName, obj, obj.getClass());
        }
    }

    public static class ModuleEntity {
        public Path path;
        public LauncherTrustManager.CheckClassResult checkResult;
        public String moduleMainClass;
        public String moduleConfigClass;
        public String moduleConfigName;
        public boolean modernModule;
        public Map<String, Object> propertyMap;
    }

    protected final class ModulesVisitor
    extends SimpleFileVisitor<Path> {
        private LauncherModuleClassLoader classLoader;

        private ModulesVisitor() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (file.toFile().getName().endsWith(".jar")) {
                LauncherModuleLoader.this.registerModule(file);
            }
            return super.visitFile(file, attrs);
        }
    }
}

