/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.asm;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import pro.gravit.utils.helper.IOHelper;

public class ClassMetadataReader
implements Closeable {
    private final Logger logger = LogManager.getLogger(ClassMetadataReader.class);
    private final List<JarFile> cp;
    private final Map<String, Module> moduleClassFinder;

    public ClassMetadataReader(List<JarFile> cp) {
        this.cp = cp;
        ModuleLayer moduleLayer = ModuleLayer.boot();
        this.moduleClassFinder = this.collectModulePackages(moduleLayer);
    }

    public ClassMetadataReader() {
        this.cp = new ArrayList<JarFile>();
        ModuleLayer moduleLayer = ModuleLayer.boot();
        this.moduleClassFinder = this.collectModulePackages(moduleLayer);
    }

    private Map<String, Module> collectModulePackages(ModuleLayer layer) {
        HashMap<String, Module> map = new HashMap<String, Module>();
        for (Module m : layer.modules()) {
            for (String p : m.getPackages()) {
                map.put(p, m);
            }
        }
        return map;
    }

    public List<JarFile> getCp() {
        return this.cp;
    }

    public void acceptVisitor(byte[] classData, ClassVisitor visitor) {
        new ClassReader(classData).accept(visitor, 0);
    }

    public void acceptVisitor(String className, ClassVisitor visitor) throws IOException {
        this.acceptVisitor(this.getClassData(className), visitor);
    }

    public void acceptVisitor(byte[] classData, ClassVisitor visitor, int flags) {
        new ClassReader(classData).accept(visitor, flags);
    }

    public void acceptVisitor(String className, ClassVisitor visitor, int flags) throws IOException {
        this.acceptVisitor(this.getClassData(className), visitor, flags);
    }

    public byte[] getClassData(String className) throws IOException {
        for (JarFile f : this.cp) {
            byte[] bytes;
            if (f.getEntry(className + ".class") == null) continue;
            try (InputStream in = f.getInputStream(f.getEntry(className + ".class"));){
                bytes = IOHelper.read((InputStream)in);
            }
            return bytes;
        }
        if (ClassMetadataReader.class.getModule().isNamed()) {
            String pkg = this.getClassPackage(className).replace('/', '.');
            Module module = this.moduleClassFinder.get(pkg);
            if (module != null) {
                InputStream stream;
                ClassLoader cl = module.getClassLoader();
                if (cl == null) {
                    cl = ClassLoader.getPlatformClassLoader();
                }
                if ((stream = cl.getResourceAsStream(className + ".class")) != null) {
                    try (InputStream inputStream = stream;){
                        byte[] byArray = IOHelper.read((InputStream)stream);
                        return byArray;
                    }
                }
                throw new FileNotFoundException("Class " + className + ".class");
            }
            throw new FileNotFoundException("Package " + pkg);
        }
        InputStream stream = ClassLoader.getSystemClassLoader().getResourceAsStream(className + ".class");
        if (stream != null) {
            try (InputStream inputStream = stream;){
                byte[] byArray = IOHelper.read((InputStream)stream);
                return byArray;
            }
        }
        throw new FileNotFoundException(className + ".class");
    }

    private String getClassPackage(String type) {
        int idx = type.lastIndexOf("/");
        if (idx <= 0) {
            return type;
        }
        return type.substring(0, idx);
    }

    public String getSuperClass(String type) {
        if (type.equals("java/lang/Object")) {
            return null;
        }
        try {
            return this.getSuperClassASM(type);
        }
        catch (Exception e) {
            this.logger.warn("getSuperClass: type {} not found ({}: {})", (Object)type, (Object)e.getClass().getName(), (Object)e.getMessage());
            return "java/lang/Object";
        }
    }

    protected String getSuperClassASM(String type) throws IOException {
        CheckSuperClassVisitor cv = new CheckSuperClassVisitor();
        this.acceptVisitor(type, (ClassVisitor)cv);
        return cv.superClassName;
    }

    public ArrayList<String> getSuperClasses(String type) {
        ArrayList<String> superclasses = new ArrayList<String>(1);
        superclasses.add(type);
        while ((type = this.getSuperClass(type)) != null) {
            superclasses.add(type);
        }
        Collections.reverse(superclasses);
        return superclasses;
    }

    @Override
    public void close() {
        this.cp.forEach(IOHelper::close);
        this.cp.clear();
    }

    private static class CheckSuperClassVisitor
    extends ClassVisitor {
        String superClassName;

        public CheckSuperClassVisitor() {
            super(589824);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.superClassName = superName;
        }
    }
}

