/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.updates;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import pro.gravit.launcher.core.api.features.CoreFeatureAPI;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.updates.LocalUpdatesProvider;
import pro.gravit.utils.ProviderMap;
import pro.gravit.utils.helper.SecurityHelper;

public abstract class UpdatesProvider {
    public static final ProviderMap<UpdatesProvider> providers = new ProviderMap("UpdatesProvider");
    private static boolean registredProviders = false;
    protected transient LaunchServer server;

    public static void registerProviders() {
        if (!registredProviders) {
            providers.register("local", LocalUpdatesProvider.class);
            registredProviders = true;
        }
    }

    public void init(LaunchServer server) {
        this.server = server;
    }

    public abstract void pushUpdate(List<UpdateUploadInfo> var1) throws IOException;

    public abstract UpdateInfo checkUpdates(CoreFeatureAPI.UpdateVariant var1, BuildSecretsCheck var2);

    protected boolean checkSecureHash(String secureHash, String secureSalt, String privateSecureToken) {
        if (secureHash == null || secureSalt == null) {
            return false;
        }
        byte[] normal_hash = SecurityHelper.digest((SecurityHelper.DigestAlgorithm)SecurityHelper.DigestAlgorithm.SHA256, (String)privateSecureToken.concat(".").concat(secureSalt));
        byte[] launcher_hash = Base64.getDecoder().decode(secureHash);
        return Arrays.equals(normal_hash, launcher_hash);
    }

    public void close() {
    }

    public record BuildSecretsCheck(String secureHash, String secureSalt, byte[] digest) {
    }

    public record BuildSecrets(String secureToken, byte[] digest) {
    }

    public record UpdateUploadInfo(Path path, CoreFeatureAPI.UpdateVariant variant, BuildSecrets secrets) {
    }

    public record UpdateInfo(String url) {
    }
}

