/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.binary;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launchserver.binary.tasks.LauncherBuildTask;

public abstract class BinaryPipeline {
    public final List<LauncherBuildTask> tasks = new ArrayList<LauncherBuildTask>();
    protected final transient Logger logger = LogManager.getLogger();

    public void addCounted(int count, Predicate<LauncherBuildTask> pred, LauncherBuildTask taskAdd) {
        ArrayList indexes = new ArrayList();
        this.tasks.stream().filter(pred).forEach(indexes::add);
        indexes.forEach(e -> this.tasks.add(this.tasks.indexOf(e) + count, taskAdd));
    }

    public void replaceCounted(int count, Predicate<LauncherBuildTask> pred, LauncherBuildTask taskRep) {
        ArrayList indexes = new ArrayList();
        this.tasks.stream().filter(pred).forEach(indexes::add);
        indexes.forEach(e -> this.tasks.set(this.tasks.indexOf(e) + count, taskRep));
    }

    public void addPre(Predicate<LauncherBuildTask> pred, LauncherBuildTask taskAdd) {
        this.addCounted(-1, pred, taskAdd);
    }

    public void add(Predicate<LauncherBuildTask> pred, LauncherBuildTask taskAdd) {
        this.addCounted(0, pred, taskAdd);
    }

    public void addAfter(Predicate<LauncherBuildTask> pred, LauncherBuildTask taskAdd) {
        this.addCounted(1, pred, taskAdd);
    }

    public void replacePre(Predicate<LauncherBuildTask> pred, LauncherBuildTask taskRep) {
        this.replaceCounted(-1, pred, taskRep);
    }

    public void replace(Predicate<LauncherBuildTask> pred, LauncherBuildTask taskRep) {
        this.replaceCounted(0, pred, taskRep);
    }

    public void replaceAfter(Predicate<LauncherBuildTask> pred, LauncherBuildTask taskRep) {
        this.replaceCounted(1, pred, taskRep);
    }

    public <T extends LauncherBuildTask> List<T> getTasksByClass(Class<T> taskClass) {
        return this.tasks.stream().filter(taskClass::isInstance).map(taskClass::cast).collect(Collectors.toList());
    }

    public <T extends LauncherBuildTask> Optional<T> getTaskByClass(Class<T> taskClass) {
        return this.tasks.stream().filter(taskClass::isInstance).map(taskClass::cast).findFirst();
    }

    public Optional<LauncherBuildTask> getTaskBefore(Predicate<LauncherBuildTask> pred) {
        LauncherBuildTask last = null;
        for (LauncherBuildTask e : this.tasks) {
            if (pred.test(e)) {
                return Optional.ofNullable(last);
            }
            last = e;
        }
        return Optional.empty();
    }
}

