/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket;

import io.netty.channel.ChannelFactory;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollIoHandler;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.uring.IoUring;
import io.netty.channel.uring.IoUringIoHandler;
import io.netty.channel.uring.IoUringServerSocketChannel;

public class NettyObjectFactory {
    private static NettyFactoryMode mode;

    public static void setMode(NettyFactoryMode mode) {
        NettyObjectFactory.mode = mode;
        if (mode == NettyFactoryMode.AUTO) {
            if (IoUring.isAvailable()) {
                NettyObjectFactory.mode = NettyFactoryMode.IO_URING;
                return;
            }
            if (Epoll.isAvailable()) {
                NettyObjectFactory.mode = NettyFactoryMode.EPOLL;
                return;
            }
            NettyObjectFactory.mode = NettyFactoryMode.NIO;
        }
    }

    public static NettyFactoryMode getMode() {
        return mode;
    }

    public static EventLoopGroup newEventLoopGroup(int threads, String poolName) {
        return switch (mode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> null;
            case 1 -> new MultiThreadIoEventLoopGroup(threads, NioIoHandler.newFactory());
            case 2 -> new MultiThreadIoEventLoopGroup(threads, EpollIoHandler.newFactory());
            case 3 -> new MultiThreadIoEventLoopGroup(threads, IoUringIoHandler.newFactory());
        };
    }

    public static ChannelFactory<? extends ServerChannel> getServerSocketChannelFactory() {
        return switch (mode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> null;
            case 1 -> NioServerSocketChannel::new;
            case 2 -> EpollServerSocketChannel::new;
            case 3 -> IoUringServerSocketChannel::new;
        };
    }

    public static enum NettyFactoryMode {
        AUTO,
        NIO,
        EPOLL,
        IO_URING;

    }
}

