/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.core;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Base64;
import java.util.LinkedList;
import java.util.UUID;
import pro.gravit.launcher.base.request.secure.HardwareReportRequest;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.AuthProviderPair;
import pro.gravit.launchserver.auth.HikariSQLSourceConfig;
import pro.gravit.launchserver.auth.MySQLSourceConfig;
import pro.gravit.launchserver.auth.SQLSourceConfig;
import pro.gravit.launchserver.auth.core.AbstractSQLCoreProvider;
import pro.gravit.launchserver.auth.core.User;
import pro.gravit.launchserver.auth.core.UserSession;
import pro.gravit.launchserver.auth.core.interfaces.UserHardware;
import pro.gravit.launchserver.auth.core.interfaces.provider.AuthSupportExtendedCheckServer;
import pro.gravit.launchserver.auth.core.interfaces.provider.AuthSupportHardware;
import pro.gravit.launchserver.auth.core.interfaces.session.UserSessionSupportHardware;
import pro.gravit.launchserver.socket.Client;

public class SQLCoreProvider
extends AbstractSQLCoreProvider
implements AuthSupportHardware,
AuthSupportExtendedCheckServer {
    public HikariSQLSourceConfig holder;
    public String hardwareIdColumn;
    public String tableHWID = "hwids";
    public String tableHWIDLog = "hwidLog";
    public double criticalCompareLevel = 1.0;
    private transient String sqlFindHardwareByPublicKey;
    private transient String sqlFindHardwareByData;
    private transient String sqlFindHardwareById;
    private transient String sqlCreateHardware;
    private transient String sqlCreateHWIDLog;
    private transient String sqlUpdateHardwarePublicKey;
    private transient String sqlUpdateHardwareBanned;
    private transient String sqlUpdateUsers;
    private transient String sqlUsersByHwidId;

    @Override
    public void close() {
        super.close();
        this.holder.close();
    }

    @Override
    public SQLSourceConfig getSQLConfig() {
        return this.holder;
    }

    @Override
    public void init(LaunchServer server, AuthProviderPair pair) {
        this.holder.init();
        super.init(server, pair);
        String userInfoCols = this.makeUserCols();
        String hardwareInfoCols = "id, hwDiskId, baseboardSerialNumber, displayId, bitness, totalMemory, logicalProcessors, physicalProcessors, processorMaxFreq, battery, id, graphicCard, banned, publicKey";
        if (this.sqlFindHardwareByPublicKey == null) {
            this.sqlFindHardwareByPublicKey = "SELECT %s FROM %s WHERE publicKey = ?".formatted(hardwareInfoCols, this.tableHWID);
        }
        if (this.sqlFindHardwareById == null) {
            this.sqlFindHardwareById = "SELECT %s FROM %s WHERE id = ?".formatted(hardwareInfoCols, this.tableHWID);
        }
        if (this.sqlUsersByHwidId == null) {
            this.sqlUsersByHwidId = "SELECT %s FROM %s WHERE %s = ?".formatted(userInfoCols, this.table, this.hardwareIdColumn);
        }
        if (this.sqlFindHardwareByData == null) {
            this.sqlFindHardwareByData = "SELECT %s FROM %s".formatted(hardwareInfoCols, this.tableHWID);
        }
        if (this.sqlCreateHardware == null) {
            this.sqlCreateHardware = "INSERT INTO %s (publickey, hwDiskId, baseboardSerialNumber, displayId, bitness, totalMemory, logicalProcessors, physicalProcessors, processorMaxFreq, graphicCard, battery, banned) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, '0')".formatted(this.tableHWID);
        }
        if (this.sqlCreateHWIDLog == null) {
            this.sqlCreateHWIDLog = "INSERT INTO %s (hwidId, newPublicKey) VALUES (?, ?)".formatted(this.tableHWIDLog);
        }
        if (this.sqlUpdateHardwarePublicKey == null) {
            this.sqlUpdateHardwarePublicKey = "UPDATE %s SET publicKey = ? WHERE id = ?".formatted(this.tableHWID);
        }
        this.sqlUpdateHardwareBanned = "UPDATE %s SET banned = ? WHERE id = ?".formatted(this.tableHWID);
        this.sqlUpdateUsers = "UPDATE %s SET %s = ? WHERE %s = ?".formatted(this.table, this.hardwareIdColumn, this.uuidColumn);
    }

    @Override
    protected String makeUserCols() {
        return super.makeUserCols().concat(", ").concat(this.hardwareIdColumn);
    }

    @Override
    protected SQLUser constructUser(ResultSet set) throws SQLException {
        return set.next() ? new SQLUser(UUID.fromString(set.getString(this.uuidColumn)), set.getString(this.usernameColumn), set.getString(this.accessTokenColumn), set.getString(this.serverIDColumn), set.getString(this.passwordColumn), set.getLong(this.hardwareIdColumn)) : null;
    }

    private SQLUserHardware fetchHardwareInfo(ResultSet set) throws SQLException {
        HardwareReportRequest.HardwareInfo hardwareInfo = new HardwareReportRequest.HardwareInfo();
        hardwareInfo.hwDiskId = set.getString("hwDiskId");
        hardwareInfo.baseboardSerialNumber = set.getString("baseboardSerialNumber");
        byte[] displayId = set.getBytes("displayId");
        hardwareInfo.displayId = displayId;
        hardwareInfo.bitness = set.getInt("bitness");
        hardwareInfo.totalMemory = set.getLong("totalMemory");
        hardwareInfo.logicalProcessors = set.getInt("logicalProcessors");
        hardwareInfo.physicalProcessors = set.getInt("physicalProcessors");
        hardwareInfo.processorMaxFreq = set.getLong("processorMaxFreq");
        hardwareInfo.battery = set.getBoolean("battery");
        hardwareInfo.graphicCard = set.getString("graphicCard");
        byte[] publicKey = set.getBytes("publicKey");
        long id = set.getLong("id");
        boolean banned = set.getBoolean("banned");
        return new SQLUserHardware(hardwareInfo, publicKey, id, banned);
    }

    private void setUserHardwareId(Connection connection, UUID uuid, long hwidId) throws SQLException {
        PreparedStatement s = connection.prepareStatement(this.sqlUpdateUsers);
        s.setLong(1, hwidId);
        s.setString(2, uuid.toString());
        s.executeUpdate();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public UserHardware getHardwareInfoByPublicKey(byte[] publicKey) {
        try (Connection connection = this.holder.getConnection();){
            UserHardware userHardware;
            block18: {
                ResultSet set;
                block16: {
                    SQLUserHardware sQLUserHardware;
                    block17: {
                        connection.setAutoCommit(false);
                        PreparedStatement s = connection.prepareStatement(this.sqlFindHardwareByPublicKey);
                        s.setBytes(1, publicKey);
                        set = s.executeQuery();
                        try {
                            if (!set.next()) break block16;
                            connection.commit();
                            sQLUserHardware = this.fetchHardwareInfo(set);
                            if (set == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (set != null) {
                                try {
                                    set.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        set.close();
                    }
                    return sQLUserHardware;
                }
                connection.commit();
                userHardware = null;
                if (set == null) break block18;
                set.close();
            }
            return userHardware;
        }
        catch (SQLException throwables) {
            this.logger.error("SQL Error", (Throwable)throwables);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public UserHardware getHardwareInfoByData(HardwareReportRequest.HardwareInfo info) {
        try (Connection connection = this.holder.getConnection();){
            connection.setAutoCommit(false);
            PreparedStatement s = connection.prepareStatement(this.sqlFindHardwareByData);
            try (ResultSet set = s.executeQuery();){
                while (set.next()) {
                    SQLUserHardware hw = this.fetchHardwareInfo(set);
                    AuthSupportHardware.HardwareInfoCompareResult result = this.compareHardwareInfo(hw.getHardwareInfo(), info);
                    if (result.compareLevel > this.criticalCompareLevel) {
                        connection.commit();
                        SQLUserHardware sQLUserHardware = hw;
                        return sQLUserHardware;
                    }
                    connection.commit();
                }
                return null;
            }
        }
        catch (SQLException throwables) {
            this.logger.error("SQL Error", (Throwable)throwables);
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public UserHardware getHardwareInfoById(String id) {
        try (Connection connection = this.holder.getConnection();){
            UserHardware userHardware;
            block18: {
                ResultSet set;
                block16: {
                    SQLUserHardware sQLUserHardware;
                    block17: {
                        connection.setAutoCommit(false);
                        PreparedStatement s = connection.prepareStatement(this.sqlFindHardwareById);
                        s.setLong(1, Long.parseLong(id));
                        set = s.executeQuery();
                        try {
                            if (!set.next()) break block16;
                            connection.commit();
                            sQLUserHardware = this.fetchHardwareInfo(set);
                            if (set == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (set != null) {
                                try {
                                    set.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        set.close();
                    }
                    return sQLUserHardware;
                }
                connection.commit();
                userHardware = null;
                if (set == null) break block18;
                set.close();
            }
            return userHardware;
        }
        catch (SQLException throwables) {
            this.logger.error("SQL Error", (Throwable)throwables);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public UserHardware createHardwareInfo(HardwareReportRequest.HardwareInfo hardwareInfo, byte[] publicKey) {
        try (Connection connection = this.holder.getConnection();){
            connection.setAutoCommit(false);
            PreparedStatement s = connection.prepareStatement(this.sqlCreateHardware, 1);
            s.setBytes(1, publicKey);
            s.setString(2, hardwareInfo.hwDiskId);
            s.setString(3, hardwareInfo.baseboardSerialNumber);
            s.setBytes(4, hardwareInfo.displayId == null ? null : hardwareInfo.displayId);
            s.setInt(5, hardwareInfo.bitness);
            s.setLong(6, hardwareInfo.totalMemory);
            s.setInt(7, hardwareInfo.logicalProcessors);
            s.setInt(8, hardwareInfo.physicalProcessors);
            s.setLong(9, hardwareInfo.processorMaxFreq);
            s.setString(10, hardwareInfo.graphicCard);
            s.setBoolean(11, hardwareInfo.battery);
            s.executeUpdate();
            try (ResultSet generatedKeys = s.getGeneratedKeys();){
                if (generatedKeys.next()) {
                    long id = generatedKeys.getLong(1);
                    connection.commit();
                    SQLUserHardware sQLUserHardware = new SQLUserHardware(hardwareInfo, publicKey, id, false);
                    return sQLUserHardware;
                }
            }
            connection.commit();
            UserHardware userHardware = null;
            return userHardware;
        }
        catch (SQLException throwables) {
            this.logger.error("SQL Error", (Throwable)throwables);
            return null;
        }
    }

    @Override
    public void connectUserAndHardware(UserSession userSession, UserHardware hardware) {
        AbstractSQLCoreProvider.SQLUserSession SQLUserSession2 = (AbstractSQLCoreProvider.SQLUserSession)userSession;
        SQLUser SQLUser2 = (SQLUser)SQLUserSession2.getUser();
        SQLUserHardware SQLUserHardware2 = (SQLUserHardware)hardware;
        if (SQLUser2.hwidId == SQLUserHardware2.id) {
            return;
        }
        SQLUser2.hwidId = SQLUserHardware2.id;
        try (Connection connection = this.holder.getConnection();){
            this.setUserHardwareId(connection, SQLUser2.getUUID(), SQLUserHardware2.id);
        }
        catch (SQLException throwables) {
            this.logger.error("SQL Error", (Throwable)throwables);
        }
    }

    @Override
    public void addPublicKeyToHardwareInfo(UserHardware hardware, byte[] publicKey) {
        SQLUserHardware SQLUserHardware2 = (SQLUserHardware)hardware;
        SQLUserHardware2.publicKey = publicKey;
        try (Connection connection = this.holder.getConnection();){
            connection.setAutoCommit(false);
            PreparedStatement s = connection.prepareStatement(this.sqlUpdateHardwarePublicKey);
            s.setBytes(1, publicKey);
            s.setLong(2, SQLUserHardware2.id);
            s.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            this.logger.error("SQL error", (Throwable)e);
        }
    }

    @Override
    public Iterable<User> getUsersByHardwareInfo(UserHardware hardware) {
        LinkedList<User> users = new LinkedList<User>();
        try (Connection c = this.holder.getConnection();){
            c.setAutoCommit(false);
            PreparedStatement s = c.prepareStatement(this.sqlUsersByHwidId);
            s.setLong(1, Long.parseLong(hardware.getId()));
            s.setQueryTimeout(MySQLSourceConfig.TIMEOUT);
            try (ResultSet set = s.executeQuery();){
                while (!set.isLast()) {
                    users.add(this.constructUser(set));
                }
            }
            c.commit();
        }
        catch (SQLException e) {
            this.logger.error("SQL error", (Throwable)e);
            return null;
        }
        return users;
    }

    @Override
    public void banHardware(UserHardware hardware) {
        SQLUserHardware SQLUserHardware2 = (SQLUserHardware)hardware;
        SQLUserHardware2.banned = true;
        try (Connection connection = this.holder.getConnection();){
            PreparedStatement s = connection.prepareStatement(this.sqlUpdateHardwareBanned);
            s.setBoolean(1, true);
            s.setLong(2, SQLUserHardware2.id);
            s.executeUpdate();
        }
        catch (SQLException e) {
            this.logger.error("SQL Error", (Throwable)e);
        }
    }

    @Override
    public void unbanHardware(UserHardware hardware) {
        SQLUserHardware SQLUserHardware2 = (SQLUserHardware)hardware;
        SQLUserHardware2.banned = false;
        try (Connection connection = this.holder.getConnection();){
            PreparedStatement s = connection.prepareStatement(this.sqlUpdateHardwareBanned);
            s.setBoolean(1, false);
            s.setLong(2, SQLUserHardware2.id);
            s.executeUpdate();
        }
        catch (SQLException e) {
            this.logger.error("SQL error", (Throwable)e);
        }
    }

    @Override
    protected AbstractSQLCoreProvider.SQLUserSession createSession(AbstractSQLCoreProvider.SQLUser user) {
        return new SQLUserSession(user);
    }

    @Override
    public UserSession extendedCheckServer(Client client, String username, String serverID) {
        AbstractSQLCoreProvider.SQLUser user = (AbstractSQLCoreProvider.SQLUser)this.getUserByUsername(username);
        if (user == null) {
            return null;
        }
        if (user.getUsername().equals(username) && user.getServerId().equals(serverID)) {
            return this.createSession(user);
        }
        return null;
    }

    public static class SQLUser
    extends AbstractSQLCoreProvider.SQLUser {
        protected long hwidId;

        public SQLUser(UUID uuid, String username, String accessToken, String serverId, String password, long hwidId) {
            super(uuid, username, accessToken, serverId, password);
            this.hwidId = hwidId;
        }

        @Override
        public String toString() {
            return "SQLUser{uuid=" + String.valueOf(this.uuid) + ", username='" + this.username + "', permissions=" + String.valueOf(this.permissions) + ", hwidId=" + this.hwidId + "}";
        }
    }

    public static class SQLUserHardware
    implements UserHardware {
        private final HardwareReportRequest.HardwareInfo hardwareInfo;
        private final long id;
        private byte[] publicKey;
        private boolean banned;

        public SQLUserHardware(HardwareReportRequest.HardwareInfo hardwareInfo, byte[] publicKey, long id, boolean banned) {
            this.hardwareInfo = hardwareInfo;
            this.publicKey = publicKey;
            this.id = id;
            this.banned = banned;
        }

        @Override
        public HardwareReportRequest.HardwareInfo getHardwareInfo() {
            return this.hardwareInfo;
        }

        @Override
        public byte[] getPublicKey() {
            return this.publicKey;
        }

        @Override
        public String getId() {
            return String.valueOf(this.id);
        }

        @Override
        public boolean isBanned() {
            return this.banned;
        }

        public String toString() {
            return "SQLUserHardware{hardwareInfo=" + String.valueOf(this.hardwareInfo) + ", publicKey=" + (this.publicKey == null ? null : new String(Base64.getEncoder().encode(this.publicKey))) + ", id=" + this.id + ", banned=" + this.banned + "}";
        }
    }

    public class SQLUserSession
    extends AbstractSQLCoreProvider.SQLUserSession
    implements UserSessionSupportHardware {
        private final transient SQLUser SQLUser;
        protected transient SQLUserHardware hardware;

        public SQLUserSession(AbstractSQLCoreProvider.SQLUser user) {
            super(user);
            this.SQLUser = (SQLUser)user;
        }

        @Override
        public String getHardwareId() {
            return this.SQLUser.hwidId == 0L ? null : String.valueOf(this.SQLUser.hwidId);
        }

        @Override
        public UserHardware getHardware() {
            if (this.hardware == null) {
                this.hardware = (SQLUserHardware)SQLCoreProvider.this.getHardwareInfoById(String.valueOf(this.SQLUser.hwidId));
            }
            return this.hardware;
        }
    }
}

