/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.updates;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.base.config.JsonConfigurable;
import pro.gravit.launcher.base.config.SimpleConfigurable;
import pro.gravit.launcher.core.api.features.CoreFeatureAPI;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.updates.UpdatesProvider;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.SecurityHelper;

public class LocalUpdatesProvider
extends UpdatesProvider {
    private final transient Logger logger = LogManager.getLogger();
    public String updatesDir = "updates";
    public String binaryName = "Launcher";
    public String buildSecretsFile = "build-secrets.json";
    public Map<CoreFeatureAPI.UpdateVariant, String> urls = new HashMap<CoreFeatureAPI.UpdateVariant, String>(Map.of(CoreFeatureAPI.UpdateVariant.JAR, "http://localhost:9274/Launcher.jar", CoreFeatureAPI.UpdateVariant.EXE_WINDOWS_X86_64, "http://localhost:9274/Launcher.exe"));
    public transient JsonConfigurable<BuildSecretsInfo> buildSecretsJson;
    private final transient Map<CoreFeatureAPI.UpdateVariant, byte[]> hashMap = new HashMap<CoreFeatureAPI.UpdateVariant, byte[]>();

    @Override
    public void init(LaunchServer server) {
        super.init(server);
        this.buildSecretsJson = new SimpleConfigurable(BuildSecretsInfo.class, Path.of(this.buildSecretsFile, new String[0]));
        if (server.env == LaunchServer.LaunchServerEnv.TEST) {
            return;
        }
        try {
            this.buildSecretsJson.generateConfigIfNotExists();
            this.buildSecretsJson.loadConfig();
        }
        catch (Exception e) {
            this.buildSecretsJson.setConfig((Object)((BuildSecretsInfo)this.buildSecretsJson.getDefaultConfig()));
        }
        try {
            this.sync(CoreFeatureAPI.UpdateVariant.JAR);
            this.sync(CoreFeatureAPI.UpdateVariant.EXE_WINDOWS_X86_64);
        }
        catch (IOException e) {
            this.logger.error("Error when syncing binaries", (Throwable)e);
        }
    }

    @Override
    public void pushUpdate(List<UpdatesProvider.UpdateUploadInfo> files) throws IOException {
        for (UpdatesProvider.UpdateUploadInfo e : files) {
            IOHelper.copy((Path)e.path(), (Path)this.getUpdate(e.variant()));
            ((BuildSecretsInfo)this.buildSecretsJson.getConfig()).secrets().put(e.variant(), e.secrets());
            this.sync(e.variant());
        }
        this.buildSecretsJson.saveConfig();
    }

    public void sync(CoreFeatureAPI.UpdateVariant variant) throws IOException {
        Path source = this.getUpdate(variant);
        if (!Files.exists(source, new LinkOption[0])) {
            this.logger.warn("Dont exist {} binary", (Object)variant);
            return;
        }
        byte[] hash = SecurityHelper.digest((SecurityHelper.DigestAlgorithm)SecurityHelper.DigestAlgorithm.SHA512, (Path)source);
        this.hashMap.put(variant, hash);
    }

    public Path getUpdate(CoreFeatureAPI.UpdateVariant variant) {
        return Path.of(this.updatesDir, new String[0]).resolve(switch (variant) {
            case CoreFeatureAPI.UpdateVariant.JAR -> this.binaryName.concat(".jar");
            case CoreFeatureAPI.UpdateVariant.EXE_WINDOWS_X86_64 -> this.binaryName.concat(".exe");
            case CoreFeatureAPI.UpdateVariant.EXE_WINDOWS_X86 -> this.binaryName.concat("_x32.exe");
            case CoreFeatureAPI.UpdateVariant.EXE_WINDOWS_ARM64 -> this.binaryName.concat("_arm64.exe");
            case CoreFeatureAPI.UpdateVariant.LINUX_X86_64 -> this.binaryName.concat("_linux");
            case CoreFeatureAPI.UpdateVariant.LINUX_ARM64 -> this.binaryName.concat("_linux_arm64");
            case CoreFeatureAPI.UpdateVariant.MACOS_X86_64 -> this.binaryName.concat("_macos");
            case CoreFeatureAPI.UpdateVariant.MACOS_ARM64 -> this.binaryName.concat("_macos_arm64");
            default -> this.binaryName;
        });
    }

    @Override
    public UpdatesProvider.UpdateInfo checkUpdates(CoreFeatureAPI.UpdateVariant variant, UpdatesProvider.BuildSecretsCheck buildSecretsCheck) {
        byte[] hash = this.hashMap.get(variant);
        if (hash == null) {
            return null;
        }
        if (this.checkSecureHash(buildSecretsCheck.secureHash(), buildSecretsCheck.secureSalt(), ((BuildSecretsInfo)this.buildSecretsJson.getConfig()).secrets().get(variant).secureToken()) && Arrays.equals(buildSecretsCheck.digest(), hash)) {
            return null;
        }
        return new UpdatesProvider.UpdateInfo(this.urls.get(variant));
    }

    public static final class BuildSecretsInfo {
        private Map<CoreFeatureAPI.UpdateVariant, UpdatesProvider.BuildSecrets> secrets = new HashMap<CoreFeatureAPI.UpdateVariant, UpdatesProvider.BuildSecrets>();

        public BuildSecretsInfo(Map<CoreFeatureAPI.UpdateVariant, UpdatesProvider.BuildSecrets> secrets) {
            this.secrets = secrets;
        }

        public BuildSecretsInfo() {
        }

        public Map<CoreFeatureAPI.UpdateVariant, UpdatesProvider.BuildSecrets> secrets() {
            return this.secrets;
        }
    }
}

