/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.binary;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.core.api.features.CoreFeatureAPI;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.updates.UpdatesProvider;
import pro.gravit.utils.helper.SecurityHelper;

public class PipelineContext {
    private final Logger logger = LogManager.getLogger();
    private final LaunchServer launchServer;
    private final Map<String, Path> artifacts = new HashMap<String, Path>();
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final Set<Path> tempFiles = new HashSet<Path>();
    private Path lastest;

    public PipelineContext(LaunchServer launchServer) {
        this.launchServer = launchServer;
    }

    public Path makeTempPath(String name, String ext) throws IOException {
        return this.launchServer.createTempFilePath(name, ext);
    }

    public Map<String, Path> getArtifacts() {
        return this.artifacts;
    }

    public Path getLastest() {
        return this.lastest;
    }

    public void setLastest(Path lastest) {
        this.lastest = lastest;
    }

    public void putArtifact(String name, Path path) {
        this.artifacts.put(name, path);
    }

    public void putProperty(String name, Object prop) {
        this.properties.put(name, prop);
    }

    public void putProperties(Map<String, Object> properties) {
        this.properties.putAll(properties);
    }

    public LaunchServer getLaunchServer() {
        return this.launchServer;
    }

    public <T> T getProperty(String name) {
        return (T)this.properties.get(name);
    }

    public UpdatesProvider.UpdateUploadInfo makeUploadInfo(CoreFeatureAPI.UpdateVariant variant) {
        if (this.getLastest() == null) {
            return null;
        }
        try {
            byte[] hash = SecurityHelper.digest((SecurityHelper.DigestAlgorithm)SecurityHelper.DigestAlgorithm.SHA512, (Path)this.getLastest());
            return new UpdatesProvider.UpdateUploadInfo(this.getLastest(), variant, new UpdatesProvider.BuildSecrets((String)this.getProperty("checkClientSecret"), hash));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void clear() {
        for (Path p : this.tempFiles) {
            if (!Files.exists(p, new LinkOption[0])) continue;
            try {
                Files.delete(p);
            }
            catch (IOException e) {
                this.logger.error("Couldn't delete file {}", (Object)p, (Object)e);
            }
        }
        this.tempFiles.clear();
        this.properties.clear();
        this.artifacts.clear();
    }
}

