/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.binary.tasks;

import java.io.IOException;
import java.nio.file.Path;
import java.security.cert.CertificateEncodingException;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import pro.gravit.launcher.base.LauncherConfig;
import pro.gravit.launcher.core.api.features.CoreFeatureAPI;
import pro.gravit.launcher.core.serialize.stream.StreamObject;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.asm.ClassMetadataReader;
import pro.gravit.launchserver.asm.SafeClassWriter;
import pro.gravit.launchserver.binary.BuildContext;
import pro.gravit.launchserver.binary.JARLauncherBinary;
import pro.gravit.launchserver.binary.PipelineContext;
import pro.gravit.launchserver.binary.tasks.CertificateAutogenTask;
import pro.gravit.launchserver.binary.tasks.LauncherBuildTask;
import pro.gravit.utils.HookException;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.SecurityHelper;

public class MainBuildTask
implements LauncherBuildTask {
    public final ClassMetadataReader reader;
    public final Set<String> blacklist = new HashSet<String>();
    public final IOHookSet<BuildContext> preBuildHook = new IOHookSet();
    public final IOHookSet<BuildContext> postBuildHook = new IOHookSet();
    private final LaunchServer server;
    private final transient Logger logger = LogManager.getLogger();

    public MainBuildTask(LaunchServer srv) {
        this.server = srv;
        this.reader = new ClassMetadataReader();
    }

    @Override
    public String getName() {
        return "MainBuild";
    }

    @Override
    public Path process(PipelineContext pipelineContext) throws IOException {
        Path inputJar = pipelineContext.getLastest();
        Path outputJar = pipelineContext.makeTempPath("main", ".jar");
        try (ZipOutputStream output = new ZipOutputStream(IOHelper.newOutput((Path)outputJar));){
            BuildContext context = new BuildContext(pipelineContext, output, this.reader.getCp(), this, ((JARLauncherBinary)this.server.launcherBinaries.get((Object)CoreFeatureAPI.UpdateVariant.JAR)).runtimeDir);
            this.initProps(context);
            this.preBuildHook.hook(context);
            context.properties.put("launcher.legacymodules", context.legacyClientModules.stream().map(e -> Type.getObjectType((String)e.replace('.', '/'))).collect(Collectors.toList()));
            context.properties.put("launcher.modules", context.clientModules.stream().map(e -> Type.getObjectType((String)e.replace('.', '/'))).collect(Collectors.toList()));
            this.postInitProps(context);
            this.reader.getCp().add(new JarFile(inputJar.toFile()));
            for (Path e2 : ((JARLauncherBinary)this.server.launcherBinaries.get((Object)CoreFeatureAPI.UpdateVariant.JAR)).coreLibs) {
                this.reader.getCp().add(new JarFile(e2.toFile()));
            }
            context.pushJarFile(inputJar, e -> this.blacklist.contains(e.getName()) || e.getName().startsWith("pro/gravit/launcher/runtime/debug/"), e -> true);
            HashMap<String, byte[]> runtime = new HashMap<String, byte[]>(256);
            if (this.server.config.launcher.encryptRuntime) {
                String runtimeEncryptKey = (String)context.pipelineContext.getProperty("runtimeEncryptKey");
                context.pushEncryptedDir(context.getRuntimeDir(), "runtime", runtimeEncryptKey, runtime, false);
            } else {
                context.pushDir(context.getRuntimeDir(), "runtime", runtime, false);
            }
            if (context.isDeleteRuntimeDir()) {
                IOHelper.deleteDir((Path)context.getRuntimeDir(), (boolean)true);
            }
            LauncherConfig launcherConfig = new LauncherConfig(this.server.config.netty.address, this.server.keyAgreementManager.ecdsaPublicKey, this.server.keyAgreementManager.rsaPublicKey, runtime, this.server.config.projectName);
            context.pushFile("config.bin", (StreamObject)launcherConfig);
            this.postBuildHook.hook(context);
        }
        this.reader.close();
        return outputJar;
    }

    protected void postInitProps(BuildContext context) {
        List certificates = Arrays.stream(this.server.certificateManager.trustManager.getTrusted()).map(e -> {
            try {
                return e.getEncoded();
            }
            catch (CertificateEncodingException e2) {
                this.logger.error("Certificate encoding failed", (Throwable)e2);
                return new byte[0];
            }
        }).collect(Collectors.toList());
        if (!this.server.config.sign.enabled) {
            CertificateAutogenTask task = this.server.launcherBinaries.get(CoreFeatureAPI.UpdateVariant.JAR).getTaskByClass(CertificateAutogenTask.class).get();
            try {
                certificates.add(task.certificate.getEncoded());
            }
            catch (CertificateEncodingException e2) {
                throw new InternalError(e2);
            }
        }
        context.properties.put("launchercore.certificates", certificates);
    }

    protected void initProps(BuildContext context) {
        context.properties.clear();
        context.properties.put("launcher.address", this.server.config.netty.address);
        context.properties.put("launcher.projectName", this.server.config.projectName);
        context.properties.put("runtimeconfig.secretKeyClient", SecurityHelper.randomStringAESKey());
        context.properties.put("launcher.port", 32148 + SecurityHelper.newRandom().nextInt(512));
        context.properties.put("launchercore.env", this.server.config.env);
        context.properties.put("launcher.memory", this.server.config.launcher.memoryLimit);
        context.properties.put("launcher.customJvmOptions", this.server.config.launcher.customJvmOptions);
        context.properties.put("runtimeconfig.customJavaDownload", this.server.config.launcher.customJavaDownload);
        context.properties.put("runtimeconfig.forceUseCustomJava", this.server.config.launcher.forceUseCustomJava);
        if (this.server.config.launcher.encryptRuntime) {
            String runtimeEncryptKey = SecurityHelper.randomStringToken();
            context.pipelineContext.putProperty("runtimeEncryptKey", runtimeEncryptKey);
            context.properties.put("runtimeconfig.runtimeEncryptKey", runtimeEncryptKey);
        }
        context.properties.put("launcher.certificatePinning", this.server.config.launcher.certificatePinning);
        String checkClientSecret = SecurityHelper.randomStringToken();
        context.pipelineContext.putProperty("checkClientSecret", checkClientSecret);
        String launcherSalt = SecurityHelper.randomStringToken();
        byte[] launcherSecureHash = SecurityHelper.digest((SecurityHelper.DigestAlgorithm)SecurityHelper.DigestAlgorithm.SHA256, (String)checkClientSecret.concat(".").concat(launcherSalt));
        context.properties.put("runtimeconfig.secureCheckHash", Base64.getEncoder().encodeToString(launcherSecureHash));
        context.properties.put("runtimeconfig.secureCheckSalt", launcherSalt);
        String unlockSecret = SecurityHelper.randomStringToken();
        context.pipelineContext.putProperty("unlockSecret", unlockSecret);
        context.properties.put("runtimeconfig.unlockSecret", unlockSecret);
    }

    public byte[] transformClass(byte[] bytes, String classname, BuildContext context) {
        SafeClassWriter writer;
        byte[] result = bytes;
        ClassNode cn = null;
        for (Transformer t : context.transformers) {
            byte[] old_result;
            if (t instanceof ASMTransformer) {
                ASMTransformer asmTransformer = (ASMTransformer)t;
                if (cn == null) {
                    ClassReader cr = new ClassReader(result);
                    cn = new ClassNode();
                    cr.accept((ClassVisitor)cn, 0);
                }
                asmTransformer.transform(cn, classname, context);
                continue;
            }
            if (cn != null) {
                writer = new SafeClassWriter(this.reader, 0);
                cn.accept((ClassVisitor)writer);
                result = writer.toByteArray();
            }
            if ((old_result = result) == (result = t.transform(result, classname, context))) continue;
            cn = null;
        }
        if (cn != null) {
            writer = new SafeClassWriter(this.reader, 0);
            cn.accept((ClassVisitor)writer);
            result = writer.toByteArray();
        }
        return result;
    }

    public static class IOHookSet<R> {
        public final Set<IOHook<R>> list = new HashSet<IOHook<R>>();

        public void registerHook(IOHook<R> hook) {
            this.list.add(hook);
        }

        public boolean unregisterHook(IOHook<R> hook) {
            return this.list.remove(hook);
        }

        public void hook(R context) throws HookException, IOException {
            for (IOHook<R> hook : this.list) {
                hook.hook(context);
            }
        }

        @FunctionalInterface
        public static interface IOHook<R> {
            public void hook(R var1) throws HookException, IOException;
        }
    }

    @FunctionalInterface
    public static interface Transformer {
        public byte[] transform(byte[] var1, String var2, BuildContext var3);
    }

    public static interface ASMTransformer
    extends Transformer {
        @Override
        default public byte[] transform(byte[] input, String classname, BuildContext context) {
            ClassReader reader = new ClassReader(input);
            ClassNode cn = new ClassNode();
            reader.accept((ClassVisitor)cn, 0);
            this.transform(cn, classname, context);
            SafeClassWriter writer = new SafeClassWriter(context.task.reader, 0);
            cn.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }

        public void transform(ClassNode var1, String var2, BuildContext var3);
    }

    public static abstract class ASMAnnotationFieldProcessor
    implements ASMTransformer {
        private final String desc;

        protected ASMAnnotationFieldProcessor(String desc) {
            this.desc = desc;
        }

        @Override
        public void transform(ClassNode cn, String classname, BuildContext context) {
            for (FieldNode fn : cn.fields) {
                if (fn.invisibleAnnotations == null || fn.invisibleAnnotations.isEmpty()) continue;
                AnnotationNode found = null;
                for (AnnotationNode an : fn.invisibleAnnotations) {
                    if (an == null || !this.desc.equals(an.desc)) continue;
                    found = an;
                    break;
                }
                if (found == null) continue;
                this.transformField(found, fn, cn, classname, context);
            }
        }

        public abstract void transformField(AnnotationNode var1, FieldNode var2, ClassNode var3, String var4, BuildContext var5);
    }
}

